/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.factory.map.primitive.ImmutableIntCharMapFactory;
import org.eclipse.collections.api.map.primitive.ImmutableIntCharMap;
import org.eclipse.collections.api.map.primitive.IntCharMap;
import org.eclipse.collections.impl.factory.primitive.IntCharMaps;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableIntCharEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableIntCharHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableIntCharSingletonMap;

public class ImmutableIntCharMapFactoryImpl
implements ImmutableIntCharMapFactory {
    public static final ImmutableIntCharMapFactory INSTANCE = new ImmutableIntCharMapFactoryImpl();

    public ImmutableIntCharMap empty() {
        return ImmutableIntCharEmptyMap.INSTANCE;
    }

    public ImmutableIntCharMap of() {
        return this.empty();
    }

    public ImmutableIntCharMap with() {
        return this.empty();
    }

    public ImmutableIntCharMap of(int key, char value) {
        return this.with(key, value);
    }

    public ImmutableIntCharMap with(int key, char value) {
        return new ImmutableIntCharSingletonMap(key, value);
    }

    public ImmutableIntCharMap ofAll(IntCharMap map) {
        return this.withAll(map);
    }

    public ImmutableIntCharMap withAll(IntCharMap map) {
        if (map instanceof ImmutableIntCharMap) {
            return (ImmutableIntCharMap)map;
        }
        if (map.isEmpty()) {
            return this.with();
        }
        if (map.size() == 1) {
            int key = map.keysView().intIterator().next();
            return new ImmutableIntCharSingletonMap(key, map.get(key));
        }
        return new ImmutableIntCharHashMap(map);
    }

    public <T> ImmutableIntCharMap from(Iterable<T> iterable, IntFunction<? super T> keyFunction, CharFunction<? super T> valueFunction) {
        return IntCharMaps.mutable.from(iterable, keyFunction, valueFunction).toImmutable();
    }
}

