/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.factory.map.primitive.ImmutableFloatDoubleMapFactory;
import org.eclipse.collections.api.map.primitive.FloatDoubleMap;
import org.eclipse.collections.api.map.primitive.ImmutableFloatDoubleMap;
import org.eclipse.collections.impl.factory.primitive.FloatDoubleMaps;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableFloatDoubleEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableFloatDoubleHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableFloatDoubleSingletonMap;

public class ImmutableFloatDoubleMapFactoryImpl
implements ImmutableFloatDoubleMapFactory {
    public static final ImmutableFloatDoubleMapFactory INSTANCE = new ImmutableFloatDoubleMapFactoryImpl();

    public ImmutableFloatDoubleMap empty() {
        return ImmutableFloatDoubleEmptyMap.INSTANCE;
    }

    public ImmutableFloatDoubleMap of() {
        return this.empty();
    }

    public ImmutableFloatDoubleMap with() {
        return this.empty();
    }

    public ImmutableFloatDoubleMap of(float key, double value) {
        return this.with(key, value);
    }

    public ImmutableFloatDoubleMap with(float key, double value) {
        return new ImmutableFloatDoubleSingletonMap(key, value);
    }

    public ImmutableFloatDoubleMap ofAll(FloatDoubleMap map) {
        return this.withAll(map);
    }

    public ImmutableFloatDoubleMap withAll(FloatDoubleMap map) {
        if (map instanceof ImmutableFloatDoubleMap) {
            return (ImmutableFloatDoubleMap)map;
        }
        if (map.isEmpty()) {
            return this.with();
        }
        if (map.size() == 1) {
            float key = map.keysView().floatIterator().next();
            return new ImmutableFloatDoubleSingletonMap(key, map.get(key));
        }
        return new ImmutableFloatDoubleHashMap(map);
    }

    public <T> ImmutableFloatDoubleMap from(Iterable<T> iterable, FloatFunction<? super T> keyFunction, DoubleFunction<? super T> valueFunction) {
        return FloatDoubleMaps.mutable.from(iterable, keyFunction, valueFunction).toImmutable();
    }
}

