/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableIntBag;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ByteIntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.map.primitive.ByteIntMap;
import org.eclipse.collections.api.map.primitive.ImmutableByteIntMap;
import org.eclipse.collections.api.map.primitive.ImmutableIntByteMap;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.tuple.primitive.ByteIntPair;
import org.eclipse.collections.impl.bag.mutable.primitive.IntHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableIntCollection;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.IntBags;
import org.eclipse.collections.impl.factory.primitive.IntByteMaps;
import org.eclipse.collections.impl.iterator.ImmutableEmptyIntIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableByteIntSingletonMap;
import org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableByteSet;
import org.eclipse.collections.impl.utility.LazyIterate;
import org.eclipse.collections.impl.utility.primitive.LazyByteIterate;

final class ImmutableByteIntEmptyMap
implements ImmutableByteIntMap,
Serializable {
    static final ImmutableByteIntMap INSTANCE = new ImmutableByteIntEmptyMap();
    private static final long serialVersionUID = 1L;
    private static final int EMPTY_VALUE = 0;

    ImmutableByteIntEmptyMap() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public int get(byte key) {
        return 0;
    }

    public int getIfAbsent(byte key, int ifAbsent) {
        return ifAbsent;
    }

    public int getOrThrow(byte key) {
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(byte key) {
        return false;
    }

    public boolean containsValue(int value) {
        return false;
    }

    public void forEachValue(IntProcedure procedure) {
    }

    public void forEachKey(ByteProcedure procedure) {
    }

    public void forEachKeyValue(ByteIntProcedure procedure) {
    }

    public LazyByteIterable keysView() {
        return LazyByteIterate.empty();
    }

    public RichIterable<ByteIntPair> keyValuesView() {
        return LazyIterate.empty();
    }

    public ImmutableIntByteMap flipUniqueValues() {
        return IntByteMaps.immutable.empty();
    }

    public ImmutableByteIntMap select(ByteIntPredicate predicate) {
        return this;
    }

    public ImmutableByteIntMap reject(ByteIntPredicate predicate) {
        return this;
    }

    public ImmutableByteIntMap toImmutable() {
        return this;
    }

    public IntIterator intIterator() {
        return ImmutableEmptyIntIterator.INSTANCE;
    }

    public void forEach(IntProcedure procedure) {
    }

    public void each(IntProcedure procedure) {
    }

    public int count(IntPredicate predicate) {
        return 0;
    }

    public long sum() {
        return 0L;
    }

    public int min() {
        throw new NoSuchElementException();
    }

    public int max() {
        throw new NoSuchElementException();
    }

    public int maxIfEmpty(int defaultValue) {
        return defaultValue;
    }

    public int minIfEmpty(int defaultValue) {
        return defaultValue;
    }

    public double average() {
        throw new ArithmeticException();
    }

    public double median() {
        throw new ArithmeticException();
    }

    public int[] toSortedArray() {
        return new int[0];
    }

    public MutableIntList toSortedList() {
        return new IntArrayList();
    }

    public boolean anySatisfy(IntPredicate predicate) {
        return false;
    }

    public boolean allSatisfy(IntPredicate predicate) {
        return true;
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        return true;
    }

    public ImmutableIntBag select(IntPredicate predicate) {
        return IntBags.immutable.empty();
    }

    public ImmutableIntBag reject(IntPredicate predicate) {
        return IntBags.immutable.empty();
    }

    public <V> ImmutableBag<V> collect(IntToObjectFunction<? extends V> function) {
        return Bags.immutable.empty();
    }

    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return ifNone;
    }

    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    public RichIterable<IntIterable> chunk(int size) {
        return Lists.immutable.empty();
    }

    public int[] toArray() {
        return new int[0];
    }

    public int[] toArray(int[] target) {
        return target;
    }

    public boolean contains(int value) {
        return false;
    }

    public boolean containsAll(int ... source) {
        return source.length == 0;
    }

    public boolean containsAll(IntIterable source) {
        return source.isEmpty();
    }

    public MutableIntList toList() {
        return new IntArrayList();
    }

    public MutableIntSet toSet() {
        return new IntHashSet();
    }

    public MutableIntBag toBag() {
        return new IntHashBag();
    }

    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter((IntIterable)this);
    }

    public ImmutableByteIntMap newWithKeyValue(byte key, int value) {
        return new ImmutableByteIntSingletonMap(key, value);
    }

    public ImmutableByteIntMap newWithoutKey(byte key) {
        return this;
    }

    public ImmutableByteIntMap newWithoutAllKeys(ByteIterable keys) {
        return this;
    }

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public boolean notEmpty() {
        return false;
    }

    public MutableByteSet keySet() {
        return UnmodifiableByteSet.of(new ByteHashSet());
    }

    public MutableIntCollection values() {
        return UnmodifiableIntCollection.of((MutableIntCollection)new IntArrayList());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ByteIntMap)) {
            return false;
        }
        ByteIntMap map = (ByteIntMap)obj;
        return map.isEmpty();
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return "{}";
    }

    public String makeString() {
        return "";
    }

    public String makeString(String separator) {
        return "";
    }

    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    public void appendString(Appendable appendable) {
    }

    public void appendString(Appendable appendable, String separator) {
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

