/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.mutable;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.RandomAccess;
import org.eclipse.collections.api.block.HashingStrategy;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.ordered.OrderedIterable;
import org.eclipse.collections.api.partition.list.PartitionMutableList;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.block.procedure.CollectionAddProcedure;
import org.eclipse.collections.impl.lazy.ReverseIterable;
import org.eclipse.collections.impl.list.mutable.AbstractListAdapter;
import org.eclipse.collections.impl.list.mutable.SynchronizedMutableList;
import org.eclipse.collections.impl.list.mutable.UnmodifiableMutableList;
import org.eclipse.collections.impl.multimap.list.FastListMultimap;
import org.eclipse.collections.impl.utility.ArrayIterate;
import org.eclipse.collections.impl.utility.ArrayListIterate;
import org.eclipse.collections.impl.utility.internal.RandomAccessListIterate;

public final class ArrayListAdapter<T>
extends AbstractListAdapter<T>
implements RandomAccess,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ArrayList<T> delegate;

    private ArrayListAdapter(ArrayList<T> newDelegate) {
        if (newDelegate == null) {
            throw new NullPointerException("ArrayListAdapter may not wrap null");
        }
        this.delegate = newDelegate;
    }

    @Override
    protected ArrayList<T> getDelegate() {
        return this.delegate;
    }

    public static <E> ArrayListAdapter<E> newList() {
        return new ArrayListAdapter(new ArrayList());
    }

    public static <E> ArrayListAdapter<E> newList(int size) {
        return new ArrayListAdapter(new ArrayList(size));
    }

    public static <E> ArrayListAdapter<E> adapt(ArrayList<E> newDelegate) {
        return new ArrayListAdapter<E>(newDelegate);
    }

    public MutableList<T> asUnmodifiable() {
        return UnmodifiableMutableList.of(this);
    }

    public MutableList<T> asSynchronized() {
        return SynchronizedMutableList.of(this);
    }

    @Override
    public ArrayListAdapter<T> clone() {
        return new ArrayListAdapter<T>((ArrayList)this.delegate.clone());
    }

    public ArrayListAdapter<T> newEmpty() {
        return ArrayListAdapter.newList();
    }

    @Override
    public void each(Procedure<? super T> procedure) {
        ArrayListIterate.forEach(this.delegate, procedure);
    }

    public void reverseForEach(Procedure<? super T> procedure) {
        ArrayListIterate.reverseForEach(this.delegate, procedure);
    }

    public void reverseForEachWithIndex(ObjectIntProcedure<? super T> procedure) {
        ArrayListIterate.reverseForEachWithIndex(this.delegate, procedure);
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super T> objectIntProcedure) {
        ArrayListIterate.forEachWithIndex(this.delegate, objectIntProcedure);
    }

    public void forEachWithIndex(int fromIndex, int toIndex, ObjectIntProcedure<? super T> objectIntProcedure) {
        ArrayListIterate.forEachWithIndex(this.delegate, fromIndex, toIndex, objectIntProcedure);
    }

    @Override
    public T detect(Predicate<? super T> predicate) {
        return ArrayListIterate.detect(this.delegate, predicate);
    }

    @Override
    public T detectIfNone(Predicate<? super T> predicate, Function0<? extends T> function) {
        T result = this.detect(predicate);
        return (T)(result == null ? function.value() : result);
    }

    @Override
    public int count(Predicate<? super T> predicate) {
        return ArrayListIterate.count(this.delegate, predicate);
    }

    public <S> boolean corresponds(OrderedIterable<S> other, Predicate2<? super T, ? super S> predicate) {
        return RandomAccessListIterate.corresponds(this.delegate, other, predicate);
    }

    @Override
    public boolean anySatisfy(Predicate<? super T> predicate) {
        return ArrayListIterate.anySatisfy(this.delegate, predicate);
    }

    @Override
    public boolean allSatisfy(Predicate<? super T> predicate) {
        return ArrayListIterate.allSatisfy(this.delegate, predicate);
    }

    @Override
    public boolean noneSatisfy(Predicate<? super T> predicate) {
        return ArrayListIterate.noneSatisfy(this.delegate, predicate);
    }

    @Override
    public <IV> IV injectInto(IV injectedValue, Function2<? super IV, ? super T, ? extends IV> function) {
        return ArrayListIterate.injectInto(injectedValue, this.delegate, function);
    }

    public void forEach(int fromIndex, int toIndex, Procedure<? super T> procedure) {
        ArrayListIterate.forEach(this.delegate, fromIndex, toIndex, procedure);
    }

    public void sort(Comparator<? super T> comparator) {
        this.delegate.sort(comparator);
    }

    public ArrayListAdapter<T> sortThis(Comparator<? super T> comparator) {
        return (ArrayListAdapter)super.sortThis(comparator);
    }

    public ArrayListAdapter<T> sortThis() {
        return (ArrayListAdapter)super.sortThis();
    }

    public ArrayListAdapter<T> with(T element) {
        this.add(element);
        return this;
    }

    public ArrayListAdapter<T> with(T element1, T element2) {
        this.add(element1);
        this.add(element2);
        return this;
    }

    public ArrayListAdapter<T> with(T element1, T element2, T element3) {
        this.add(element1);
        this.add(element2);
        this.add(element3);
        return this;
    }

    public ArrayListAdapter<T> with(T ... elements) {
        ArrayIterate.forEach(elements, CollectionAddProcedure.on(this.delegate));
        return this;
    }

    public ArrayListAdapter<T> without(T element) {
        this.remove(element);
        return this;
    }

    public ArrayListAdapter<T> withAll(Iterable<? extends T> elements) {
        this.addAllIterable(elements);
        return this;
    }

    public ArrayListAdapter<T> withoutAll(Iterable<? extends T> elements) {
        this.removeAllIterable(elements);
        return this;
    }

    @Override
    private <E> ArrayListAdapter<E> wrap(ArrayList<E> list) {
        return ArrayListAdapter.adapt(list);
    }

    @Override
    public ArrayListAdapter<T> select(Predicate<? super T> predicate) {
        return this.wrap(ArrayListIterate.select(this.delegate, predicate));
    }

    @Override
    public ArrayListAdapter<T> reject(Predicate<? super T> predicate) {
        return this.wrap(ArrayListIterate.reject(this.delegate, predicate));
    }

    @Override
    public PartitionMutableList<T> partition(Predicate<? super T> predicate) {
        return ArrayListIterate.partition(this.delegate, predicate);
    }

    @Override
    public <P> PartitionMutableList<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return ArrayListIterate.partitionWith(this.getDelegate(), predicate, parameter);
    }

    @Override
    public <S> MutableList<S> selectInstancesOf(Class<S> clazz) {
        return ArrayListIterate.selectInstancesOf(this.delegate, clazz);
    }

    @Override
    public <V> ArrayListAdapter<V> collect(Function<? super T, ? extends V> function) {
        return this.wrap(ArrayListIterate.collect(this.delegate, function));
    }

    @Override
    public <V> ArrayListAdapter<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return this.wrap(ArrayListIterate.flatCollect(this.delegate, function));
    }

    @Override
    public <V> ArrayListAdapter<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return this.wrap(ArrayListIterate.collectIf(this.delegate, predicate, function));
    }

    public int detectIndex(Predicate<? super T> predicate) {
        return ArrayListIterate.detectIndex(this.delegate, predicate);
    }

    public int detectLastIndex(Predicate<? super T> predicate) {
        return ArrayListIterate.detectLastIndex(this.delegate, predicate);
    }

    @Override
    public <V> FastListMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        return ArrayListIterate.groupBy(this.delegate, function);
    }

    @Override
    public <V> FastListMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        return ArrayListIterate.groupByEach(this.delegate, function);
    }

    @Override
    public <P> ArrayListAdapter<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.wrap(ArrayListIterate.selectWith(this.delegate, predicate, parameter));
    }

    @Override
    public <P> ArrayListAdapter<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.wrap(ArrayListIterate.rejectWith(this.delegate, predicate, parameter));
    }

    @Override
    public <P, A> ArrayListAdapter<A> collectWith(Function2<? super T, ? super P, ? extends A> function, P parameter) {
        return this.wrap(ArrayListIterate.collectWith(this.delegate, function, parameter));
    }

    public ArrayListAdapter<T> distinct() {
        return this.wrap(ArrayListIterate.distinct(this.delegate));
    }

    public ArrayListAdapter<T> distinct(HashingStrategy<? super T> hashingStrategy) {
        return this.wrap(ArrayListIterate.distinct(this.delegate, hashingStrategy));
    }

    @Override
    public <V> ArrayListAdapter<T> distinctBy(Function<? super T, ? extends V> function) {
        return this.wrap(ArrayListIterate.distinctBy(this.delegate, function));
    }

    @Override
    public <S> MutableList<Pair<T, S>> zip(Iterable<S> that) {
        return ArrayListIterate.zip(this.delegate, that);
    }

    @Override
    public MutableList<Pair<T, Integer>> zipWithIndex() {
        return ArrayListIterate.zipWithIndex(this.delegate);
    }

    public MutableList<T> take(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be greater than zero, but was: " + count);
        }
        return ArrayListIterate.take(this.delegate, count, Lists.mutable.withInitialCapacity(Math.min(this.size(), count)));
    }

    public MutableList<T> takeWhile(Predicate<? super T> predicate) {
        return ArrayListIterate.takeWhile(this.delegate, predicate);
    }

    public MutableList<T> drop(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be greater than zero, but was: " + count);
        }
        return ArrayListIterate.drop(this.delegate, count, Lists.mutable.withInitialCapacity(this.size() - Math.min(this.size(), count)));
    }

    public MutableList<T> dropWhile(Predicate<? super T> predicate) {
        return ArrayListIterate.dropWhile(this.delegate, predicate);
    }

    public PartitionMutableList<T> partitionWhile(Predicate<? super T> predicate) {
        return ArrayListIterate.partitionWhile(this.delegate, predicate);
    }

    @Override
    public ReverseIterable<T> asReversed() {
        return ReverseIterable.adapt(this);
    }
}

