/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.block.function.primitive;

import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.tuple.Tuples;

public class IntCaseFunction<V>
implements IntToObjectFunction<V> {
    private static final long serialVersionUID = 1L;
    private final MutableList<Pair<IntPredicate, IntToObjectFunction<? extends V>>> predicateFunctions = Lists.mutable.empty();
    private IntToObjectFunction<? extends V> defaultFunction;

    public IntCaseFunction() {
    }

    public IntCaseFunction(IntToObjectFunction<? extends V> newDefaultFunction) {
        this.setDefault(newDefaultFunction);
    }

    public IntCaseFunction<V> addCase(IntPredicate predicate, IntToObjectFunction<? extends V> function) {
        this.predicateFunctions.add(Tuples.pair(predicate, function));
        return this;
    }

    public IntCaseFunction<V> setDefault(IntToObjectFunction<? extends V> function) {
        this.defaultFunction = function;
        return this;
    }

    public V valueOf(int argument) {
        int localSize = this.predicateFunctions.size();
        for (int i = 0; i < localSize; ++i) {
            Pair pair = (Pair)this.predicateFunctions.get(i);
            if (!((IntPredicate)pair.getOne()).accept(argument)) continue;
            return (V)((IntToObjectFunction)pair.getTwo()).valueOf(argument);
        }
        if (this.defaultFunction != null) {
            return (V)this.defaultFunction.valueOf(argument);
        }
        return null;
    }

    public String toString() {
        return "new IntCaseFunction(" + this.predicateFunctions + ')';
    }
}

