/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc;

import java.lang.annotation.Annotation;
import java.time.Duration;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.rpc.RpcTimeout;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TimeUtils;

public class RpcGatewayUtils {
    public static Duration extractRpcTimeout(Annotation[][] parameterAnnotations, Object[] args, Duration defaultTimeout) {
        if (args != null) {
            Preconditions.checkArgument((parameterAnnotations.length == args.length ? 1 : 0) != 0);
            for (int i = 0; i < parameterAnnotations.length; ++i) {
                if (!RpcGatewayUtils.isRpcTimeout(parameterAnnotations[i])) continue;
                if (args[i] instanceof Time) {
                    return TimeUtils.toDuration((Time)((Time)args[i]));
                }
                if (args[i] instanceof Duration) {
                    return (Duration)args[i];
                }
                throw new RuntimeException("The rpc timeout parameter must be of type " + Time.class.getName() + " or " + Duration.class.getName() + ". The type " + args[i].getClass().getName() + " is not supported.");
            }
        }
        return defaultTimeout;
    }

    private static boolean isRpcTimeout(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().equals(RpcTimeout.class)) continue;
            return true;
        }
        return false;
    }

    private RpcGatewayUtils() {
    }
}

