/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.fieldsplitter;

import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.fieldsplitter.FieldSplitterMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class FieldSplitterDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = FieldSplitterMeta.class;
    private CCombo wSplitField;
    private TextVar wDelimiter;
    private TextVar wEnclosure;
    private TextVar wEscapeString;
    private TableView wFields;
    private final FieldSplitterMeta input;
    private boolean gotPreviousFields = false;

    public FieldSplitterDialog(Shell parent, IVariables variables, FieldSplitterMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label wlSplitField = new Label((Composite)this.shell, 131072);
        wlSplitField.setText(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.SplitField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSplitField);
        FormData fdlSplitField = new FormData();
        fdlSplitField.left = new FormAttachment(0, 0);
        fdlSplitField.right = new FormAttachment(middle, -margin);
        fdlSplitField.top = new FormAttachment((Control)this.wTransformName, margin);
        wlSplitField.setLayoutData((Object)fdlSplitField);
        this.wSplitField = new CCombo((Composite)this.shell, 2056);
        this.wSplitField.setText("");
        PropsUi.setLook((Widget)this.wSplitField);
        FormData fdSplitField = new FormData();
        fdSplitField.left = new FormAttachment(middle, 0);
        fdSplitField.top = new FormAttachment((Control)this.wTransformName, margin);
        fdSplitField.right = new FormAttachment(100, 0);
        this.wSplitField.setLayoutData((Object)fdSplitField);
        this.wSplitField.addListener(15, e -> {
            Cursor busy = new Cursor((Device)this.shell.getDisplay(), 1);
            this.shell.setCursor(busy);
            this.getFields();
            this.shell.setCursor(null);
            busy.dispose();
        });
        Label wlDelimiter = new Label((Composite)this.shell, 131072);
        wlDelimiter.setText(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.Delimiter.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDelimiter);
        FormData fdlDelimiter = new FormData();
        fdlDelimiter.left = new FormAttachment(0, 0);
        fdlDelimiter.right = new FormAttachment(middle, -margin);
        fdlDelimiter.top = new FormAttachment((Control)this.wSplitField, margin);
        wlDelimiter.setLayoutData((Object)fdlDelimiter);
        this.wDelimiter = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.wDelimiter.setToolTipText(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.Delimiter.Tooltip", (String[])new String[0]));
        this.wDelimiter.setText("");
        PropsUi.setLook((Widget)this.wDelimiter);
        FormData fdDelimiter = new FormData();
        fdDelimiter.left = new FormAttachment(middle, 0);
        fdDelimiter.top = new FormAttachment((Control)this.wSplitField, margin);
        fdDelimiter.right = new FormAttachment(100, 0);
        this.wDelimiter.setLayoutData((Object)fdDelimiter);
        Label wlEnclosure = new Label((Composite)this.shell, 131072);
        wlEnclosure.setText(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.Enclosure.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlEnclosure);
        FormData fdlEnclosure = new FormData();
        fdlEnclosure.top = new FormAttachment((Control)this.wDelimiter, margin);
        fdlEnclosure.left = new FormAttachment(0, 0);
        fdlEnclosure.right = new FormAttachment(middle, -margin);
        wlEnclosure.setLayoutData((Object)fdlEnclosure);
        this.wEnclosure = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.wEnclosure.setToolTipText(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.Enclosure.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wEnclosure);
        FormData fdEnclosure = new FormData();
        fdEnclosure.top = new FormAttachment((Control)this.wDelimiter, margin);
        fdEnclosure.left = new FormAttachment(middle, 0);
        fdEnclosure.right = new FormAttachment(100, 0);
        this.wEnclosure.setLayoutData((Object)fdEnclosure);
        Label wlEscapeString = new Label((Composite)this.shell, 131072);
        wlEscapeString.setText(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.EscapeString.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlEscapeString);
        FormData fdlEscapeString = new FormData();
        fdlEscapeString.top = new FormAttachment((Control)this.wEnclosure, margin);
        fdlEscapeString.left = new FormAttachment(0, 0);
        fdlEscapeString.right = new FormAttachment(middle, -margin);
        wlEscapeString.setLayoutData((Object)fdlEscapeString);
        this.wEscapeString = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.wEscapeString.setToolTipText(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.EscapeString.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wEscapeString);
        FormData fdEscapeString = new FormData();
        fdEscapeString.top = new FormAttachment((Control)this.wEnclosure, margin);
        fdEscapeString.left = new FormAttachment(middle, 0);
        fdEscapeString.right = new FormAttachment(100, 0);
        this.wEscapeString.setLayoutData((Object)fdEscapeString);
        Label wlFields = new Label((Composite)this.shell, 131072);
        wlFields.setText(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.Fields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)this.wEscapeString, margin);
        wlFields.setLayoutData((Object)fdlFields);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        int fieldsRows = this.input.getFields().size();
        ColumnInfo[] fieldColumns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.ColumnInfo.NewField", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.ColumnInfo.ID", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.ColumnInfo.RemoveID", (String[])new String[0]), 2, new String[]{"Y", "N"}), new ColumnInfo(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.ColumnInfo.Type", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames()), new ColumnInfo(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.ColumnInfo.Length", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.ColumnInfo.Precision", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.ColumnInfo.Format", (String[])new String[0]), 5, 4), new ColumnInfo(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.ColumnInfo.Group", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.ColumnInfo.Decimal", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.ColumnInfo.Currency", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.ColumnInfo.Nullif", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.ColumnInfo.IfNull", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.ColumnInfo.TrimType", (String[])new String[0]), 2, ValueMetaString.trimTypeDesc, true)};
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, fieldColumns, fieldsRows, null, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel.addListener(13, e -> this.cancel());
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void getFields() {
        if (!this.gotPreviousFields) {
            try {
                String field = this.wSplitField.getText();
                IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
                if (r != null) {
                    this.wSplitField.setItems(r.getFieldNames());
                }
                if (field != null) {
                    this.wSplitField.setText(field);
                }
            }
            catch (HopException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"FieldSplitterDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FieldSplitterDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
            this.gotPreviousFields = true;
        }
    }

    public void getData() {
        this.wSplitField.setText(Const.NVL((String)this.input.getSplitField(), (String)""));
        this.wDelimiter.setText(Const.NVL((String)this.input.getDelimiter(), (String)""));
        this.wEnclosure.setText(Const.NVL((String)this.input.getEnclosure(), (String)""));
        this.wEscapeString.setText(Const.NVL((String)this.input.getEscapeString(), (String)""));
        for (int i = 0; i < this.input.getFields().size(); ++i) {
            FieldSplitterMeta.FSField field = this.input.getFields().get(i);
            TableItem ti = this.wFields.table.getItem(i);
            ti.setText(1, Const.NVL((String)field.getName(), (String)""));
            ti.setText(2, Const.NVL((String)field.getId(), (String)""));
            ti.setText(3, field.isIdRemoved() ? "Y" : "N");
            ti.setText(4, Const.NVL((String)field.getType(), (String)""));
            if (field.getLength() >= 0) {
                ti.setText(5, "" + field.getLength());
            }
            if (field.getPrecision() >= 0) {
                ti.setText(6, "" + field.getPrecision());
            }
            ti.setText(7, Const.NVL((String)field.getFormat(), (String)""));
            ti.setText(8, Const.NVL((String)field.getGroup(), (String)""));
            ti.setText(9, Const.NVL((String)field.getDecimal(), (String)""));
            ti.setText(10, Const.NVL((String)field.getCurrency(), (String)""));
            ti.setText(11, Const.NVL((String)field.getNullIf(), (String)""));
            ti.setText(12, Const.NVL((String)field.getIfNull(), (String)""));
            ti.setText(13, field.getTrimType() == null ? "" : field.getTrimType().getDescription());
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.input.setSplitField(this.wSplitField.getText());
        this.input.setDelimiter(this.wDelimiter.getText());
        this.input.setEnclosure(this.wEnclosure.getText());
        this.input.setEscapeString(this.wEscapeString.getText());
        this.input.getFields().clear();
        for (TableItem ti : this.wFields.getNonEmptyItems()) {
            FieldSplitterMeta.FSField field = new FieldSplitterMeta.FSField();
            field.setName(ti.getText(1));
            field.setId(ti.getText(2));
            field.setIdRemoved("Y".equalsIgnoreCase(ti.getText(3)));
            field.setType(ti.getText(4));
            field.setLength(Const.toInt((String)ti.getText(5), (int)-1));
            field.setPrecision(Const.toInt((String)ti.getText(6), (int)-1));
            field.setFormat(ti.getText(7));
            field.setGroup(ti.getText(8));
            field.setDecimal(ti.getText(9));
            field.setCurrency(ti.getText(10));
            field.setNullIf(ti.getText(11));
            field.setIfNull(ti.getText(12));
            field.setTrimType(IValueMeta.TrimType.lookupDescription((String)ti.getText(13)));
            this.input.getFields().add(field);
        }
        this.input.setChanged(true);
        this.dispose();
    }
}

