/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.opentelemetry;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientStreamTracer;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerStreamTracer;
import io.grpc.Status;
import io.grpc.opentelemetry.MetadataGetter;
import io.grpc.opentelemetry.MetadataSetter;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapSetter;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class OpenTelemetryTracingModule {
    private static final Logger logger;
    @VisibleForTesting
    static final String OTEL_TRACING_SCOPE_NAME = "grpc-java";
    @Nullable
    private static final AtomicIntegerFieldUpdater<CallAttemptsTracerFactory> callEndedUpdater;
    @Nullable
    private static final AtomicIntegerFieldUpdater<ServerTracer> streamClosedUpdater;
    private final Tracer otelTracer;
    private final ContextPropagators contextPropagators;
    private final MetadataGetter metadataGetter = MetadataGetter.getInstance();
    private final MetadataSetter metadataSetter = MetadataSetter.getInstance();
    private final TracingClientInterceptor clientInterceptor = new TracingClientInterceptor();
    private final ServerTracerFactory serverTracerFactory = new ServerTracerFactory();

    OpenTelemetryTracingModule(OpenTelemetry openTelemetry) {
        this.otelTracer = (Tracer)Preconditions.checkNotNull((Object)openTelemetry.getTracer(OTEL_TRACING_SCOPE_NAME), (Object)"otelTracer");
        this.contextPropagators = (ContextPropagators)Preconditions.checkNotNull((Object)openTelemetry.getPropagators(), (Object)"contextPropagators");
    }

    @VisibleForTesting
    CallAttemptsTracerFactory newClientCallTracer(Span clientSpan, MethodDescriptor<?, ?> method) {
        return new CallAttemptsTracerFactory(clientSpan, method);
    }

    ServerStreamTracer.Factory getServerTracerFactory() {
        return this.serverTracerFactory;
    }

    ClientInterceptor getClientInterceptor() {
        return this.clientInterceptor;
    }

    private void recordOutboundMessageSentEvent(Span span, int seqNo, long optionalWireSize, long optionalUncompressedSize) {
        AttributesBuilder attributesBuilder = io.opentelemetry.api.common.Attributes.builder();
        attributesBuilder.put("sequence-number", (long)seqNo);
        if (optionalUncompressedSize != -1L) {
            attributesBuilder.put("message-size", optionalUncompressedSize);
        }
        if (optionalWireSize != -1L && optionalWireSize != optionalUncompressedSize) {
            attributesBuilder.put("message-size-compressed", optionalWireSize);
        }
        span.addEvent("Outbound message sent", attributesBuilder.build());
    }

    private void recordInboundCompressedMessage(Span span, int seqNo, long optionalWireSize) {
        AttributesBuilder attributesBuilder = io.opentelemetry.api.common.Attributes.builder();
        attributesBuilder.put("sequence-number", (long)seqNo);
        attributesBuilder.put("message-size-compressed", optionalWireSize);
        span.addEvent("Inbound compressed message", attributesBuilder.build());
    }

    private void recordInboundMessageSize(Span span, int seqNo, long bytes) {
        AttributesBuilder attributesBuilder = io.opentelemetry.api.common.Attributes.builder();
        attributesBuilder.put("sequence-number", (long)seqNo);
        attributesBuilder.put("message-size", bytes);
        span.addEvent("Inbound message received", attributesBuilder.build());
    }

    private String generateErrorStatusDescription(Status status) {
        if (status.getDescription() != null) {
            return status.getCode() + ": " + status.getDescription();
        }
        return status.getCode().toString();
    }

    private void endSpanWithStatus(Span span, Status status) {
        if (status.isOk()) {
            span.setStatus(StatusCode.OK);
        } else {
            span.setStatus(StatusCode.ERROR, this.generateErrorStatusDescription(status));
        }
        span.end();
    }

    @VisibleForTesting
    static String generateTraceSpanName(boolean isServer, String fullMethodName) {
        String prefix = isServer ? "Recv" : "Sent";
        return prefix + "." + fullMethodName.replace('/', '.');
    }

    static {
        AtomicIntegerFieldUpdater<ServerTracer> tmpStreamClosedUpdater;
        AtomicIntegerFieldUpdater<CallAttemptsTracerFactory> tmpCallEndedUpdater;
        logger = Logger.getLogger(OpenTelemetryTracingModule.class.getName());
        try {
            tmpCallEndedUpdater = AtomicIntegerFieldUpdater.newUpdater(CallAttemptsTracerFactory.class, "callEnded");
            tmpStreamClosedUpdater = AtomicIntegerFieldUpdater.newUpdater(ServerTracer.class, "streamClosed");
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Creating atomic field updaters failed", t);
            tmpCallEndedUpdater = null;
            tmpStreamClosedUpdater = null;
        }
        callEndedUpdater = tmpCallEndedUpdater;
        streamClosedUpdater = tmpStreamClosedUpdater;
    }

    @VisibleForTesting
    final class TracingClientInterceptor
    implements ClientInterceptor {
        TracingClientInterceptor() {
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            Span clientSpan = OpenTelemetryTracingModule.this.otelTracer.spanBuilder(OpenTelemetryTracingModule.generateTraceSpanName(false, method.getFullMethodName())).startSpan();
            final CallAttemptsTracerFactory tracerFactory = OpenTelemetryTracingModule.this.newClientCallTracer(clientSpan, method);
            ClientCall call = next.newCall(method, callOptions.withStreamTracerFactory((ClientStreamTracer.Factory)tracerFactory));
            return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(call){

                public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                    this.delegate().start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                        public void onClose(Status status, Metadata trailers) {
                            tracerFactory.callEnded(status);
                            super.onClose(status, trailers);
                        }
                    }, headers);
                }
            };
        }
    }

    @VisibleForTesting
    final class ServerTracerFactory
    extends ServerStreamTracer.Factory {
        ServerTracerFactory() {
        }

        public ServerStreamTracer newServerStreamTracer(String fullMethodName, Metadata headers) {
            Context context = OpenTelemetryTracingModule.this.contextPropagators.getTextMapPropagator().extract(Context.current(), (Object)headers, (TextMapGetter)OpenTelemetryTracingModule.this.metadataGetter);
            Span remoteSpan = Span.fromContext((Context)context);
            if (remoteSpan == Span.getInvalid()) {
                remoteSpan = null;
            }
            return new ServerTracer(fullMethodName, remoteSpan);
        }
    }

    private final class ServerTracer
    extends ServerStreamTracer {
        private final Span span;
        volatile int streamClosed;
        private int seqNo;

        ServerTracer(@Nullable String fullMethodName, Span remoteSpan) {
            Preconditions.checkNotNull((Object)fullMethodName, (Object)"fullMethodName");
            this.span = OpenTelemetryTracingModule.this.otelTracer.spanBuilder(OpenTelemetryTracingModule.generateTraceSpanName(true, fullMethodName)).setParent(remoteSpan == null ? null : Context.current().with((ImplicitContextKeyed)remoteSpan)).startSpan();
        }

        public void streamClosed(Status status) {
            if (streamClosedUpdater != null) {
                if (streamClosedUpdater.getAndSet(this, 1) != 0) {
                    return;
                }
            } else {
                if (this.streamClosed != 0) {
                    return;
                }
                this.streamClosed = 1;
            }
            OpenTelemetryTracingModule.this.endSpanWithStatus(this.span, status);
        }

        public void outboundMessageSent(int seqNo, long optionalWireSize, long optionalUncompressedSize) {
            OpenTelemetryTracingModule.this.recordOutboundMessageSentEvent(this.span, seqNo, optionalWireSize, optionalUncompressedSize);
        }

        public void inboundMessageRead(int seqNo, long optionalWireSize, long optionalUncompressedSize) {
            if (optionalWireSize != optionalUncompressedSize) {
                OpenTelemetryTracingModule.this.recordInboundCompressedMessage(this.span, seqNo, optionalWireSize);
            }
        }

        public void inboundMessage(int seqNo) {
            this.seqNo = seqNo;
        }

        public void inboundUncompressedSize(long bytes) {
            OpenTelemetryTracingModule.this.recordInboundMessageSize(this.span, this.seqNo, bytes);
        }
    }

    private final class ClientTracer
    extends ClientStreamTracer {
        private final Span span;
        private final Span parentSpan;
        volatile int seqNo;
        boolean isPendingStream;

        ClientTracer(Span span, Span parentSpan) {
            this.span = (Span)Preconditions.checkNotNull((Object)span, (Object)"span");
            this.parentSpan = (Span)Preconditions.checkNotNull((Object)parentSpan, (Object)"parent span");
        }

        public void streamCreated(Attributes transportAtts, Metadata headers) {
            OpenTelemetryTracingModule.this.contextPropagators.getTextMapPropagator().inject(Context.current().with((ImplicitContextKeyed)this.span), (Object)headers, (TextMapSetter)OpenTelemetryTracingModule.this.metadataSetter);
            if (this.isPendingStream) {
                this.span.addEvent("Delayed LB pick complete");
            }
        }

        public void createPendingStream() {
            this.isPendingStream = true;
        }

        public void outboundMessageSent(int seqNo, long optionalWireSize, long optionalUncompressedSize) {
            OpenTelemetryTracingModule.this.recordOutboundMessageSentEvent(this.span, seqNo, optionalWireSize, optionalUncompressedSize);
        }

        public void inboundMessageRead(int seqNo, long optionalWireSize, long optionalUncompressedSize) {
            if (optionalWireSize != optionalUncompressedSize) {
                OpenTelemetryTracingModule.this.recordInboundCompressedMessage(this.span, seqNo, optionalWireSize);
            }
        }

        public void inboundMessage(int seqNo) {
            this.seqNo = seqNo;
        }

        public void inboundUncompressedSize(long bytes) {
            OpenTelemetryTracingModule.this.recordInboundMessageSize(this.parentSpan, this.seqNo, bytes);
        }

        public void streamClosed(Status status) {
            OpenTelemetryTracingModule.this.endSpanWithStatus(this.span, status);
        }
    }

    @VisibleForTesting
    final class CallAttemptsTracerFactory
    extends ClientStreamTracer.Factory {
        volatile int callEnded;
        private final Span clientSpan;
        private final String fullMethodName;

        CallAttemptsTracerFactory(Span clientSpan, MethodDescriptor<?, ?> method) {
            Preconditions.checkNotNull(method, (Object)"method");
            this.fullMethodName = (String)Preconditions.checkNotNull((Object)method.getFullMethodName(), (Object)"fullMethodName");
            this.clientSpan = (Span)Preconditions.checkNotNull((Object)clientSpan, (Object)"clientSpan");
        }

        public ClientStreamTracer newClientStreamTracer(ClientStreamTracer.StreamInfo info, Metadata headers) {
            Span attemptSpan = OpenTelemetryTracingModule.this.otelTracer.spanBuilder("Attempt." + this.fullMethodName.replace('/', '.')).setParent(Context.current().with((ImplicitContextKeyed)this.clientSpan)).startSpan();
            attemptSpan.setAttribute("previous-rpc-attempts", (long)info.getPreviousAttempts());
            attemptSpan.setAttribute("transparent-retry", info.isTransparentRetry());
            if (info.getCallOptions().getOption(ClientStreamTracer.NAME_RESOLUTION_DELAYED) != null) {
                this.clientSpan.addEvent("Delayed name resolution complete");
            }
            return new ClientTracer(attemptSpan, this.clientSpan);
        }

        void callEnded(Status status) {
            if (callEndedUpdater != null) {
                if (callEndedUpdater.getAndSet(this, 1) != 0) {
                    return;
                }
            } else {
                if (this.callEnded != 0) {
                    return;
                }
                this.callEnded = 1;
            }
            OpenTelemetryTracingModule.this.endSpanWithStatus(this.clientSpan, status);
        }
    }
}

