/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.internal.avro.implementation.schema;

import com.azure.storage.internal.avro.implementation.AvroParserState;
import com.azure.storage.internal.avro.implementation.schema.AvroType;
import com.azure.storage.internal.avro.implementation.schema.complex.AvroArraySchema;
import com.azure.storage.internal.avro.implementation.schema.complex.AvroEnumSchema;
import com.azure.storage.internal.avro.implementation.schema.complex.AvroFixedSchema;
import com.azure.storage.internal.avro.implementation.schema.complex.AvroMapSchema;
import com.azure.storage.internal.avro.implementation.schema.complex.AvroRecordSchema;
import com.azure.storage.internal.avro.implementation.schema.complex.AvroUnionSchema;
import com.azure.storage.internal.avro.implementation.schema.primitive.AvroBooleanSchema;
import com.azure.storage.internal.avro.implementation.schema.primitive.AvroBytesSchema;
import com.azure.storage.internal.avro.implementation.schema.primitive.AvroDoubleSchema;
import com.azure.storage.internal.avro.implementation.schema.primitive.AvroFloatSchema;
import com.azure.storage.internal.avro.implementation.schema.primitive.AvroIntegerSchema;
import com.azure.storage.internal.avro.implementation.schema.primitive.AvroLongSchema;
import com.azure.storage.internal.avro.implementation.schema.primitive.AvroNullSchema;
import com.azure.storage.internal.avro.implementation.schema.primitive.AvroStringSchema;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public abstract class AvroSchema {
    protected final AvroParserState state;
    private final Consumer<Object> onResult;
    protected boolean done = false;
    protected Object result;

    public AvroSchema(AvroParserState state, Consumer<Object> onResult) {
        this.state = state;
        this.onResult = onResult;
    }

    public abstract void pushToStack();

    public boolean isDone() {
        return this.done;
    }

    public void publishResult() {
        this.onResult.accept(this.result);
    }

    public static AvroSchema getSchema(AvroType type, AvroParserState state, Consumer<Object> onResult) {
        switch (type.getType()) {
            case "null": {
                return new AvroNullSchema(state, onResult);
            }
            case "boolean": {
                return new AvroBooleanSchema(state, onResult);
            }
            case "int": {
                return new AvroIntegerSchema(state, onResult);
            }
            case "long": {
                return new AvroLongSchema(state, onResult);
            }
            case "float": {
                return new AvroFloatSchema(state, onResult);
            }
            case "double": {
                return new AvroDoubleSchema(state, onResult);
            }
            case "bytes": {
                return new AvroBytesSchema(state, onResult);
            }
            case "string": {
                return new AvroStringSchema(state, onResult);
            }
            case "record": {
                AvroSchema.checkType("type", type, AvroType.AvroRecordType.class);
                AvroType.AvroRecordType recordType = (AvroType.AvroRecordType)type;
                return new AvroRecordSchema(recordType.getName(), recordType.getFields(), state, onResult);
            }
            case "enum": {
                AvroSchema.checkType("type", type, AvroType.AvroEnumType.class);
                AvroType.AvroEnumType enumType = (AvroType.AvroEnumType)type;
                return new AvroEnumSchema(enumType.getSymbols(), state, onResult);
            }
            case "array": {
                AvroSchema.checkType("type", type, AvroType.AvroArrayType.class);
                AvroType.AvroArrayType arrayType = (AvroType.AvroArrayType)type;
                return new AvroArraySchema(arrayType.getItemType(), state, onResult);
            }
            case "map": {
                AvroSchema.checkType("type", type, AvroType.AvroMapType.class);
                AvroType.AvroMapType mapType = (AvroType.AvroMapType)type;
                return new AvroMapSchema(mapType.getValueType(), state, onResult);
            }
            case "union": {
                AvroSchema.checkType("type", type, AvroType.AvroUnionType.class);
                AvroType.AvroUnionType unionType = (AvroType.AvroUnionType)type;
                return new AvroUnionSchema(unionType.getTypes(), state, onResult);
            }
            case "fixed": {
                AvroSchema.checkType("type", type, AvroType.AvroFixedType.class);
                AvroType.AvroFixedType fixedType = (AvroType.AvroFixedType)type;
                return new AvroFixedSchema(fixedType.getSize(), state, onResult);
            }
        }
        throw new RuntimeException("Unsupported type " + type.getType());
    }

    public static void checkType(String name, Object obj, Class<?> expectedType) {
        if (!expectedType.isAssignableFrom(obj.getClass())) {
            throw new IllegalStateException(String.format("Expected '%s' to be of type %s", name, expectedType.getSimpleName()));
        }
    }

    public static byte[] getBytes(List<?> bytes) {
        long longTotalBytes = bytes.stream().mapToLong(buffer -> {
            AvroSchema.checkType("buffer", buffer, ByteBuffer.class);
            return ((ByteBuffer)buffer).remaining();
        }).sum();
        if (longTotalBytes > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Bytes can not fit into a single array.");
        }
        int totalBytes = Math.toIntExact(longTotalBytes);
        byte[] ret = new byte[totalBytes];
        AtomicInteger offset = new AtomicInteger();
        bytes.forEach(buffer -> {
            AvroSchema.checkType("buffer", buffer, ByteBuffer.class);
            ByteBuffer b = (ByteBuffer)buffer;
            int length = b.remaining();
            b.get(ret, offset.get(), length);
            offset.addAndGet(length);
        });
        return ret;
    }
}

