/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.spi;

import java.io.Serializable;
import java.security.AccessController;
import org.drools.core.WorkingMemory;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.CompiledInvoker;
import org.drools.core.spi.Invoker;
import org.drools.core.spi.Tuple;
import org.kie.internal.security.KiePolicyHelper;

public interface PredicateExpression
extends Invoker {
    public Object createContext();

    public boolean evaluate(InternalFactHandle var1, Tuple var2, Declaration[] var3, Declaration[] var4, WorkingMemory var5, Object var6) throws Exception;

    public static boolean isCompiledInvoker(PredicateExpression expression) {
        return expression instanceof CompiledInvoker || expression instanceof SafePredicateExpression && ((SafePredicateExpression)expression).wrapsCompiledInvoker();
    }

    public static class SafePredicateExpression
    implements PredicateExpression,
    Serializable {
        private static final long serialVersionUID = -4570820770000524010L;
        private PredicateExpression delegate;

        public SafePredicateExpression(PredicateExpression delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object createContext() {
            return AccessController.doPrivileged(() -> this.delegate.createContext(), KiePolicyHelper.getAccessContext());
        }

        @Override
        public boolean evaluate(InternalFactHandle handle, Tuple tuple, Declaration[] previousDeclarations, Declaration[] localDeclarations, WorkingMemory workingMemory, Object context) throws Exception {
            return AccessController.doPrivileged(() -> this.delegate.evaluate(handle, tuple, previousDeclarations, localDeclarations, workingMemory, context), KiePolicyHelper.getAccessContext());
        }

        public boolean wrapsCompiledInvoker() {
            return this.delegate instanceof CompiledInvoker;
        }
    }
}

