/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.extractors;

import java.lang.reflect.Method;
import org.drools.core.base.BaseClassFieldReader;
import org.drools.core.base.ValueType;
import org.drools.core.common.InternalWorkingMemory;

public abstract class BaseFloatClassFieldReader
extends BaseClassFieldReader {
    private static final long serialVersionUID = 510L;

    protected BaseFloatClassFieldReader(int index, Class fieldType, ValueType valueType) {
        super(index, fieldType, valueType);
    }

    public BaseFloatClassFieldReader() {
    }

    @Override
    public Object getValue(InternalWorkingMemory workingMemory, Object object) {
        return Float.valueOf(this.getFloatValue(workingMemory, object));
    }

    @Override
    public boolean getBooleanValue(InternalWorkingMemory workingMemory, Object object) {
        throw new RuntimeException("Conversion to boolean not supported from float");
    }

    @Override
    public byte getByteValue(InternalWorkingMemory workingMemory, Object object) {
        return (byte)this.getFloatValue(workingMemory, object);
    }

    @Override
    public char getCharValue(InternalWorkingMemory workingMemory, Object object) {
        throw new RuntimeException("Conversion to char not supported from float");
    }

    @Override
    public double getDoubleValue(InternalWorkingMemory workingMemory, Object object) {
        return this.getFloatValue(workingMemory, object);
    }

    @Override
    public abstract float getFloatValue(InternalWorkingMemory var1, Object var2);

    @Override
    public int getIntValue(InternalWorkingMemory workingMemory, Object object) {
        return (int)this.getFloatValue(workingMemory, object);
    }

    @Override
    public long getLongValue(InternalWorkingMemory workingMemory, Object object) {
        return (long)this.getFloatValue(workingMemory, object);
    }

    @Override
    public short getShortValue(InternalWorkingMemory workingMemory, Object object) {
        return (short)this.getFloatValue(workingMemory, object);
    }

    @Override
    public boolean isNullValue(InternalWorkingMemory workingMemory, Object object) {
        return false;
    }

    @Override
    public Method getNativeReadMethod() {
        try {
            return this.getClass().getDeclaredMethod("getFloatValue", InternalWorkingMemory.class, Object.class);
        }
        catch (Exception e) {
            throw new RuntimeException("This is a bug. Please report to development team: " + e.getMessage(), e);
        }
    }

    @Override
    public int getHashCode(InternalWorkingMemory workingMemory, Object object) {
        return Float.floatToIntBits(this.getFloatValue(workingMemory, object));
    }
}

