/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.accumulators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.drools.core.base.accumulators.AbstractAccumulateFunction;

public class BigDecimalAverageAccumulateFunction
extends AbstractAccumulateFunction<AverageData> {
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
    }

    public AverageData createContext() {
        return new AverageData();
    }

    public void init(AverageData data) {
        data.count = 0;
        data.total = BigDecimal.ZERO;
    }

    public void accumulate(AverageData data, Object value) {
        if (value != null) {
            ++data.count;
            data.total = data.total.add((BigDecimal)value);
        }
    }

    public void reverse(AverageData data, Object value) {
        if (value != null) {
            --data.count;
            data.total = data.total.subtract((BigDecimal)value);
        }
    }

    public Object getResult(AverageData data) {
        return data.count == 0 ? BigDecimal.ZERO : data.total.divide(BigDecimal.valueOf(data.count), RoundingMode.HALF_EVEN);
    }

    public boolean supportsReverse() {
        return true;
    }

    public Class<?> getResultType() {
        return BigDecimal.class;
    }

    public static class AverageData
    implements Externalizable {
        public int count = 0;
        public BigDecimal total = BigDecimal.ZERO;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.count = in.readInt();
            this.total = (BigDecimal)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.count);
            out.writeObject(this.total);
        }
    }
}

