/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc.internal;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.proto.SecurityProtos;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.thirdparty.protobuf.ByteString;
import org.apache.hadoop.thirdparty.protobuf.ServiceException;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class ShadedProtobufHelper {
    private static final ConcurrentHashMap<Object, ByteString> FIXED_BYTESTRING_CACHE = new ConcurrentHashMap();

    private ShadedProtobufHelper() {
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static IOException getRemoteException(ServiceException se) {
        Throwable e = se.getCause();
        if (e == null) {
            return new IOException(se);
        }
        return e instanceof IOException ? (IOException)e : new IOException(se);
    }

    public static ByteString getFixedByteString(Text key) {
        ByteString value = FIXED_BYTESTRING_CACHE.get(key);
        if (value == null) {
            value = ByteString.copyFromUtf8((String)key.toString());
            FIXED_BYTESTRING_CACHE.put(new Text(key.copyBytes()), value);
        }
        return value;
    }

    public static ByteString getFixedByteString(String key) {
        ByteString value = FIXED_BYTESTRING_CACHE.get(key);
        if (value == null) {
            value = ByteString.copyFromUtf8((String)key);
            FIXED_BYTESTRING_CACHE.put(key, value);
        }
        return value;
    }

    public static ByteString getByteString(byte[] bytes) {
        return bytes.length == 0 ? ByteString.EMPTY : ByteString.copyFrom((byte[])bytes);
    }

    public static Token<? extends TokenIdentifier> tokenFromProto(SecurityProtos.TokenProto tokenProto) {
        Token token = new Token(tokenProto.getIdentifier().toByteArray(), tokenProto.getPassword().toByteArray(), new Text(tokenProto.getKind()), new Text(tokenProto.getService()));
        return token;
    }

    public static SecurityProtos.TokenProto protoFromToken(Token<?> tok) {
        SecurityProtos.TokenProto.Builder builder = SecurityProtos.TokenProto.newBuilder().setIdentifier(ShadedProtobufHelper.getByteString(tok.getIdentifier())).setPassword(ShadedProtobufHelper.getByteString(tok.getPassword())).setKindBytes(ShadedProtobufHelper.getFixedByteString(tok.getKind())).setServiceBytes(ShadedProtobufHelper.getFixedByteString(tok.getService()));
        return builder.build();
    }

    public static <T> T ipc(IpcCall<T> call) throws IOException {
        try {
            return call.call();
        }
        catch (ServiceException e) {
            throw ShadedProtobufHelper.getRemoteException(e);
        }
    }

    @FunctionalInterface
    public static interface IpcCall<T> {
        public T call() throws ServiceException;
    }
}

