/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode.rawcoder;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.io.erasurecode.ECChunk;
import org.apache.hadoop.io.erasurecode.rawcoder.CoderUtil;
import org.apache.hadoop.io.erasurecode.rawcoder.InvalidDecodingException;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureDecoder;

@InterfaceAudience.Private
public class DecodingValidator {
    private final RawErasureDecoder decoder;
    private ByteBuffer buffer;
    private int[] newValidIndexes;
    private int newErasedIndex;

    public DecodingValidator(RawErasureDecoder decoder) {
        this.decoder = decoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(ByteBuffer[] inputs, int[] erasedIndexes, ByteBuffer[] outputs) throws IOException {
        DecodingValidator.markBuffers(outputs);
        try {
            ByteBuffer validInput = CoderUtil.findFirstValidInput(inputs);
            boolean isDirect = validInput.isDirect();
            int capacity = validInput.capacity();
            int remaining = validInput.remaining();
            if (this.buffer == null || this.buffer.isDirect() != isDirect || this.buffer.capacity() < remaining) {
                this.buffer = this.allocateBuffer(isDirect, capacity);
            }
            this.buffer.clear().limit(remaining);
            ByteBuffer[] newInputs = new ByteBuffer[inputs.length];
            int count = 0;
            for (int i = 0; i < erasedIndexes.length; ++i) {
                newInputs[erasedIndexes[i]] = outputs[i];
                ++count;
            }
            this.newErasedIndex = -1;
            boolean selected = false;
            int numValidIndexes = CoderUtil.getValidIndexes(inputs).length;
            for (int i = 0; i < newInputs.length && count != numValidIndexes; ++i) {
                if (!selected && inputs[i] != null) {
                    this.newErasedIndex = i;
                    newInputs[i] = null;
                    selected = true;
                    continue;
                }
                if (newInputs[i] != null) continue;
                newInputs[i] = inputs[i];
                if (inputs[i] == null) continue;
                ++count;
            }
            this.newValidIndexes = CoderUtil.getValidIndexes(newInputs);
            this.decoder.decode(newInputs, new int[]{this.newErasedIndex}, new ByteBuffer[]{this.buffer});
            if (!this.buffer.equals(inputs[this.newErasedIndex])) {
                throw new InvalidDecodingException("Failed to validate decoding");
            }
        }
        finally {
            DecodingValidator.toLimits(inputs);
            DecodingValidator.resetBuffers(outputs);
        }
    }

    public void validate(ECChunk[] inputs, int[] erasedIndexes, ECChunk[] outputs) throws IOException {
        ByteBuffer[] newInputs = CoderUtil.toBuffers(inputs);
        ByteBuffer[] newOutputs = CoderUtil.toBuffers(outputs);
        this.validate(newInputs, erasedIndexes, newOutputs);
    }

    private ByteBuffer allocateBuffer(boolean direct, int capacity) {
        this.buffer = direct ? ByteBuffer.allocateDirect(capacity) : ByteBuffer.allocate(capacity);
        return this.buffer;
    }

    private static void markBuffers(ByteBuffer[] buffers) {
        for (ByteBuffer buffer : buffers) {
            if (buffer == null) continue;
            buffer.mark();
        }
    }

    private static void resetBuffers(ByteBuffer[] buffers) {
        for (ByteBuffer buffer : buffers) {
            if (buffer == null) continue;
            buffer.reset();
        }
    }

    private static void toLimits(ByteBuffer[] buffers) {
        for (ByteBuffer buffer : buffers) {
            if (buffer == null) continue;
            buffer.position(buffer.limit());
        }
    }

    @VisibleForTesting
    protected int[] getNewValidIndexes() {
        return this.newValidIndexes;
    }

    @VisibleForTesting
    protected int getNewErasedIndex() {
        return this.newErasedIndex;
    }
}

