/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsendnsca.encryption;

import com.googlecode.jsendnsca.encryption.Encryptor;
import com.googlecode.jsendnsca.encryption.TripleDESEncryptor;
import com.googlecode.jsendnsca.encryption.XorEncryptor;
import org.apache.commons.lang.StringUtils;

public enum Encryption {
    NONE,
    TRIPLE_DES(new TripleDESEncryptor()),
    XOR(new XorEncryptor());

    private final Encryptor encryptor;

    public Encryptor getEncryptor() {
        return this.encryptor;
    }

    public static String supportedList() {
        return StringUtils.join((Object[])Encryption.values(), (char)',');
    }

    private Encryption() {
        this.encryptor = this.none();
    }

    private Encryption(Encryptor encryptor) {
        this.encryptor = encryptor;
    }

    private Encryptor none() {
        return new Encryptor(){

            @Override
            public void encrypt(byte[] passiveCheckBytes, byte[] initVector, String password) {
            }
        };
    }
}

