/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.testing;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.testing.PipelineUnitTestFieldMapping;

public class PipelineUnitTestSetLocation {
    @HopMetadataProperty(key="transform_name")
    protected String transformName;
    @HopMetadataProperty(key="data_set_name")
    protected String dataSetName;
    @HopMetadataProperty(key="field_mappings")
    protected List<PipelineUnitTestFieldMapping> fieldMappings = new ArrayList<PipelineUnitTestFieldMapping>();
    @HopMetadataProperty(key="field_order")
    protected List<String> fieldOrder = new ArrayList<String>();

    public PipelineUnitTestSetLocation() {
    }

    public PipelineUnitTestSetLocation(String transformName, String dataSetName, List<PipelineUnitTestFieldMapping> fieldMappings, List<String> fieldOrder) {
        this();
        this.transformName = transformName;
        this.dataSetName = dataSetName;
        this.fieldMappings = fieldMappings;
        this.fieldOrder = fieldOrder;
    }

    public String findTransformField(String dataSetField) {
        for (PipelineUnitTestFieldMapping fieldMapping : this.fieldMappings) {
            if (!fieldMapping.getDataSetFieldName().equalsIgnoreCase(dataSetField)) continue;
            return fieldMapping.getTransformFieldName();
        }
        return null;
    }

    public String getTransformName() {
        return this.transformName;
    }

    public void setTransformName(String transformName) {
        this.transformName = transformName;
    }

    public String getDataSetName() {
        return this.dataSetName;
    }

    public void setDataSetName(String dataSetName) {
        this.dataSetName = dataSetName;
    }

    public List<PipelineUnitTestFieldMapping> getFieldMappings() {
        return this.fieldMappings;
    }

    public void setFieldMappings(List<PipelineUnitTestFieldMapping> fieldMappings) {
        this.fieldMappings = fieldMappings;
    }

    public List<String> getFieldOrder() {
        return this.fieldOrder;
    }

    public void setFieldOrder(List<String> fieldOrder) {
        this.fieldOrder = fieldOrder;
    }
}

