/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.gunit;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.antlr.gunit.AbstractTest;
import org.antlr.gunit.GrammarInfo;
import org.antlr.gunit.gUnitTestInput;
import org.antlr.gunit.gUnitTestSuite;
import org.antlr.stringtemplate.CommonGroupLoader;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

public class JUnitCodeGen {
    public GrammarInfo grammarInfo;
    public Map<String, String> ruleWithReturn;
    private final String testsuiteDir;
    private String outputDirectoryPath = ".";
    private static final Handler console = new ConsoleHandler();
    private static final Logger logger = Logger.getLogger(JUnitCodeGen.class.getName());

    public JUnitCodeGen(GrammarInfo grammarInfo, String testsuiteDir) throws ClassNotFoundException {
        this(grammarInfo, JUnitCodeGen.determineClassLoader(), testsuiteDir);
    }

    private static ClassLoader determineClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = JUnitCodeGen.class.getClassLoader();
        }
        return classLoader;
    }

    public JUnitCodeGen(GrammarInfo grammarInfo, ClassLoader classLoader, String testsuiteDir) throws ClassNotFoundException {
        Method[] methods;
        this.grammarInfo = grammarInfo;
        this.testsuiteDir = testsuiteDir;
        this.ruleWithReturn = new HashMap<String, String>();
        Class<?> parserClass = this.locateParserClass(grammarInfo, classLoader);
        for (Method method : methods = parserClass.getDeclaredMethods()) {
            if (method.getReturnType().getName().equals("void")) continue;
            this.ruleWithReturn.put(method.getName(), method.getReturnType().getName().replace('$', '.'));
        }
    }

    private Class<?> locateParserClass(GrammarInfo grammarInfo, ClassLoader classLoader) throws ClassNotFoundException {
        String parserClassName = grammarInfo.getGrammarName() + "Parser";
        if (grammarInfo.getGrammarPackage() != null) {
            parserClassName = grammarInfo.getGrammarPackage() + "." + parserClassName;
        }
        return classLoader.loadClass(parserClassName);
    }

    public String getOutputDirectoryPath() {
        return this.outputDirectoryPath;
    }

    public void setOutputDirectoryPath(String outputDirectoryPath) {
        this.outputDirectoryPath = outputDirectoryPath;
    }

    public void compile() throws IOException {
        String junitFileName = this.grammarInfo.getTreeGrammarName() != null ? "Test" + this.grammarInfo.getTreeGrammarName() : "Test" + this.grammarInfo.getGrammarName();
        String lexerName = this.grammarInfo.getGrammarName() + "Lexer";
        String parserName = this.grammarInfo.getGrammarName() + "Parser";
        CommonGroupLoader loader = new CommonGroupLoader("org/antlr/gunit", null);
        StringTemplateGroup.registerGroupLoader(loader);
        StringTemplateGroup.registerDefaultLexer(AngleBracketTemplateLexer.class);
        StringBuffer buf = this.compileToBuffer(junitFileName, lexerName, parserName);
        this.writeTestFile(".", junitFileName + ".java", buf.toString());
    }

    public StringBuffer compileToBuffer(String className, String lexerName, String parserName) {
        StringTemplateGroup group = StringTemplateGroup.loadGroup("junit");
        StringBuffer buf = new StringBuffer();
        buf.append(this.genClassHeader(group, className, lexerName, parserName));
        buf.append(this.genTestRuleMethods(group));
        buf.append("\n\n}");
        return buf;
    }

    protected String genClassHeader(StringTemplateGroup group, String junitFileName, String lexerName, String parserName) {
        StringTemplate classHeaderST = group.getInstanceOf("classHeader");
        if (this.grammarInfo.getTestPackage() != null) {
            classHeaderST.setAttribute("header", "package " + this.grammarInfo.getTestPackage() + ";");
        }
        classHeaderST.setAttribute("junitFileName", junitFileName);
        String lexerPath = null;
        String parserPath = null;
        String treeParserPath = null;
        String packagePath = null;
        boolean isTreeGrammar = false;
        boolean hasPackage = false;
        if (this.grammarInfo.getGrammarPackage() != null) {
            hasPackage = true;
            packagePath = "./" + this.grammarInfo.getGrammarPackage().replace('.', '/');
            lexerPath = this.grammarInfo.getGrammarPackage() + "." + lexerName;
            parserPath = this.grammarInfo.getGrammarPackage() + "." + parserName;
            if (this.grammarInfo.getTreeGrammarName() != null) {
                treeParserPath = this.grammarInfo.getGrammarPackage() + "." + this.grammarInfo.getTreeGrammarName();
                isTreeGrammar = true;
            }
        } else {
            lexerPath = lexerName;
            parserPath = parserName;
            if (this.grammarInfo.getTreeGrammarName() != null) {
                treeParserPath = this.grammarInfo.getTreeGrammarName();
                isTreeGrammar = true;
            }
        }
        String treeAdaptorPath = null;
        boolean hasTreeAdaptor = false;
        if (this.grammarInfo.getAdaptor() != null) {
            hasTreeAdaptor = true;
            treeAdaptorPath = this.grammarInfo.getAdaptor();
        }
        classHeaderST.setAttribute("hasTreeAdaptor", hasTreeAdaptor);
        classHeaderST.setAttribute("treeAdaptorPath", treeAdaptorPath);
        classHeaderST.setAttribute("hasPackage", hasPackage);
        classHeaderST.setAttribute("packagePath", packagePath);
        classHeaderST.setAttribute("lexerPath", lexerPath);
        classHeaderST.setAttribute("parserPath", parserPath);
        classHeaderST.setAttribute("treeParserPath", treeParserPath);
        classHeaderST.setAttribute("isTreeGrammar", isTreeGrammar);
        return classHeaderST.toString();
    }

    protected String genTestRuleMethods(StringTemplateGroup group) {
        StringBuffer buf = new StringBuffer();
        if (this.grammarInfo.getTreeGrammarName() != null) {
            this.genTreeMethods(group, buf);
        } else {
            this.genParserMethods(group, buf);
        }
        return buf.toString();
    }

    private void genParserMethods(StringTemplateGroup group, StringBuffer buf) {
        for (gUnitTestSuite ts : this.grammarInfo.getRuleTestSuites()) {
            int i = 0;
            for (Map.Entry<gUnitTestInput, AbstractTest> entry : ts.testSuites.entrySet()) {
                StringTemplate testRuleMethodST;
                gUnitTestInput input = entry.getKey();
                ++i;
                if (entry.getValue().getType() == 4 && this.ruleWithReturn.containsKey(ts.getRuleName())) {
                    testRuleMethodST = group.getInstanceOf("testRuleMethod2");
                    String outputString = entry.getValue().getText();
                    testRuleMethodST.setAttribute("methodName", "test" + this.changeFirstCapital(ts.getRuleName()) + i);
                    testRuleMethodST.setAttribute("testRuleName", '\"' + ts.getRuleName() + '\"');
                    testRuleMethodST.setAttribute("test", input);
                    testRuleMethodST.setAttribute("returnType", this.ruleWithReturn.get(ts.getRuleName()));
                    testRuleMethodST.setAttribute("expecting", outputString);
                } else {
                    String testRuleName = ts.isLexicalRule() ? ts.getLexicalRuleName() : ts.getRuleName();
                    testRuleMethodST = group.getInstanceOf("testRuleMethod");
                    String outputString = entry.getValue().getText();
                    testRuleMethodST.setAttribute("isLexicalRule", ts.isLexicalRule());
                    testRuleMethodST.setAttribute("methodName", "test" + this.changeFirstCapital(testRuleName) + i);
                    testRuleMethodST.setAttribute("testRuleName", '\"' + testRuleName + '\"');
                    testRuleMethodST.setAttribute("test", input);
                    testRuleMethodST.setAttribute("tokenType", this.getTypeString(entry.getValue().getType()));
                    outputString = JUnitCodeGen.normalizeTreeSpec(outputString);
                    if (entry.getValue().getType() == 4) {
                        testRuleMethodST.setAttribute("expecting", outputString);
                    } else if (entry.getValue().getType() == 18) {
                        testRuleMethodST.setAttribute("expecting", outputString);
                    } else {
                        outputString = outputString.replaceAll("\n", "");
                        testRuleMethodST.setAttribute("expecting", '\"' + JUnitCodeGen.escapeForJava(outputString) + '\"');
                    }
                }
                buf.append(testRuleMethodST.toString());
            }
        }
    }

    private void genTreeMethods(StringTemplateGroup group, StringBuffer buf) {
        for (gUnitTestSuite ts : this.grammarInfo.getRuleTestSuites()) {
            int i = 0;
            for (Map.Entry<gUnitTestInput, AbstractTest> entry : ts.testSuites.entrySet()) {
                String outputString;
                StringTemplate testRuleMethodST;
                gUnitTestInput input = entry.getKey();
                ++i;
                if (entry.getValue().getType() == 4 && this.ruleWithReturn.containsKey(ts.getTreeRuleName())) {
                    testRuleMethodST = group.getInstanceOf("testTreeRuleMethod2");
                    outputString = entry.getValue().getText();
                    testRuleMethodST.setAttribute("methodName", "test" + this.changeFirstCapital(ts.getTreeRuleName()) + "_walks_" + this.changeFirstCapital(ts.getRuleName()) + i);
                    testRuleMethodST.setAttribute("testTreeRuleName", '\"' + ts.getTreeRuleName() + '\"');
                    testRuleMethodST.setAttribute("testRuleName", '\"' + ts.getRuleName() + '\"');
                    testRuleMethodST.setAttribute("test", input);
                    testRuleMethodST.setAttribute("returnType", this.ruleWithReturn.get(ts.getTreeRuleName()));
                    testRuleMethodST.setAttribute("expecting", outputString);
                } else {
                    testRuleMethodST = group.getInstanceOf("testTreeRuleMethod");
                    outputString = entry.getValue().getText();
                    testRuleMethodST.setAttribute("methodName", "test" + this.changeFirstCapital(ts.getTreeRuleName()) + "_walks_" + this.changeFirstCapital(ts.getRuleName()) + i);
                    testRuleMethodST.setAttribute("testTreeRuleName", '\"' + ts.getTreeRuleName() + '\"');
                    testRuleMethodST.setAttribute("testRuleName", '\"' + ts.getRuleName() + '\"');
                    testRuleMethodST.setAttribute("test", input);
                    testRuleMethodST.setAttribute("tokenType", this.getTypeString(entry.getValue().getType()));
                    if (entry.getValue().getType() == 4) {
                        testRuleMethodST.setAttribute("expecting", outputString);
                    } else if (entry.getValue().getType() == 18) {
                        testRuleMethodST.setAttribute("expecting", outputString);
                    } else {
                        testRuleMethodST.setAttribute("expecting", '\"' + JUnitCodeGen.escapeForJava(outputString) + '\"');
                    }
                }
                buf.append(testRuleMethodST.toString());
            }
        }
    }

    public String getTypeString(int type) {
        String typeText;
        switch (type) {
            case 16: {
                typeText = "org.antlr.gunit.gUnitParser.OK";
                break;
            }
            case 10: {
                typeText = "org.antlr.gunit.gUnitParser.FAIL";
                break;
            }
            case 21: {
                typeText = "org.antlr.gunit.gUnitParser.STRING";
                break;
            }
            case 12: {
                typeText = "org.antlr.gunit.gUnitParser.ML_STRING";
                break;
            }
            case 18: {
                typeText = "org.antlr.gunit.gUnitParser.RETVAL";
                break;
            }
            case 5: {
                typeText = "org.antlr.gunit.gUnitParser.AST";
                break;
            }
            default: {
                typeText = "org.antlr.gunit.gUnitParser.EOF";
            }
        }
        return typeText;
    }

    protected void writeTestFile(String dir, String fileName, String content) {
        try {
            File f = new File(dir, fileName);
            FileWriter w = new FileWriter(f);
            BufferedWriter bw = new BufferedWriter(w);
            bw.write(content);
            bw.close();
            w.close();
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "can't write file", ioe);
        }
    }

    public static String escapeForJava(String inputString) {
        inputString = inputString.replace("\\", "\\\\");
        inputString = inputString.replace("\"", "\\\"");
        inputString = inputString.replace("\n", "\\n").replace("\t", "\\t").replace("\r", "\\r").replace("\b", "\\b").replace("\f", "\\f");
        return inputString;
    }

    protected String changeFirstCapital(String ruleName) {
        String firstChar = String.valueOf(ruleName.charAt(0));
        return firstChar.toUpperCase() + ruleName.substring(1);
    }

    public static String normalizeTreeSpec(String t) {
        ArrayList<String> words = new ArrayList<String>();
        int i = 0;
        StringBuilder word = new StringBuilder();
        while (i < t.length()) {
            if (t.charAt(i) == '(' || t.charAt(i) == ')') {
                if (word.length() > 0) {
                    words.add(word.toString());
                    word.setLength(0);
                }
                words.add(String.valueOf(t.charAt(i)));
                ++i;
                continue;
            }
            if (Character.isWhitespace(t.charAt(i))) {
                if (word.length() > 0) {
                    words.add(word.toString());
                    word.setLength(0);
                }
                ++i;
                continue;
            }
            if (t.charAt(i) == '\"' && i - 1 >= 0 && (t.charAt(i - 1) == '(' || Character.isWhitespace(t.charAt(i - 1)))) {
                ++i;
                while (i < t.length() && t.charAt(i) != '\"') {
                    if (t.charAt(i) == '\\' && i + 1 < t.length() && t.charAt(i + 1) == '\"') {
                        word.append('\"');
                        i += 2;
                        continue;
                    }
                    word.append(t.charAt(i));
                    ++i;
                }
                ++i;
                words.add(word.toString());
                word.setLength(0);
                continue;
            }
            word.append(t.charAt(i));
            ++i;
        }
        if (word.length() > 0) {
            words.add(word.toString());
        }
        StringBuilder buf = new StringBuilder();
        for (int j = 0; j < words.size(); ++j) {
            if (j > 0 && !((String)words.get(j)).equals(")") && !((String)words.get(j - 1)).equals("(")) {
                buf.append(' ');
            }
            buf.append((String)words.get(j));
        }
        return buf.toString();
    }

    static {
        logger.addHandler(console);
    }
}

