/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www.async;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.HopMetadataBase;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.HopMetadataPropertyType;
import org.apache.hop.metadata.api.IHopMetadata;

@HopMetadata(key="async-web-service", name="i18n::AsyncWebService.name", description="i18n::AsyncWebService.description", image="ui/images/server.svg", documentationUrl="/metadata-types/async-web-service.html", hopMetadataPropertyType=HopMetadataPropertyType.SERVER_WEB_SERVICE_ASYNC)
public class AsyncWebService
extends HopMetadataBase
implements IHopMetadata {
    @HopMetadataProperty
    private boolean enabled;
    @HopMetadataProperty
    private String filename;
    @HopMetadataProperty
    private String statusVariables;
    @HopMetadataProperty
    private String bodyContentVariable;
    @HopMetadataProperty
    private String runConfigurationName;

    public AsyncWebService() {
        this.enabled = true;
        this.bodyContentVariable = "ASYNC_CONTENT";
    }

    public AsyncWebService(String name, boolean enabled, String filename, String statusVariables, String bodyContentVariable, String runConfigurationName) {
        super(name);
        this.enabled = enabled;
        this.filename = filename;
        this.statusVariables = statusVariables;
        this.bodyContentVariable = bodyContentVariable;
        this.runConfigurationName = runConfigurationName;
    }

    public List<String> getStatusVariablesList(IVariables variables) {
        ArrayList<String> list = new ArrayList<String>();
        String realVars = variables.resolve(this.statusVariables);
        if (StringUtils.isNotEmpty((String)realVars)) {
            String[] vars;
            for (String var : vars = realVars.split(",")) {
                list.add(Const.trim((String)var));
            }
        }
        return list;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getStatusVariables() {
        return this.statusVariables;
    }

    public void setStatusVariables(String statusVariables) {
        this.statusVariables = statusVariables;
    }

    public String getBodyContentVariable() {
        return this.bodyContentVariable;
    }

    public void setBodyContentVariable(String bodyContentVariable) {
        this.bodyContentVariable = bodyContentVariable;
    }

    public String getRunConfigurationName() {
        return this.runConfigurationName;
    }

    public void setRunConfigurationName(String runConfigurationName) {
        this.runConfigurationName = runConfigurationName;
    }
}

