/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming;

import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.beam.runners.flink.translation.wrappers.streaming.PushedBackElementsHandler;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.flink.api.common.state.ListState;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class NonKeyedPushedBackElementsHandler<@UnknownKeyFor T>
implements PushedBackElementsHandler<T> {
    private final @UnknownKeyFor @NonNull @Initialized ListState<T> elementState;

    static <T> @UnknownKeyFor @NonNull @Initialized NonKeyedPushedBackElementsHandler<T> create(@UnknownKeyFor @NonNull @Initialized ListState<T> elementState) {
        return new NonKeyedPushedBackElementsHandler<T>(elementState);
    }

    private NonKeyedPushedBackElementsHandler(@UnknownKeyFor @NonNull @Initialized ListState<T> elementState) {
        this.elementState = (ListState)Preconditions.checkNotNull(elementState);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Stream<T> getElements() throws @UnknownKeyFor @NonNull @Initialized Exception {
        return StreamSupport.stream(((Iterable)this.elementState.get()).spliterator(), false);
    }

    @Override
    public void clear() {
        this.elementState.clear();
    }

    @Override
    public void pushBack(T element) throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.elementState.add(element);
    }

    @Override
    public void pushBackAll(@UnknownKeyFor @NonNull @Initialized Iterable<T> elements) throws @UnknownKeyFor @NonNull @Initialized Exception {
        for (T e : elements) {
            this.elementState.add(e);
        }
    }
}

