/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.beam.runners.flink.translation.wrappers.streaming.PushedBackElementsHandler;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class KeyedPushedBackElementsHandler<@UnknownKeyFor K, @UnknownKeyFor T>
implements PushedBackElementsHandler<T> {
    private final @UnknownKeyFor @NonNull @Initialized KeySelector<T, K> keySelector;
    private final @UnknownKeyFor @NonNull @Initialized KeyedStateBackend<K> backend;
    private final @UnknownKeyFor @NonNull @Initialized String stateName;
    private final @UnknownKeyFor @NonNull @Initialized ListState<T> state;

    static <K, T> @UnknownKeyFor @NonNull @Initialized KeyedPushedBackElementsHandler<K, T> create(@UnknownKeyFor @NonNull @Initialized KeySelector<T, K> keySelector, @UnknownKeyFor @NonNull @Initialized KeyedStateBackend<K> backend, @UnknownKeyFor @NonNull @Initialized ListStateDescriptor<T> stateDescriptor) throws @UnknownKeyFor @NonNull @Initialized Exception {
        return new KeyedPushedBackElementsHandler<K, T>(keySelector, backend, stateDescriptor);
    }

    private KeyedPushedBackElementsHandler(@UnknownKeyFor @NonNull @Initialized KeySelector<T, K> keySelector, @UnknownKeyFor @NonNull @Initialized KeyedStateBackend<K> backend, @UnknownKeyFor @NonNull @Initialized ListStateDescriptor<T> stateDescriptor) throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.keySelector = Objects.requireNonNull(keySelector);
        this.backend = Objects.requireNonNull(backend);
        this.stateName = stateDescriptor.getName();
        this.state = (ListState)backend.getPartitionedState((Object)VoidNamespace.INSTANCE, (TypeSerializer)VoidNamespaceSerializer.INSTANCE, stateDescriptor);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Stream<T> getElements() {
        return this.backend.getKeys(this.stateName, (Object)VoidNamespace.INSTANCE).flatMap(key -> {
            try {
                this.backend.setCurrentKey(key);
                return StreamSupport.stream(((Iterable)this.state.get()).spliterator(), false);
            }
            catch (Exception e) {
                throw new RuntimeException("Error reading keyed state.", e);
            }
        });
    }

    @Override
    public void clear() throws @UnknownKeyFor @NonNull @Initialized Exception {
        List keys = this.backend.getKeys(this.stateName, (Object)VoidNamespace.INSTANCE).collect(Collectors.toList());
        for (Object key : keys) {
            this.backend.setCurrentKey(key);
            this.state.clear();
        }
    }

    @Override
    public void pushBack(T element) throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.backend.setCurrentKey(this.keySelector.getKey(element));
        this.state.add(element);
    }

    @Override
    public void pushBackAll(@UnknownKeyFor @NonNull @Initialized Iterable<T> elements) throws @UnknownKeyFor @NonNull @Initialized Exception {
        for (T e : elements) {
            this.pushBack(e);
        }
    }
}

