/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.SpooledFile;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.OutputDeleteAction;
import com.ibm.as400.vaccess.OutputHoldAction;
import com.ibm.as400.vaccess.OutputMoveAction;
import com.ibm.as400.vaccess.OutputPrintNextAction;
import com.ibm.as400.vaccess.OutputPropertiesPane;
import com.ibm.as400.vaccess.OutputReleaseAction;
import com.ibm.as400.vaccess.OutputReplyAction;
import com.ibm.as400.vaccess.OutputSendAction;
import com.ibm.as400.vaccess.OutputViewAction;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPrinterOutput;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.util.Calendar;
import javax.swing.Icon;

public class VOutput
implements VObject {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    public static final Object OUTPUTNAME_PROPERTY = "Output name";
    public static final Object USERSPECDATA_PROPERTY = "User-specified data";
    public static final Object USER_PROPERTY = "User";
    public static final Object STATUS_PROPERTY = "Status";
    public static final Object PRINTER_PROPERTY = "Printer";
    public static final Object PAGESPERCOPY_PROPERTY = "Pages per copy";
    public static final Object COPIESLEFT_PROPERTY = "Copies left";
    public static final Object DATE_PROPERTY = "Date created";
    public static final Object FORMTYPE_PROPERTY = "Form type";
    public static final Object JOB_PROPERTY = "Job";
    public static final Object JOBNUMBER_PROPERTY = "Job number";
    public static final Object NUMBER_PROPERTY = "Number";
    public static final Object OUTPUTQUEUE_PROPERTY = "Output queue";
    public static final Object OUTPUTQUEUELIB_PROPERTY = "Output queue library";
    public static final Object PRIORITY_PROPERTY = "Priority on output queue";
    public static final Object USERCOMMENT_PROPERTY = "User comment";
    private static final String description_ = ResourceLoader.getPrintText("OUTPUT_DESCRIPTION");
    private static final Icon icon16_ = ResourceLoader.getIcon("VOutput16.gif", description_);
    private static final Icon icon32_ = ResourceLoader.getIcon("VOutput32.gif", description_);
    private static final String closedText_ = ResourceLoader.getPrintText("CLOSED");
    private static final String heldText_ = ResourceLoader.getPrintText("HELD");
    private static final String msgWaitingText_ = ResourceLoader.getPrintText("MESSAGE_WAITING");
    private static final String openText_ = ResourceLoader.getPrintText("OPEN");
    private static final String pendingText_ = ResourceLoader.getPrintText("PENDING");
    private static final String printerText_ = ResourceLoader.getPrintText("PRINTER");
    private static final String readyText_ = ResourceLoader.getPrintText("READY");
    private static final String savedText_ = ResourceLoader.getPrintText("SAVED");
    private static final String writingText_ = ResourceLoader.getPrintText("WRITING");
    private static final String standardText_ = ResourceLoader.getPrintText("STANDARD");
    private static final String jobValueText_ = ResourceLoader.getPrintText("JOB_VALUE");
    private static final String notAssignedText_ = ResourceLoader.getPrintText("NOT_ASSIGNED");
    private static final String groupText_ = ResourceLoader.getPrintText("GROUP");
    private static Calendar calendar_ = AS400Calendar.getGregorianInstance();
    private VAction[] actions_ = null;
    private Integer actionsLock_ = 0;
    private SpooledFile splF_ = null;
    private VPrinterOutput parent_ = null;
    private VPropertiesPane propertiesPane_ = null;
    private Integer propertiesPaneLock_ = 0;
    private Integer reloadLock_ = 0;
    private ErrorEventSupport errorEventSupport_ = new ErrorEventSupport(this);
    private VObjectEventSupport objectEventSupport_ = new VObjectEventSupport(this);
    private WorkingEventSupport workingEventSupport_ = new WorkingEventSupport(this);

    public VOutput(VPrinterOutput parent, SpooledFile spooledFile) {
        if (spooledFile == null) {
            throw new NullPointerException("spooledFile");
        }
        if (parent == null) {
            throw new NullPointerException("parent");
        }
        this.parent_ = parent;
        this.splF_ = spooledFile;
        this.actions_ = new VAction[8];
        this.actions_[0] = new OutputReplyAction(this, spooledFile);
        this.actions_[1] = new OutputHoldAction(this, spooledFile);
        this.actions_[2] = new OutputReleaseAction(this, spooledFile);
        this.actions_[3] = new OutputPrintNextAction(this, spooledFile, parent);
        this.actions_[4] = new OutputSendAction(this, spooledFile);
        this.actions_[5] = new OutputMoveAction(this, spooledFile, parent);
        this.actions_[6] = new OutputDeleteAction((VObject)this, spooledFile, parent);
        this.actions_[7] = new OutputViewAction(this, spooledFile);
        for (int i = 0; i < this.actions_.length; ++i) {
            this.actions_[i].addErrorListener(this.errorEventSupport_);
            this.actions_[i].addVObjectListener(this.objectEventSupport_);
            this.actions_[i].addWorkingListener(this.workingEventSupport_);
        }
        this.propertiesPane_ = new OutputPropertiesPane(this, spooledFile);
        this.propertiesPane_.addErrorListener(this.errorEventSupport_);
        this.propertiesPane_.addVObjectListener(this.objectEventSupport_);
        this.propertiesPane_.addWorkingListener(this.workingEventSupport_);
    }

    @Override
    public void addErrorListener(ErrorListener listener) {
        this.errorEventSupport_.addErrorListener(listener);
    }

    @Override
    public void addVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.addVObjectListener(listener);
    }

    @Override
    public void addWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.addWorkingListener(listener);
    }

    @Override
    public synchronized VAction[] getActions() {
        try {
            String status = this.splF_.getStringAttribute(106).trim();
            if (status.equals("*MESSAGE")) {
                this.actions_[0].setEnabled(true);
            } else {
                this.actions_[0].setEnabled(false);
            }
            if (status.equals("*READY")) {
                this.actions_[1].setEnabled(true);
            } else {
                this.actions_[1].setEnabled(false);
            }
            if (status.equals("*HELD")) {
                this.actions_[2].setEnabled(true);
            } else {
                this.actions_[2].setEnabled(false);
            }
        }
        catch (Exception e) {
            this.errorEventSupport_.fireError(e);
        }
        return this.actions_;
    }

    @Override
    public VAction getDefaultAction() {
        return null;
    }

    @Override
    public Icon getIcon(int size, boolean open) {
        if (size == 32) {
            return icon32_;
        }
        return icon16_;
    }

    @Override
    public VPropertiesPane getPropertiesPane() {
        return this.propertiesPane_;
    }

    @Override
    public synchronized Object getPropertyValue(Object propertyIdentifier) {
        try {
            if (propertyIdentifier == NAME_PROPERTY) {
                return this;
            }
            if (propertyIdentifier == DESCRIPTION_PROPERTY) {
                return description_;
            }
            if (propertyIdentifier == OUTPUTNAME_PROPERTY) {
                return this;
            }
            if (propertyIdentifier == USERSPECDATA_PROPERTY) {
                return this.splF_.getStringAttribute(116);
            }
            if (propertyIdentifier == USER_PROPERTY) {
                return this.splF_.getJobUser();
            }
            if (propertyIdentifier == STATUS_PROPERTY) {
                String status = this.splF_.getStringAttribute(106);
                if (status.trim().equals("*CLOSED")) {
                    return closedText_;
                }
                if (status.trim().equals("*HELD")) {
                    return heldText_;
                }
                if (status.trim().equals("*MESSAGE")) {
                    return msgWaitingText_;
                }
                if (status.trim().equals("*OPEN")) {
                    return openText_;
                }
                if (status.trim().equals("*PENDING")) {
                    return pendingText_;
                }
                if (status.trim().equals("*PRINTER")) {
                    return printerText_;
                }
                if (status.trim().equals("*READY")) {
                    return readyText_;
                }
                if (status.trim().equals("*SAVED")) {
                    return savedText_;
                }
                if (status.trim().equals("*WRITING")) {
                    return writingText_;
                }
                return null;
            }
            if (propertyIdentifier == PRINTER_PROPERTY) {
                String ptrAssigned = this.splF_.getStringAttribute(186).trim();
                if (ptrAssigned.equals("1")) {
                    return this.splF_.getStringAttribute(89);
                }
                if (ptrAssigned.equals("2")) {
                    return groupText_;
                }
                return notAssignedText_;
            }
            if (propertyIdentifier == PAGESPERCOPY_PROPERTY) {
                return this.splF_.getIntegerAttribute(111);
            }
            if (propertyIdentifier == COPIESLEFT_PROPERTY) {
                return this.splF_.getIntegerAttribute(29);
            }
            if (propertyIdentifier == DATE_PROPERTY) {
                String date = this.splF_.getStringAttribute(34);
                String time = this.splF_.getStringAttribute(110);
                calendar_.set(Integer.parseInt(date.substring(0, 3)) + 1900, Integer.parseInt(date.substring(3, 5)) - 1, Integer.parseInt(date.substring(5, 7)), Integer.parseInt(time.substring(0, 2)), Integer.parseInt(time.substring(2, 4)), Integer.parseInt(time.substring(4, 6)));
                return calendar_.getTime();
            }
            if (propertyIdentifier == FORMTYPE_PROPERTY) {
                String formType = this.splF_.getStringAttribute(48).trim();
                if (formType.equals("*STD")) {
                    return standardText_;
                }
                return formType;
            }
            if (propertyIdentifier == JOB_PROPERTY) {
                return this.splF_.getJobName();
            }
            if (propertyIdentifier == JOBNUMBER_PROPERTY) {
                return this.splF_.getJobNumber();
            }
            if (propertyIdentifier == NUMBER_PROPERTY) {
                return this.splF_.getNumber();
            }
            if (propertyIdentifier == OUTPUTQUEUE_PROPERTY) {
                QSYSObjectPathName outQPath = new QSYSObjectPathName(this.splF_.getStringAttribute(-6));
                return outQPath.getObjectName();
            }
            if (propertyIdentifier == OUTPUTQUEUELIB_PROPERTY) {
                QSYSObjectPathName outQPath = new QSYSObjectPathName(this.splF_.getStringAttribute(-6));
                return outQPath.getLibraryName();
            }
            if (propertyIdentifier == PRIORITY_PROPERTY) {
                String outQPty = this.splF_.getStringAttribute(72).trim();
                if (outQPty.equals("*JOB")) {
                    return jobValueText_;
                }
                return outQPty;
            }
            if (propertyIdentifier == USERCOMMENT_PROPERTY) {
                return this.splF_.getStringAttribute(115);
            }
            return null;
        }
        catch (Exception e) {
            this.errorEventSupport_.fireError(e);
            return null;
        }
    }

    public SpooledFile getSpooledFile() {
        return this.splF_;
    }

    @Override
    public synchronized void load() {
        this.workingEventSupport_.fireStartWorking();
        try {
            this.splF_.update();
        }
        catch (Exception e) {
            this.errorEventSupport_.fireError(e);
        }
        this.workingEventSupport_.fireStopWorking();
    }

    @Override
    public String getText() {
        return this.splF_.getName();
    }

    @Override
    public void removeErrorListener(ErrorListener listener) {
        this.errorEventSupport_.removeErrorListener(listener);
    }

    @Override
    public void removeVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.removeVObjectListener(listener);
    }

    @Override
    public void removeWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.removeWorkingListener(listener);
    }

    public String toString() {
        return this.splF_.getName().trim() + "  " + Integer.toString(this.splF_.getNumber()) + "  " + this.splF_.getJobUser().trim() + "  " + this.splF_.getJobNumber().trim() + "  " + this.splF_.getJobName().trim();
    }
}

