/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.micro;

import com.ibm.as400.micro.JdbcMeService;
import com.ibm.as400.micro.MicroDataInputStream;
import com.ibm.as400.micro.MicroDataOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

class StatementHandler {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private JdbcMeService service_;
    private MicroDataInputStream in_;
    private MicroDataOutputStream out_;

    public StatementHandler(JdbcMeService jdbcme, MicroDataInputStream in, MicroDataOutputStream out) {
        this.service_ = jdbcme;
        this.in_ = in;
        this.out_ = out;
    }

    public void process(Statement statement, int funcId) throws IOException {
        switch (funcId) {
            case 4705: {
                this.close(statement);
                break;
            }
            case 4706: {
                this.execute(statement);
                break;
            }
            default: {
                System.out.println("Error - Statement Function ID not recognized - function code: " + funcId);
            }
        }
    }

    public void close(Statement statement) throws IOException {
        try {
            statement.close();
        }
        catch (SQLException e) {
            System.out.println("Exception caught trying to close Statement object " + statement);
            e.printStackTrace();
        }
        this.service_.removeStatement(statement);
    }

    public void execute(Statement statement) throws IOException {
        try {
            String sql = this.in_.readUTF();
            boolean rsYes = statement.execute(sql);
            if (rsYes) {
                this.out_.writeInt(1);
                ResultSet rs = statement.getResultSet();
                this.service_.addResultSet(statement, rs);
                int objectId = this.service_.mapObject(rs);
                this.out_.writeInt(objectId);
                ResultSetMetaData rsmd = rs.getMetaData();
                int count = rsmd.getColumnCount();
                this.out_.writeInt(count);
                for (int i = 0; i < count; ++i) {
                    this.out_.writeInt(rsmd.getColumnType(i + 1));
                }
            } else {
                this.out_.writeInt(0);
                this.out_.writeInt(statement.getUpdateCount());
            }
            this.out_.flush();
        }
        catch (SQLException e) {
            this.service_.handleException(e);
        }
    }
}

