/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.micro;

import com.ibm.as400.access.Trace;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

class MicroDataInputStream {
    DataInputStream in_;

    public MicroDataInputStream(InputStream in) throws IOException {
        this.in_ = new DataInputStream(in);
    }

    public boolean readBoolean() throws IOException {
        boolean b = this.in_.readBoolean();
        if (Trace.isTraceOn()) {
            Trace.log(6, Thread.currentThread().getName() + " in  > " + b);
        }
        return b;
    }

    public byte readByte() throws IOException {
        byte b = this.in_.readByte();
        if (Trace.isTraceOn()) {
            Trace.log(6, Thread.currentThread().getName() + " in  > " + b);
        }
        return b;
    }

    public void readBytes(byte[] b) throws IOException {
        this.in_.readFully(b);
        if (Trace.isTraceOn()) {
            Trace.log(6, "  " + Thread.currentThread().getName() + " in > ", b);
        }
    }

    public double readDouble() throws IOException {
        double d = this.in_.readDouble();
        if (Trace.isTraceOn()) {
            Trace.log(6, Thread.currentThread().getName() + " in  > " + d);
        }
        return d;
    }

    public float readFloat() throws IOException {
        float f = this.in_.readFloat();
        if (Trace.isTraceOn()) {
            Trace.log(6, Thread.currentThread().getName() + " in  > " + f);
        }
        return f;
    }

    public int readInt() throws IOException {
        int i = this.in_.readInt();
        if (Trace.isTraceOn()) {
            Trace.log(6, Thread.currentThread().getName() + " in  > " + Integer.toHexString(i));
        }
        return i;
    }

    public long readLong() throws IOException {
        long l = this.in_.readLong();
        if (Trace.isTraceOn()) {
            Trace.log(6, Thread.currentThread().getName() + " in  > " + l);
        }
        return l;
    }

    public short readShort() throws IOException {
        short s = this.in_.readShort();
        if (Trace.isTraceOn()) {
            Trace.log(6, Thread.currentThread().getName() + " in  > " + s);
        }
        return s;
    }

    public String readString() throws IOException {
        return this.readUTF();
    }

    public String readUTF() throws IOException {
        String s = this.in_.readUTF();
        if (Trace.isTraceOn()) {
            Trace.log(6, Thread.currentThread().getName() + " in  > " + s);
        }
        return s;
    }

    public int skipBytes(int count) throws IOException {
        return this.in_.skipBytes(count);
    }
}

