/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Timestamp;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.DateTimeConverter;
import com.ibm.as400.access.DirectoryEntry;
import com.ibm.as400.access.DirectoryEntryList;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Job;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserObjectsOwnedList;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class User
implements Serializable {
    static final long serialVersionUID = 5L;
    private static final String[] SPECIAL_AUTHORITIES = new String[]{"*ALLOBJ", "*SECADM", "*JOBCTL", "*SPLCTL", "*SAVSYS", "*SERVICE", "*AUDIT", "*IOSYSCFG"};
    public static final String NONE = "*NONE";
    public static final String SPECIAL_AUTHORITY_ALL_OBJECT = SPECIAL_AUTHORITIES[0];
    public static final String SPECIAL_AUTHORITY_AUDIT = SPECIAL_AUTHORITIES[6];
    public static final String SPECIAL_AUTHORITY_IO_SYSTEM_CONFIGURATION = SPECIAL_AUTHORITIES[7];
    public static final String SPECIAL_AUTHORITY_JOB_CONTROL = SPECIAL_AUTHORITIES[2];
    public static final String SPECIAL_AUTHORITY_SAVE_SYSTEM = SPECIAL_AUTHORITIES[4];
    public static final String SPECIAL_AUTHORITY_SECURITY_ADMINISTRATOR = SPECIAL_AUTHORITIES[1];
    public static final String SPECIAL_AUTHORITY_SERVICE = SPECIAL_AUTHORITIES[5];
    public static final String SPECIAL_AUTHORITY_SPOOL_CONTROL = SPECIAL_AUTHORITIES[3];
    private static final ProgramParameter ERROR_CODE = new ProgramParameter(new byte[8]);
    private AS400 system_ = null;
    private String name_ = null;
    private String description_ = null;
    private boolean groupHasMember_ = false;
    private CommandCall chgUsrPrf_ = null;
    private CommandCall chgUsrAud_ = null;
    private static final boolean COMMAND_CHGUSRPRF = true;
    private static final boolean COMMAND_CHGUSRAUD = false;
    private boolean partiallyLoaded_ = false;
    private boolean loaded_ = false;
    private boolean connected_ = false;
    private transient PropertyChangeSupport propertyChangeListeners_ = null;
    private transient VetoableChangeSupport vetoableChangeListeners_ = null;
    private String userProfileName_;
    private Date previousSignedOnDate_;
    private int signedOnAttemptsNotValid_;
    private String status_;
    private byte[] passwordLastChangedDateBytes_;
    private Date passwordLastChangedDate_;
    private boolean noPassword_;
    private int passwordExpirationInterval_;
    private byte[] passwordExpireDateBytes_;
    private Date passwordExpireDate_;
    private int daysUntilPasswordExpire_;
    private boolean passwordSetExpire_;
    private String userClassName_;
    private String[] specialAuthority_;
    private String groupProfileName_;
    private String owner_;
    private String groupAuthority_;
    private String assistanceLevel_;
    private String currentLibraryName_;
    private String initialMenu_;
    private String initialProgram_;
    private String limitCapabilities_;
    private String displaySignOnInformation_;
    private String limitDeviceSessions_;
    private String keyboardBuffering_;
    private int maximumStorageAllowed_;
    private int storageUsed_;
    private long maximumStorageAllowedInLong_;
    private long storageUsedInLong_;
    private int highestSchedulingPriority_;
    private String jobDescription_;
    private String accountingCode_;
    private String messageQueue_;
    private String messageQueueDeliveryMethod_;
    private int messageQueueSeverity_;
    private String outputQueue_;
    private String printDevice_;
    private String specialEnvironment_;
    private String attentionKeyHandlingProgram_;
    private String languageID_;
    private String countryID_;
    private int ccsid_;
    private String[] userOptions_;
    private String sortSequenceTable_;
    private String objectAuditingValue_;
    private String[] userActionAuditLevel_;
    private String groupAuthorityType_;
    private String[] supplementalGroups_;
    private long userID_;
    private long groupID_;
    private String homeDirectory_;
    private String[] localeJobAttributes_;
    private String localePathName_;
    private boolean withDigitalCertificates_;
    private String chridControl_;
    private String[] iaspNames_;
    private int[] iaspStorageAllowed_;
    private int[] iaspStorageUsed_;
    private boolean localPasswordManagement_;
    private String pwdChangeBlock_;
    private boolean userEntitlementRequired_;
    private int userExpirationInterval_;
    private byte[] userExpirationDateBytes_;
    private Date userExpirationDate_;
    private String userExpirationAction_;
    private transient DateTimeConverter dateConverter_;
    private String jobDateFormat_;
    private transient AS400Timestamp timestampConverter_;
    private boolean authCollectionActive_;
    private boolean authCollectionRepositoryExist_;
    private boolean authCollectionDeleted_;
    private String detailInSTRAUTCOL_;
    private String[] libNamesInSTRAUTCOL_;
    private String[] objectNamesInSTRAUTCOL_;
    private String[] objectTypesInSTRAUTCOL_;
    private String[] DLOObjectTypesInSTRAUTCOL_;
    private String[] fileSystemObjectTypesInSTRAUTCOL_;
    private String[] omitLibNamesInSTRAUTCOL_;
    public static final String AUTHENTICATION_METHOD_TOTP = "*TOTP";
    public static final String AUTHENTICATION_METHOD_REGFAC = "*REGFAC";
    private String[] authenticationMethods_;
    private int totpOptionalInterval_;
    private int totpOptionalIntervalRemaining_;
    private boolean totpKeyExistsIndicator_;
    private Date totpKeyLastChangedDate_;
    private static final String[] LOCALE_ATTRIBUTES = new String[]{"*NONE", "*SYSVAL", "*CCSID", "*DATFMT", "*DATSEP", "*SRTSEQ", "*TIMSEP", "*DECFMT"};
    private static final int FORMAT_DTS = 1;
    private static final String[] AUDIT_LEVELS = new String[]{"*CMD", "*CREATE", "*DELETE", "*JOBDTA", "*OBJMGT", "*OFCSRV", "*PGMADP", "*SAVRST", "*SECURITY", "*SERVICE", "*SPLFDTA", "*SYSMGT", "*OPTICAL", "*AUTFAIL", "*JOBBAS", "*JOBCHGUSR", "*NETBAS", "*NETCLU", "*NETCMN", "*NETFAIL", "*NETSCK", "*PGMFAIL", "*PRTDTA", "*SECCFG", "*SECDIRSRV", "*SECIPC", "*SECNAS", "*SECRUN", "*SECSCKD", "*SECVFY", "*SECVLDL", "*NETSECURE", "*NETUDP"};
    private static final String[] USER_OPTIONS = new String[]{"*CLKWD", "*EXPERT", "*HLPFULL", "*STSMSG", "*NOSTSMSG", "*ROLLKEY", "*PRTMSG"};

    public User() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing User object.");
        }
    }

    public User(AS400 system, String name) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing User object, system: " + system + ", name: " + name);
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (name == null) {
            Trace.log(2, "Parameter 'name' is null.");
            throw new NullPointerException("name");
        }
        if ((name = name.trim()).length() > 10) {
            Trace.log(2, "Length of parameter 'name' is not valid: '" + name + "'");
            throw new ExtendedIllegalArgumentException("name (" + name + ")", 1);
        }
        if ((name.length() == 0 || !Character.isLetter(name.charAt(0))) && Trace.traceOn_) {
            Trace.log(4, "Value of parameter 'name' is not a valid user profile name: '" + name + "'");
        }
        this.system_ = system;
        this.name_ = name.toUpperCase();
    }

    User(AS400 system, String name, boolean groupHasMember, String description) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing User object, system: " + system + ", name: " + name);
        }
        this.system_ = system;
        this.name_ = name;
        this.groupHasMember_ = groupHasMember;
        this.description_ = description;
        this.partiallyLoaded_ = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding property change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        User user = this;
        synchronized (user) {
            if (this.propertyChangeListeners_ == null) {
                this.propertyChangeListeners_ = new PropertyChangeSupport(this);
            }
            this.propertyChangeListeners_.addPropertyChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding vetoable change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        User user = this;
        synchronized (user) {
            if (this.vetoableChangeListeners_ == null) {
                this.vetoableChangeListeners_ = new VetoableChangeSupport(this);
            }
            this.vetoableChangeListeners_.addVetoableChangeListener(listener);
        }
    }

    public boolean exists() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Determining user existence.");
        }
        if (this.system_ == null) {
            Trace.log(2, "Cannot connect to server before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.name_ == null) {
            Trace.log(2, "Cannot connect to server before setting name.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        try {
            String cmdString = "QSYS/CHKOBJ OBJ(QSYS/" + this.name_ + ") OBJTYPE(*USRPRF) AUT(*NONE)";
            CommandCall cmd = new CommandCall(this.system_, cmdString);
            if (!cmd.run()) {
                throw new AS400Exception(cmd.getMessageList());
            }
        }
        catch (AS400Exception e) {
            AS400Message[] messages = e.getAS400MessageList();
            if (messages.length == 1 && messages[0].getID().equalsIgnoreCase("CPF9801")) {
                return false;
            }
            throw e;
        }
        return true;
    }

    public String getAccountingCode() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.accountingCode_;
    }

    public String getAssistanceLevel() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.assistanceLevel_;
    }

    public String getAttentionKeyHandlingProgram() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.attentionKeyHandlingProgram_;
    }

    public String[] getAuthenticationMethods() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.authenticationMethods_;
    }

    public int getCCSID() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.ccsid_;
    }

    public String getCHRIDControl() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.chridControl_;
    }

    public String getCountryID() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.countryID_;
    }

    public String getCurrentLibraryName() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.currentLibraryName_;
    }

    public int getDaysUntilPasswordExpire() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.daysUntilPasswordExpire_;
    }

    public String getDescription() {
        if (!this.loaded_ && !this.partiallyLoaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.description_;
    }

    public DirectoryEntry getDirectoryEntry() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        DirectoryEntryList list = new DirectoryEntryList(this.system_);
        list.addSelection("USER", this.name_.toUpperCase());
        DirectoryEntry[] entries = list.getEntries();
        if (entries.length == 0) {
            return null;
        }
        return entries[0];
    }

    public String getDisplaySignOnInformation() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.displaySignOnInformation_;
    }

    public String getGroupAuthority() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.groupAuthority_;
    }

    public String getGroupAuthorityType() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.groupAuthorityType_;
    }

    public long getGroupID() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.groupID_;
    }

    @Deprecated
    public int getGroupIDNumber() {
        return (int)this.getGroupID();
    }

    public String getGroupProfileName() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.groupProfileName_;
    }

    public int getHighestSchedulingPriority() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.highestSchedulingPriority_;
    }

    public String getHomeDirectory() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.homeDirectory_;
    }

    public String[] getIASPNames() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.iaspNames_;
    }

    public int getIASPStorageAllowed(String iaspName) {
        if (iaspName == null) {
            Trace.log(2, "Parameter 'iaspName' is null.");
            throw new NullPointerException("iaspName");
        }
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        if (this.iaspStorageAllowed_ != null) {
            for (int i = 0; i < this.iaspNames_.length; ++i) {
                if (!this.iaspNames_[i].equals(iaspName)) continue;
                return this.iaspStorageAllowed_[i];
            }
        }
        return -2;
    }

    public int getIASPStorageUsed(String iaspName) {
        if (iaspName == null) {
            Trace.log(2, "Parameter 'iaspName' is null.");
            throw new NullPointerException("iaspName");
        }
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        if (this.iaspStorageUsed_ != null) {
            for (int i = 0; i < this.iaspNames_.length; ++i) {
                if (!this.iaspNames_[i].equals(iaspName)) continue;
                return this.iaspStorageUsed_[i];
            }
        }
        return -2;
    }

    public String getInitialMenu() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.initialMenu_;
    }

    public String getInitialProgram() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.initialProgram_;
    }

    public String getJobDescription() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.jobDescription_;
    }

    public String getKeyboardBuffering() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.keyboardBuffering_;
    }

    public String getLanguageID() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.languageID_;
    }

    public String getLimitCapabilities() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.limitCapabilities_;
    }

    public String getLimitDeviceSessions() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.limitDeviceSessions_;
    }

    public String[] getLocaleJobAttributes() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.localeJobAttributes_;
    }

    public String getLocalePathName() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.localePathName_;
    }

    public int getMaximumStorageAllowed() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.maximumStorageAllowed_;
    }

    public long getMaximumStorageAllowedInLong() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.maximumStorageAllowedInLong_;
    }

    public String getMessageQueue() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.messageQueue_;
    }

    public String getMessageQueueDeliveryMethod() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.messageQueueDeliveryMethod_;
    }

    public int getMessageQueueSeverity() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.messageQueueSeverity_;
    }

    public String getName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting name: " + this.name_);
        }
        return this.name_;
    }

    public String getObjectAuditingValue() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.objectAuditingValue_;
    }

    public UserObjectsOwnedList getObjectsOwned() {
        if (Trace.traceOn_) {
            Trace.log(1, "Loading user information.");
        }
        if (this.system_ == null) {
            Trace.log(2, "Cannot connect to server before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.name_ == null) {
            Trace.log(2, "Cannot connect to server before setting name.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        return new UserObjectsOwnedList(this.system_, this.name_);
    }

    public String getOutputQueue() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.outputQueue_;
    }

    public String getOwner() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.owner_;
    }

    public Date getPasswordExpireDate() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        if (this.passwordExpireDate_ == null) {
            try {
                if (User.isNullOrBlanks(this.passwordExpireDateBytes_)) {
                    return null;
                }
                AS400Timestamp conv = this.getTimestampConverter(1);
                this.passwordExpireDate_ = conv.toDate(conv.toTimestamp(this.passwordExpireDateBytes_), TimeZone.getDefault());
            }
            catch (Exception e) {
                if (Trace.traceOn_) {
                    Trace.log(2, "Exception while converting datePasswordExpires:", (Throwable)e);
                }
                throw new InternalErrorException(10, (Throwable)e);
            }
        }
        return this.passwordExpireDate_;
    }

    private synchronized AS400Timestamp getTimestampConverter(int format) {
        if (this.timestampConverter_ == null) {
            this.timestampConverter_ = new AS400Timestamp(AS400.getDefaultTimeZone(this.system_));
            this.timestampConverter_.setFormat(format);
        } else if (format != this.timestampConverter_.getFormat()) {
            this.timestampConverter_.setFormat(format);
        }
        return this.timestampConverter_;
    }

    public String getPasswordChangeBlock() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.pwdChangeBlock_;
    }

    public int getPasswordExpirationInterval() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.passwordExpirationInterval_;
    }

    public Date getPasswordLastChangedDate() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        if (this.passwordLastChangedDate_ == null) {
            try {
                if (User.isNullOrBlanks(this.passwordLastChangedDateBytes_)) {
                    return null;
                }
                AS400Timestamp conv = this.getTimestampConverter(1);
                this.passwordLastChangedDate_ = conv.toDate(conv.toTimestamp(this.passwordLastChangedDateBytes_), TimeZone.getDefault());
            }
            catch (Exception e) {
                Trace.log(2, "Exception while converting passwordLastChangedDate:", (Throwable)e);
                throw new InternalErrorException(10, (Throwable)e);
            }
        }
        return this.passwordLastChangedDate_;
    }

    public Date getPreviousSignedOnDate() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.previousSignedOnDate_;
    }

    public String getPrintDevice() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.printDevice_;
    }

    public int getSignedOnAttemptsNotValid() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.signedOnAttemptsNotValid_;
    }

    public String getSortSequenceTable() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.sortSequenceTable_;
    }

    public String[] getSpecialAuthority() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.specialAuthority_;
    }

    public String getSpecialEnvironment() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.specialEnvironment_;
    }

    public String getStatus() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.status_;
    }

    public int getStorageUsed() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.storageUsed_;
    }

    public long getStorageUsedInLong() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.storageUsedInLong_;
    }

    public String[] getSupplementalGroups() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.supplementalGroups_;
    }

    public int getSupplementalGroupsNumber() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.supplementalGroups_ == null ? 0 : this.supplementalGroups_.length;
    }

    public AS400 getSystem() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system: " + this.system_);
        }
        return this.system_;
    }

    public int getTOTPOptionalInterval() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.totpOptionalInterval_;
    }

    public int getTOTPOptionalIntervalRemaining() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.totpOptionalIntervalRemaining_;
    }

    public boolean getTOTPKeyExistsIndicator() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.totpKeyExistsIndicator_;
    }

    public Date getTOTPKeyLastChangedDate() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.totpKeyLastChangedDate_;
    }

    public String[] getUserActionAuditLevel() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.userActionAuditLevel_;
    }

    public String getUserClassName() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.userClassName_;
    }

    public String getUserExpirationAction() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.userExpirationAction_;
    }

    public Date getUserExpirationDate() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        if (this.userExpirationDate_ == null) {
            try {
                if (User.isNullOrBlanks(this.userExpirationDateBytes_)) {
                    return null;
                }
                AS400Timestamp conv = this.getTimestampConverter(1);
                this.userExpirationDate_ = conv.toDate(conv.toTimestamp(this.userExpirationDateBytes_), TimeZone.getDefault());
            }
            catch (Exception e) {
                if (Trace.traceOn_) {
                    Trace.log(2, "Exception while converting userExpirationDate:", (Throwable)e);
                }
                throw new InternalErrorException(10, (Throwable)e);
            }
        }
        return this.userExpirationDate_;
    }

    private static final boolean isNullOrBlanks(byte[] bytes) {
        if (bytes != null) {
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] == 64) continue;
                return false;
            }
        }
        return true;
    }

    public int getUserExpirationInterval() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.userExpirationInterval_;
    }

    public long getUserID() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.userID_;
    }

    @Deprecated
    public int getUserIDNumber() {
        return (int)this.getUserID();
    }

    public String[] getUserOptions() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.userOptions_;
    }

    public String getUserProfileName() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.userProfileName_;
    }

    public boolean isAuthCollectionActive() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.authCollectionActive_;
    }

    public boolean isAuthCollectionRepositoryExist() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.authCollectionRepositoryExist_;
    }

    public boolean isAuthCollectionDeleted() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.authCollectionDeleted_;
    }

    public String getDetailInSTRAUTCOL() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.detailInSTRAUTCOL_;
    }

    public String[] getLibNameInSTRAUTCOL() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.libNamesInSTRAUTCOL_;
    }

    public String[] getObjectNamesInSTRAUTCOL() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.objectNamesInSTRAUTCOL_;
    }

    public String[] getObjectTypesInSTRAUTCOL() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.objectTypesInSTRAUTCOL_;
    }

    public String[] getDLOObjectTypesInSTRAUTCOL() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.DLOObjectTypesInSTRAUTCOL_;
    }

    public String[] getFileSystemObjectTypesInSTRAUTCOL() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.fileSystemObjectTypesInSTRAUTCOL_;
    }

    public String[] getOmitLibNamesInSTRAUTCOL() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.omitLibNamesInSTRAUTCOL_;
    }

    public boolean hasSpecialAuthority(String authority) {
        String[] supplementalGroups;
        String primaryGroup;
        if (authority == null) {
            Trace.log(2, "Parameter 'authority' is null.");
            throw new NullPointerException("authority");
        }
        String[] specialAuthorities = this.getSpecialAuthority();
        if (specialAuthorities != null) {
            for (int i = 0; i < specialAuthorities.length; ++i) {
                if (!specialAuthorities[i].equals(authority)) continue;
                return true;
            }
        }
        if ((primaryGroup = this.getGroupProfileName()) != null && !primaryGroup.equals(NONE)) {
            try {
                User group = new User(this.system_, primaryGroup);
                if (group.hasSpecialAuthority(authority)) {
                    return true;
                }
            }
            catch (Exception e) {
                Trace.log(2, "Unexpected Exception constructing User object:", (Throwable)e);
                throw new InternalErrorException(10, (Throwable)e);
            }
        }
        if ((supplementalGroups = this.getSupplementalGroups()) != null) {
            for (int i = 0; i < supplementalGroups.length; ++i) {
                try {
                    User group = new User(this.system_, supplementalGroups[i]);
                    if (!group.hasSpecialAuthority(authority)) continue;
                    return true;
                }
                catch (Exception e) {
                    Trace.log(2, "Unexpected Exception constructing User object:", (Throwable)e);
                    throw new InternalErrorException(10, (Throwable)e);
                }
            }
        }
        return false;
    }

    public boolean isGroupHasMember() {
        if (!this.loaded_ && !this.partiallyLoaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.groupHasMember_;
    }

    public boolean isLocalPasswordManagement() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.localPasswordManagement_;
    }

    public boolean isNoPassword() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.noPassword_;
    }

    public boolean isPasswordSetExpire() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.passwordSetExpire_;
    }

    public boolean isUserEntitlementRequired() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.userEntitlementRequired_;
    }

    public boolean isWithDigitalCertificates() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.withDigitalCertificates_;
    }

    private void loadUserInformation_SwallowExceptions() {
        try {
            this.loadUserInformation();
        }
        catch (Exception e) {
            Trace.log(2, "Exception swallowed during retrieval of user information:", (Throwable)e);
        }
    }

    public void loadUserInformation() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        int i;
        int i2;
        int i3;
        int bytesAvailable;
        if (Trace.traceOn_) {
            Trace.log(1, "Loading user information.");
        }
        if (this.system_ == null) {
            Trace.log(2, "Cannot connect to server before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.name_ == null) {
            Trace.log(2, "Cannot connect to server before setting name.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        Converter conv = new Converter(this.system_.getCcsid(), this.system_);
        byte[] userProfileName = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        conv.stringToByteArray(this.name_, userProfileName);
        int receiverVariableLength = 1024;
        ProgramParameter[] parameters = new ProgramParameter[]{new ProgramParameter(receiverVariableLength), new ProgramParameter(BinaryConverter.intToByteArray(receiverVariableLength)), new ProgramParameter(new byte[]{-28, -30, -39, -55, -16, -13, -16, -16}), new ProgramParameter(userProfileName), ERROR_CODE};
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QSYRUSRI.PGM", parameters);
        pc.suggestThreadsafe();
        if (!pc.run()) {
            throw new AS400Exception(pc.getMessageList());
        }
        byte[] data = parameters[0].getOutputData();
        int bytesReturned = BinaryConverter.byteArrayToInt(data, 0);
        if (bytesReturned < (bytesAvailable = BinaryConverter.byteArrayToInt(data, 4))) {
            if (Trace.traceOn_) {
                Trace.log(1, "Retrieve user information receiver variable too small, bytes returned: " + bytesReturned + ", bytes available: " + bytesAvailable);
            }
            receiverVariableLength = bytesAvailable;
            try {
                parameters[0].setOutputDataLength(receiverVariableLength);
                parameters[1].setInputData(BinaryConverter.intToByteArray(receiverVariableLength));
            }
            catch (PropertyVetoException e) {
                Trace.log(2, "Unexpected PropertyVetoException:", (Throwable)e);
                throw new InternalErrorException(10, (Throwable)e);
            }
            if (!pc.run()) {
                throw new AS400Exception(pc.getMessageList());
            }
            data = parameters[0].getOutputData();
        }
        this.userProfileName_ = conv.byteArrayToString(data, 8, 10).trim();
        String previousSignon = conv.byteArrayToString(data, 18, 13);
        if (previousSignon.trim().length() > 0) {
            Calendar cal = AS400Calendar.getGregorianInstance();
            cal.clear();
            cal.set(1, 1900 + Integer.parseInt(previousSignon.substring(0, 3)));
            cal.set(2, Integer.parseInt(previousSignon.substring(3, 5)) - 1);
            cal.set(5, Integer.parseInt(previousSignon.substring(5, 7)));
            cal.set(10, Integer.parseInt(previousSignon.substring(7, 9)));
            cal.set(12, Integer.parseInt(previousSignon.substring(9, 11)));
            cal.set(13, Integer.parseInt(previousSignon.substring(11, 13)));
            cal.setTimeZone(this.system_.getTimeZone());
            this.previousSignedOnDate_ = cal.getTime();
        } else {
            this.previousSignedOnDate_ = null;
        }
        this.signedOnAttemptsNotValid_ = BinaryConverter.byteArrayToInt(data, 32);
        this.status_ = conv.byteArrayToString(data, 36, 10).trim();
        if (this.passwordLastChangedDateBytes_ == null) {
            this.passwordLastChangedDateBytes_ = new byte[8];
        }
        System.arraycopy(data, 46, this.passwordLastChangedDateBytes_, 0, 8);
        this.passwordLastChangedDate_ = null;
        this.noPassword_ = data[54] == -24;
        this.passwordExpirationInterval_ = BinaryConverter.byteArrayToInt(data, 56);
        if (this.passwordExpireDateBytes_ == null) {
            this.passwordExpireDateBytes_ = new byte[8];
        }
        System.arraycopy(data, 60, this.passwordExpireDateBytes_, 0, 8);
        this.passwordExpireDate_ = null;
        this.daysUntilPasswordExpire_ = BinaryConverter.byteArrayToInt(data, 68);
        this.passwordSetExpire_ = data[72] == -24;
        this.userClassName_ = conv.byteArrayToString(data, 73, 10).trim();
        int numSpecAuth = 0;
        for (int i4 = 0; i4 < 8; ++i4) {
            if (data[83 + i4] != -24) continue;
            ++numSpecAuth;
        }
        this.specialAuthority_ = new String[numSpecAuth];
        int counter = 0;
        for (int i5 = 0; i5 < 8; ++i5) {
            if (data[83 + i5] != -24) continue;
            this.specialAuthority_[counter++] = SPECIAL_AUTHORITIES[i5];
        }
        this.groupProfileName_ = conv.byteArrayToString(data, 98, 10).trim();
        this.owner_ = conv.byteArrayToString(data, 108, 10).trim();
        this.groupAuthority_ = conv.byteArrayToString(data, 118, 10).trim();
        this.assistanceLevel_ = conv.byteArrayToString(data, 128, 10).trim();
        this.currentLibraryName_ = conv.byteArrayToString(data, 138, 10).trim();
        String menu = conv.byteArrayToString(data, 148, 10).trim();
        this.initialMenu_ = menu.equals("*SIGNOFF") ? menu : QSYSObjectPathName.toPath(conv.byteArrayToString(data, 158, 10).trim(), menu, "MNU");
        String prog = conv.byteArrayToString(data, 168, 10).trim();
        this.initialProgram_ = prog.equals(NONE) ? NONE : QSYSObjectPathName.toPath(conv.byteArrayToString(data, 178, 10).trim(), prog, "PGM");
        this.limitCapabilities_ = conv.byteArrayToString(data, 188, 10).trim();
        this.description_ = conv.byteArrayToString(data, 198, 50).trim();
        this.displaySignOnInformation_ = conv.byteArrayToString(data, 248, 10).trim();
        this.limitDeviceSessions_ = conv.byteArrayToString(data, 258, 10).trim();
        this.keyboardBuffering_ = conv.byteArrayToString(data, 268, 10).trim();
        this.maximumStorageAllowed_ = BinaryConverter.byteArrayToInt(data, 280);
        this.storageUsed_ = BinaryConverter.byteArrayToInt(data, 284);
        this.highestSchedulingPriority_ = data[288] & 0xF;
        this.jobDescription_ = QSYSObjectPathName.toPath(conv.byteArrayToString(data, 299, 10).trim(), conv.byteArrayToString(data, 289, 10).trim(), "JOBD");
        this.accountingCode_ = conv.byteArrayToString(data, 309, 15).trim();
        this.messageQueue_ = QSYSObjectPathName.toPath(conv.byteArrayToString(data, 334, 10).trim(), conv.byteArrayToString(data, 324, 10).trim(), "MSGQ");
        this.messageQueueDeliveryMethod_ = conv.byteArrayToString(data, 344, 10).trim();
        this.messageQueueSeverity_ = BinaryConverter.byteArrayToInt(data, 356);
        String outQueueName = conv.byteArrayToString(data, 360, 10).trim();
        this.outputQueue_ = outQueueName.equals("*WRKSTN") || outQueueName.equals("*DEV") ? outQueueName : QSYSObjectPathName.toPath(conv.byteArrayToString(data, 370, 10).trim(), outQueueName, "OUTQ");
        this.printDevice_ = conv.byteArrayToString(data, 380, 10).trim();
        this.specialEnvironment_ = conv.byteArrayToString(data, 390, 10).trim();
        String keyName = conv.byteArrayToString(data, 400, 10).trim();
        this.attentionKeyHandlingProgram_ = keyName.equals(NONE) || keyName.equals("*SYSVAL") ? keyName : QSYSObjectPathName.toPath(conv.byteArrayToString(data, 410, 10).trim(), keyName, "PGM");
        this.languageID_ = conv.byteArrayToString(data, 420, 10).trim();
        this.countryID_ = conv.byteArrayToString(data, 430, 10).trim();
        this.ccsid_ = BinaryConverter.byteArrayToInt(data, 440);
        int numUserOptions = 0;
        for (i3 = 0; i3 < 7; ++i3) {
            if (data[444 + i3] != -24) continue;
            ++numUserOptions;
        }
        this.userOptions_ = new String[numUserOptions];
        counter = 0;
        for (i3 = 0; i3 < 7; ++i3) {
            if (data[444 + i3] != -24) continue;
            this.userOptions_[counter++] = USER_OPTIONS[i3];
        }
        String sortName = conv.byteArrayToString(data, 480, 10).trim();
        this.sortSequenceTable_ = sortName.equals("*HEX") || sortName.equals("*LANGIDUNQ") || sortName.equals("*LANGIDSHR") || sortName.equals("*SYSVAL") || sortName.length() == 0 ? sortName : QSYSObjectPathName.toPath(conv.byteArrayToString(data, 490, 10).trim(), sortName, "FILE");
        this.objectAuditingValue_ = conv.byteArrayToString(data, 500, 10).trim();
        int numAudLevel = 0;
        for (i2 = 0; i2 < 33; ++i2) {
            if (data[510 + i2] != -24) continue;
            ++numAudLevel;
        }
        this.userActionAuditLevel_ = new String[numAudLevel];
        counter = 0;
        for (i2 = 0; i2 < 33; ++i2) {
            if (data[510 + i2] != -24) continue;
            this.userActionAuditLevel_[counter++] = AUDIT_LEVELS[i2];
        }
        this.groupAuthorityType_ = conv.byteArrayToString(data, 574, 10).trim();
        int supplementalGroupOffset = BinaryConverter.byteArrayToInt(data, 584);
        int supplementalGroupCount = BinaryConverter.byteArrayToInt(data, 588);
        this.supplementalGroups_ = new String[supplementalGroupCount];
        for (int i6 = 0; i6 < supplementalGroupCount; ++i6) {
            this.supplementalGroups_[i6] = conv.byteArrayToString(data, supplementalGroupOffset + i6 * 10, 10).trim();
        }
        this.userID_ = BinaryConverter.byteArrayToUnsignedInt(data, 592);
        this.groupID_ = BinaryConverter.byteArrayToUnsignedInt(data, 596);
        int homeDirOffset = BinaryConverter.byteArrayToInt(data, 600);
        int homeDirCcsid = BinaryConverter.byteArrayToInt(data, homeDirOffset);
        int homeDirLength = BinaryConverter.byteArrayToInt(data, homeDirOffset + 16);
        Converter homeDirConv = homeDirCcsid > 0 && homeDirCcsid < 65535 ? new Converter(homeDirCcsid, this.system_) : conv;
        this.homeDirectory_ = homeDirConv.byteArrayToString(data, homeDirOffset + 32, homeDirLength).trim();
        int numLocaleJobAttribs = 0;
        for (i = 0; i < 8; ++i) {
            if (data[608 + i] != -24) continue;
            ++numLocaleJobAttribs;
        }
        this.localeJobAttributes_ = new String[numLocaleJobAttribs];
        counter = 0;
        for (i = 0; i < 8; ++i) {
            if (data[608 + i] != -24) continue;
            this.localeJobAttributes_[counter++] = LOCALE_ATTRIBUTES[i];
        }
        int localePathOffset = BinaryConverter.byteArrayToInt(data, 624);
        int localePathLength = BinaryConverter.byteArrayToInt(data, 628);
        if (localePathLength == 10) {
            this.localePathName_ = conv.byteArrayToString(data, localePathOffset, localePathLength).trim();
        } else {
            int localePathCcsid = BinaryConverter.byteArrayToInt(data, localePathOffset);
            localePathLength = BinaryConverter.byteArrayToInt(data, localePathOffset + 16);
            Converter localePathConv = localePathCcsid > 0 && localePathCcsid < 65535 ? new Converter(localePathCcsid, this.system_) : conv;
            this.localePathName_ = localePathConv.byteArrayToString(data, localePathOffset + 32, localePathLength).trim();
        }
        this.groupHasMember_ = data[632] == -15;
        this.withDigitalCertificates_ = data[633] == -15;
        this.chridControl_ = conv.byteArrayToString(data, 634, 10).trim();
        int vrm = this.system_.getVRM();
        if (vrm >= 327936) {
            int iaspOffset = BinaryConverter.byteArrayToInt(data, 644);
            int iaspCount = BinaryConverter.byteArrayToInt(data, 648);
            int iaspCountReturned = BinaryConverter.byteArrayToInt(data, 652);
            int iaspLength = BinaryConverter.byteArrayToInt(data, 656);
            if (Trace.traceOn_ && iaspCount != iaspCountReturned) {
                Trace.log(4, "Not all IASP information was returned, count: " + iaspCount + ", returned:", iaspCountReturned);
            }
            this.iaspNames_ = new String[iaspCountReturned];
            this.iaspStorageAllowed_ = new int[iaspCountReturned];
            this.iaspStorageUsed_ = new int[iaspCountReturned];
            for (int i7 = 0; i7 < iaspCountReturned; ++i7) {
                int offset = iaspOffset + i7 * iaspLength;
                this.iaspNames_[i7] = conv.byteArrayToString(data, offset, 10).trim();
                this.iaspStorageAllowed_[i7] = BinaryConverter.byteArrayToInt(data, offset + 12);
                this.iaspStorageUsed_[i7] = BinaryConverter.byteArrayToInt(data, offset + 16);
            }
            if (vrm >= 328448) {
                boolean bl = this.localPasswordManagement_ = data[660] == -24;
                if (vrm >= 393472) {
                    this.pwdChangeBlock_ = conv.byteArrayToString(data, 661, 10).trim();
                    boolean bl2 = this.userEntitlementRequired_ = data[671] == -15;
                    if (vrm >= 459008) {
                        this.userExpirationInterval_ = BinaryConverter.byteArrayToInt(data, 672);
                        if (this.userExpirationDateBytes_ == null) {
                            this.userExpirationDateBytes_ = new byte[8];
                        }
                        System.arraycopy(data, 676, this.userExpirationDateBytes_, 0, 8);
                        this.userExpirationDate_ = null;
                        this.userExpirationAction_ = conv.byteArrayToString(data, 684, 10).trim();
                        if (vrm >= 459264) {
                            this.maximumStorageAllowedInLong_ = BinaryConverter.byteArrayToUnsignedInt(data, 696);
                            this.storageUsedInLong_ = BinaryConverter.byteArrayToUnsignedInt(data, 704);
                            if (vrm >= 459520) {
                                int STRAUTCOLOffset = BinaryConverter.byteArrayToInt(data, 712);
                                this.authCollectionActive_ = data[720] == -15;
                                boolean bl3 = this.authCollectionRepositoryExist_ = data[721] == -15;
                                if (STRAUTCOLOffset > 0) {
                                    int i8;
                                    int libNamesOffset = STRAUTCOLOffset + BinaryConverter.byteArrayToInt(data, STRAUTCOLOffset);
                                    int libNamesNumber = BinaryConverter.byteArrayToInt(data, STRAUTCOLOffset + 4);
                                    int objectNamesOffset = STRAUTCOLOffset + BinaryConverter.byteArrayToInt(data, STRAUTCOLOffset + 8);
                                    int objectNamesNumber = BinaryConverter.byteArrayToInt(data, STRAUTCOLOffset + 12);
                                    int objectTypesOffset = STRAUTCOLOffset + BinaryConverter.byteArrayToInt(data, STRAUTCOLOffset + 16);
                                    int objectTypesNumber = BinaryConverter.byteArrayToInt(data, STRAUTCOLOffset + 20);
                                    int DLOObjectTypesOffset = STRAUTCOLOffset + BinaryConverter.byteArrayToInt(data, STRAUTCOLOffset + 24);
                                    int DLOObjectTypesNumber = BinaryConverter.byteArrayToInt(data, STRAUTCOLOffset + 28);
                                    int fileSystemObjectTypesOffset = STRAUTCOLOffset + BinaryConverter.byteArrayToInt(data, STRAUTCOLOffset + 32);
                                    int fileSystemObjectTypesNumber = BinaryConverter.byteArrayToInt(data, STRAUTCOLOffset + 36);
                                    int omitLibNamesOffset = STRAUTCOLOffset + BinaryConverter.byteArrayToInt(data, STRAUTCOLOffset + 40);
                                    int omitLibNamesNumber = BinaryConverter.byteArrayToInt(data, STRAUTCOLOffset + 44);
                                    this.authCollectionDeleted_ = "*YES".equalsIgnoreCase(conv.byteArrayToString(data, STRAUTCOLOffset + 48, 4).trim());
                                    this.detailInSTRAUTCOL_ = conv.byteArrayToString(data, STRAUTCOLOffset + 52, 10).trim();
                                    this.libNamesInSTRAUTCOL_ = new String[libNamesNumber];
                                    for (i8 = 0; i8 < libNamesNumber; ++i8) {
                                        this.libNamesInSTRAUTCOL_[i8] = conv.byteArrayToString(data, libNamesOffset + i8 * 20, 20).trim();
                                    }
                                    this.objectNamesInSTRAUTCOL_ = new String[objectNamesNumber];
                                    for (i8 = 0; i8 < objectNamesNumber; ++i8) {
                                        this.objectNamesInSTRAUTCOL_[i8] = conv.byteArrayToString(data, objectNamesOffset + i8 * 10, 10).trim();
                                    }
                                    this.objectTypesInSTRAUTCOL_ = new String[objectTypesNumber];
                                    for (i8 = 0; i8 < objectTypesNumber; ++i8) {
                                        this.objectTypesInSTRAUTCOL_[i8] = conv.byteArrayToString(data, objectTypesOffset + i8 * 10, 10).trim();
                                    }
                                    this.DLOObjectTypesInSTRAUTCOL_ = new String[DLOObjectTypesNumber];
                                    for (i8 = 0; i8 < DLOObjectTypesNumber; ++i8) {
                                        this.DLOObjectTypesInSTRAUTCOL_[i8] = conv.byteArrayToString(data, DLOObjectTypesOffset + i8 * 10, 10).trim();
                                    }
                                    this.fileSystemObjectTypesInSTRAUTCOL_ = new String[fileSystemObjectTypesNumber];
                                    for (i8 = 0; i8 < fileSystemObjectTypesNumber; ++i8) {
                                        this.fileSystemObjectTypesInSTRAUTCOL_[i8] = conv.byteArrayToString(data, fileSystemObjectTypesOffset + i8 * 10, 10).trim();
                                    }
                                    this.omitLibNamesInSTRAUTCOL_ = new String[omitLibNamesNumber];
                                    for (i8 = 0; i8 < omitLibNamesNumber; ++i8) {
                                        this.omitLibNamesInSTRAUTCOL_[i8] = conv.byteArrayToString(data, omitLibNamesOffset + i8 * 20, 20).trim();
                                    }
                                }
                                if (vrm > 460032) {
                                    boolean totpB = data[812] == -24;
                                    boolean regfac = data[813] == -24;
                                    String[] authMethods = new String[totpB && regfac ? 2 : 1];
                                    if (totpB || regfac) {
                                        int idx = 0;
                                        if (totpB) {
                                            authMethods[idx++] = AUTHENTICATION_METHOD_TOTP;
                                        }
                                        if (regfac) {
                                            authMethods[idx++] = AUTHENTICATION_METHOD_REGFAC;
                                        }
                                    } else {
                                        authMethods[0] = NONE;
                                    }
                                    this.authenticationMethods_ = authMethods;
                                    this.totpOptionalInterval_ = BinaryConverter.byteArrayToInt(data, 824);
                                    this.totpOptionalIntervalRemaining_ = BinaryConverter.byteArrayToInt(data, 828);
                                    this.totpKeyExistsIndicator_ = data[832] == -15;
                                    String totpKeyLastChangedDate = conv.byteArrayToString(data, 833, 13);
                                    if (totpKeyLastChangedDate.trim().length() > 0) {
                                        Calendar cal = AS400Calendar.getGregorianInstance();
                                        cal.clear();
                                        cal.set(1, 1900 + Integer.parseInt(totpKeyLastChangedDate.substring(0, 3)));
                                        cal.set(2, Integer.parseInt(totpKeyLastChangedDate.substring(3, 5)) - 1);
                                        cal.set(5, Integer.parseInt(totpKeyLastChangedDate.substring(5, 7)));
                                        cal.set(10, Integer.parseInt(totpKeyLastChangedDate.substring(7, 9)));
                                        cal.set(12, Integer.parseInt(totpKeyLastChangedDate.substring(9, 11)));
                                        cal.set(13, Integer.parseInt(totpKeyLastChangedDate.substring(11, 13)));
                                        cal.setTimeZone(this.system_.getTimeZone());
                                        this.totpKeyLastChangedDate_ = cal.getTime();
                                    } else {
                                        this.totpKeyLastChangedDate_ = null;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        this.loaded_ = true;
        this.connected_ = true;
    }

    public void refresh() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadUserInformation();
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing property change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing vetoable change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.removeVetoableChangeListener(listener);
        }
    }

    private void runCommand(String parameters) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Changing user profile.");
        }
        if (this.system_ == null) {
            Trace.log(2, "Cannot connect to server before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.name_ == null) {
            Trace.log(2, "Cannot connect to server before setting name.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        CommandCall cmd = this.getCommandCallObject(true);
        try {
            cmd.setCommand("QSYS/CHGUSRPRF USRPRF(" + this.name_ + ") " + parameters);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        if (!cmd.run()) {
            throw new AS400Exception(cmd.getMessageList());
        }
        this.loaded_ = false;
        this.connected_ = true;
    }

    private final CommandCall getCommandCallObject(boolean isChgUsrPrf) {
        if (isChgUsrPrf) {
            if (this.chgUsrPrf_ == null) {
                this.chgUsrPrf_ = new CommandCall(this.system_);
                this.chgUsrPrf_.suggestThreadsafe(false);
            }
            return this.chgUsrPrf_;
        }
        if (this.chgUsrAud_ == null) {
            this.chgUsrAud_ = new CommandCall(this.system_);
            this.chgUsrAud_.suggestThreadsafe(false);
        }
        return this.chgUsrAud_;
    }

    private void runCommandAud(String parameters) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Changing user auditing.");
        }
        if (this.system_ == null) {
            Trace.log(2, "Cannot connect to server before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.name_ == null) {
            Trace.log(2, "Cannot connect to server before setting name.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        CommandCall cmd = this.getCommandCallObject(false);
        try {
            cmd.setCommand("QSYS/CHGUSRAUD USRPRF(" + this.name_ + ") " + parameters);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        if (!cmd.run()) {
            throw new AS400Exception(cmd.getMessageList());
        }
        this.loaded_ = false;
        this.connected_ = true;
    }

    public void setAccountingCode(String accountingCode) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (accountingCode == null) {
            Trace.log(2, "Parameter 'accountingCode' is null.");
            throw new NullPointerException("accountingCode");
        }
        if (accountingCode.equals("*BLANK")) {
            this.runCommand("ACGCDE(*BLANK)");
        } else {
            this.runCommand("ACGCDE('" + accountingCode + "')");
        }
    }

    private static String setArrayToString(String[] array) {
        int arrayLength = array.length;
        if (arrayLength == 0) {
            return NONE;
        }
        if (arrayLength == 1) {
            return array[0];
        }
        StringBuffer string = new StringBuffer(array[0]);
        for (int i = 1; i < arrayLength; ++i) {
            string.append(" ");
            string.append(array[i]);
        }
        return string.toString();
    }

    public void setAssistanceLevel(String assistanceLevel) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (assistanceLevel == null) {
            Trace.log(2, "Parameter 'assistanceLevel' is null.");
            throw new NullPointerException("assistanceLevel");
        }
        this.runCommand("ASTLVL(" + assistanceLevel + ")");
    }

    public void setAttentionKeyHandlingProgram(String attentionKeyHandlingProgram) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (attentionKeyHandlingProgram == null) {
            Trace.log(2, "Parameter 'attentionKeyHandlingProgram' is null.");
            throw new NullPointerException("attentionKeyHandlingProgram");
        }
        if (attentionKeyHandlingProgram.length() == 0 || attentionKeyHandlingProgram.startsWith("*")) {
            this.runCommand("ATNPGM(" + attentionKeyHandlingProgram + ")");
        } else {
            QSYSObjectPathName ifs = new QSYSObjectPathName(attentionKeyHandlingProgram, "PGM");
            this.runCommand("ATNPGM(" + ifs.getLibraryName() + "/" + ifs.getObjectName() + ")");
        }
    }

    public void setAuthenticationMethods(String[] authenticationMethods) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, RequestNotSupportedException {
        if (authenticationMethods == null) {
            Trace.log(2, "Parameter 'authenticationMethods' is null.");
            throw new NullPointerException("authenticationMethods");
        }
        if (this.system_.getVRM() <= 460032) {
            String currentRelease = this.system_.getVersion() + "." + this.system_.getRelease();
            throw new RequestNotSupportedException(currentRelease, 1);
        }
        String authMethods = NONE;
        if (authenticationMethods.length > 0) {
            authMethods = "";
            for (int i = 0; i < authenticationMethods.length; ++i) {
                authMethods = authMethods + authenticationMethods[i] + " ";
            }
        }
        this.runCommand("AUTHMTH(" + authMethods + ")");
        this.authenticationMethods_ = authenticationMethods;
    }

    public void setCCSID(int ccsid) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        this.runCommand("CCSID(" + (ccsid == -2 ? "*SYSVAL" : Integer.toString(ccsid)) + ")");
    }

    public void setCCSID(String ccsid) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (ccsid == null) {
            Trace.log(2, "Parameter 'ccsid' is null.");
            throw new NullPointerException("ccsid");
        }
        this.runCommand("CCSID(" + ccsid + ")");
    }

    public void setCHRIDControl(String chridControl) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (chridControl == null) {
            Trace.log(2, "Parameter 'chridControl' is null.");
            throw new NullPointerException("chridControl");
        }
        this.runCommand("CHRIDCTL(" + chridControl + ")");
    }

    public void setCountryID(String countryID) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (countryID == null) {
            Trace.log(2, "Parameter 'countryID' is null.");
            throw new NullPointerException("countryID");
        }
        this.runCommand("CNTRYID(" + countryID + ")");
    }

    public void setCurrentLibraryName(String currentLibraryName) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (currentLibraryName == null) {
            Trace.log(2, "Parameter 'currentLibraryName' is null.");
            throw new NullPointerException("currentLibraryName");
        }
        this.runCommand("CURLIB(" + currentLibraryName + ")");
    }

    public void setDescription(String description) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (description == null) {
            Trace.log(2, "Parameter 'description' is null.");
            throw new NullPointerException("description");
        }
        if (description.equals("*BLANK")) {
            this.runCommand("TEXT(*BLANK)");
        } else {
            this.runCommand("TEXT('" + description + "')");
        }
    }

    public void setDisplaySignOnInformation(String displaySignOnInformation) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (displaySignOnInformation == null) {
            Trace.log(2, "Parameter 'displaySignOnInformation' is null.");
            throw new NullPointerException("displaySignOnInformation");
        }
        this.runCommand("DSPSGNINF(" + displaySignOnInformation + ")");
    }

    public void setGroupAuthority(String groupAuthority) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (groupAuthority == null) {
            Trace.log(2, "Parameter 'groupAuthority' is null.");
            throw new NullPointerException("groupAuthority");
        }
        this.runCommand("GRPAUT(" + groupAuthority + ")");
    }

    public void setGroupAuthorityType(String groupAuthorityType) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (groupAuthorityType == null) {
            Trace.log(2, "Parameter 'groupAuthorityType' is null.");
            throw new NullPointerException("groupAuthorityType");
        }
        this.runCommand("GRPAUTTYP(" + groupAuthorityType + ")");
    }

    public void setGroupID(long groupID) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (groupID == 0L) {
            this.runCommand("GID(*NONE)");
        } else {
            this.runCommand("GID(" + Long.toString(groupID) + ")");
        }
    }

    public void setGroupID(String groupID) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (groupID == null) {
            Trace.log(2, "Parameter 'groupID' is null.");
            throw new NullPointerException("groupID");
        }
        this.runCommand("GID(" + groupID + ")");
    }

    public void setGroupProfileName(String groupProfileName) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (groupProfileName == null) {
            Trace.log(2, "Parameter 'groupProfileName' is null.");
            throw new NullPointerException("groupProfileName");
        }
        this.runCommand("GRPPRF(" + groupProfileName + ")");
    }

    public void setHighestSchedulingPriority(int highestSchedulingPriority) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        this.runCommand("PTYLMT(" + Integer.toString(highestSchedulingPriority) + ")");
    }

    public void setHomeDirectory(String homeDirectory) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (homeDirectory == null) {
            Trace.log(2, "Parameter 'homeDirectory' is null.");
            throw new NullPointerException("homeDirectory");
        }
        if (homeDirectory.length() == 0 || homeDirectory.startsWith("*")) {
            this.runCommand("HOMEDIR(" + homeDirectory + ")");
        } else {
            this.runCommand("HOMEDIR('" + homeDirectory + "')");
        }
    }

    public void setInitialMenu(String initialMenu) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (initialMenu == null) {
            Trace.log(2, "Parameter 'initialMenu' is null.");
            throw new NullPointerException("initialMenu");
        }
        if (initialMenu.length() == 0 || initialMenu.startsWith("*")) {
            this.runCommand("INLMNU(" + initialMenu + ")");
        } else {
            QSYSObjectPathName ifs = new QSYSObjectPathName(initialMenu, "MNU");
            this.runCommand("INLMNU(" + ifs.getLibraryName() + "/" + ifs.getObjectName() + ")");
        }
    }

    public void setInitialProgram(String initialProgram) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (initialProgram == null) {
            Trace.log(2, "Parameter 'initialProgram' is null.");
            throw new NullPointerException("initialProgram");
        }
        if (initialProgram.length() == 0 || initialProgram.startsWith("*")) {
            this.runCommand("INLPGM(" + initialProgram + ")");
        } else {
            QSYSObjectPathName ifs = new QSYSObjectPathName(initialProgram, "PGM");
            this.runCommand("INLPGM(" + ifs.getLibraryName() + "/" + ifs.getObjectName() + ")");
        }
    }

    public void setJobDescription(String jobDescription) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (jobDescription == null) {
            Trace.log(2, "Parameter 'jobDescription' is null.");
            throw new NullPointerException("jobDescription");
        }
        if (jobDescription.length() == 0 || jobDescription.startsWith("*")) {
            this.runCommand("JOBD(" + jobDescription + ")");
        } else {
            QSYSObjectPathName ifs = new QSYSObjectPathName(jobDescription, "JOBD");
            this.runCommand("JOBD(" + ifs.getLibraryName() + "/" + ifs.getObjectName() + ")");
        }
    }

    public void setKeyboardBuffering(String keyboardBuffering) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (keyboardBuffering == null) {
            Trace.log(2, "Parameter 'keyboardBuffering' is null.");
            throw new NullPointerException("keyboardBuffering");
        }
        this.runCommand("KBDBUF(" + keyboardBuffering + ")");
    }

    public void setLanguageID(String languageID) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (languageID == null) {
            Trace.log(2, "Parameter 'languageID' is null.");
            throw new NullPointerException("languageID");
        }
        this.runCommand("LANGID(" + languageID + ")");
    }

    public void setLimitCapabilities(String limitCapabilities) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (limitCapabilities == null) {
            Trace.log(2, "Parameter 'limitCapabilities' is null.");
            throw new NullPointerException("limitCapabilities");
        }
        this.runCommand("LMTCPB(" + limitCapabilities + ")");
    }

    public void setLimitDeviceSessions(String limitDeviceSessions) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (limitDeviceSessions == null) {
            Trace.log(2, "Parameter 'limitDeviceSessions' is null.");
            throw new NullPointerException("limitDeviceSessions");
        }
        this.runCommand("LMTDEVSSN(" + limitDeviceSessions + ")");
    }

    public void setLocaleJobAttributes(String[] localeJobAttributes) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (localeJobAttributes == null) {
            Trace.log(2, "Parameter 'localeJobAttributes' is null.");
            throw new NullPointerException("localeJobAttributes");
        }
        this.runCommand("SETJOBATR(" + User.setArrayToString(localeJobAttributes) + ")");
    }

    public void setLocalePathName(String localePathName) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (localePathName == null) {
            Trace.log(2, "Parameter 'localePathName' is null.");
            throw new NullPointerException("localePathName");
        }
        if (localePathName.length() == 0 || localePathName.startsWith("*")) {
            this.runCommand("LOCALE(" + localePathName + ")");
        } else {
            this.runCommand("LOCALE('" + localePathName + "')");
        }
    }

    public void setLocalPasswordManagement(boolean localPasswordManagement) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        this.runCommand("LCLPWDMGT(" + (localPasswordManagement ? "*YES" : "*NO") + ")");
    }

    public void setMaximumStorageAllowed(int maximumStorageAllowed) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        this.runCommand("MAXSTG(" + (maximumStorageAllowed == -1 ? "*NOMAX" : Integer.toString(maximumStorageAllowed)) + ")");
    }

    public void setMaximumStorageAllowed(String maximumStorageAllowed) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (maximumStorageAllowed == null) {
            Trace.log(2, "Parameter 'maximumStorageAllowed' is null.");
            throw new NullPointerException("maximumStorageAllowed");
        }
        this.runCommand("MAXSTG(" + maximumStorageAllowed + ")");
    }

    public void setMessageQueue(String messageQueue) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (messageQueue == null) {
            Trace.log(2, "Parameter 'messageQueue' is null.");
            throw new NullPointerException("messageQueue");
        }
        if (messageQueue.length() == 0 || messageQueue.startsWith("*")) {
            this.runCommand("MSGQ(" + messageQueue + ")");
        } else {
            QSYSObjectPathName ifs = new QSYSObjectPathName(messageQueue, "MSGQ");
            this.runCommand("MSGQ(" + ifs.getLibraryName() + "/" + ifs.getObjectName() + ")");
        }
    }

    public void setMessageQueueDeliveryMethod(String messageQueueDeliveryMethod) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (messageQueueDeliveryMethod == null) {
            Trace.log(2, "Parameter 'messageQueueDeliveryMethod' is null.");
            throw new NullPointerException("messageQueueDeliveryMethod");
        }
        this.runCommand("DLVRY(" + messageQueueDeliveryMethod + ")");
    }

    public void setMessageQueueSeverity(int messageQueueSeverity) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        this.runCommand("SEV(" + Integer.toString(messageQueueSeverity) + ")");
    }

    public void setName(String name) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting name: " + name);
        }
        if (name == null) {
            Trace.log(2, "Parameter 'name' is null.");
            throw new NullPointerException("name");
        }
        if ((name = name.trim()).length() > 10) {
            Trace.log(2, "Length of parameter 'name' is not valid: '" + name + "'");
            throw new ExtendedIllegalArgumentException("name (" + name + ")", 1);
        }
        if (name.equalsIgnoreCase(NONE)) {
            Trace.log(2, "Value of parameter 'name' is not valid: '" + name + "'");
            throw new ExtendedIllegalArgumentException("name (" + name + ")", 2);
        }
        if (this.connected_) {
            Trace.log(2, "Cannot set property 'name' after connect.");
            throw new ExtendedIllegalStateException("name", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.name_ = name.toUpperCase();
        } else {
            String oldValue = this.name_;
            String newValue = name.toUpperCase();
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("name", oldValue, newValue);
            }
            this.name_ = newValue;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("name", oldValue, newValue);
            }
        }
    }

    public void setObjectAuditingValue(String objectAuditingValue) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (objectAuditingValue == null) {
            Trace.log(2, "Parameter 'objectAuditingValue' is null.");
            throw new NullPointerException("objectAuditingValue");
        }
        this.runCommandAud("OBJAUD(" + objectAuditingValue + ")");
    }

    public void setOutputQueue(String outputQueue) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (outputQueue == null) {
            Trace.log(2, "Parameter 'outputQueue' is null.");
            throw new NullPointerException("outputQueue");
        }
        if (outputQueue.length() == 0 || outputQueue.startsWith("*")) {
            this.runCommand("OUTQ(" + outputQueue + ")");
        } else {
            QSYSObjectPathName ifs = new QSYSObjectPathName(outputQueue, "OUTQ");
            this.runCommand("OUTQ(" + ifs.getLibraryName() + "/" + ifs.getObjectName() + ")");
        }
    }

    public void setOwner(String owner) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (owner == null) {
            Trace.log(2, "Parameter 'owner' is null.");
            throw new NullPointerException("owner");
        }
        this.runCommand("OWNER(" + owner + ")");
    }

    public void setPasswordChangeBlock(String pwdChangeBlock) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (pwdChangeBlock == null) {
            Trace.log(2, "Parameter 'pwdChangeBlock' is null.");
            throw new NullPointerException("pwdChangeBlock");
        }
        this.runCommand("PWDCHGBLK(" + pwdChangeBlock + ")");
    }

    public void setPasswordExpirationInterval(int passwordExpirationInterval) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        this.runCommand("PWDEXPITV(" + (passwordExpirationInterval == -1 ? "*NOMAX" : (passwordExpirationInterval == 0 ? "*SYSVAL" : Integer.toString(passwordExpirationInterval))) + ")");
    }

    public void setPasswordExpirationInterval(String passwordExpirationInterval) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (passwordExpirationInterval == null) {
            Trace.log(2, "Parameter 'passwordExpirationInterval' is null.");
            throw new NullPointerException("passwordExpirationInterval");
        }
        this.runCommand("PWDEXPITV(" + passwordExpirationInterval + ")");
    }

    public void setPasswordSetExpire(boolean passwordSetExpire) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        this.runCommand("PWDEXP(" + (passwordSetExpire ? "*YES" : "*NO") + ")");
    }

    public void setPrintDevice(String printDevice) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (printDevice == null) {
            Trace.log(2, "Parameter 'printDevice' is null.");
            throw new NullPointerException("printDevice");
        }
        this.runCommand("PRTDEV(" + printDevice + ")");
    }

    public void setSortSequenceTable(String sortSequenceTable) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (sortSequenceTable == null) {
            Trace.log(2, "Parameter 'sortSequenceTable' is null.");
            throw new NullPointerException("sortSequenceTable");
        }
        if (sortSequenceTable.length() == 0 || sortSequenceTable.startsWith("*")) {
            this.runCommand("SRTSEQ(" + sortSequenceTable + ")");
        } else {
            QSYSObjectPathName ifs = new QSYSObjectPathName(sortSequenceTable, "FILE");
            this.runCommand("SRTSEQ(" + ifs.getLibraryName() + "/" + ifs.getObjectName() + ")");
        }
    }

    public void setSpecialAuthority(String[] specialAuthority) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (specialAuthority == null) {
            Trace.log(2, "Parameter 'specialAuthority' is null.");
            throw new NullPointerException("specialAuthority");
        }
        this.runCommand("SPCAUT(" + User.setArrayToString(specialAuthority) + ")");
    }

    public void setSpecialEnvironment(String specialEnvironment) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (specialEnvironment == null) {
            Trace.log(2, "Parameter 'specialEnvironment' is null.");
            throw new NullPointerException("specialEnvironment");
        }
        this.runCommand("SPCENV(" + specialEnvironment + ")");
    }

    public void setStatus(String status) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (status == null) {
            Trace.log(2, "Parameter 'status' is null.");
            throw new NullPointerException("status");
        }
        this.runCommand("STATUS(" + status + ")");
    }

    public void setSupplementalGroups(String[] supplementalGroups) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (supplementalGroups == null) {
            Trace.log(2, "Parameter 'supplementalGroups' is null.");
            throw new NullPointerException("supplementalGroups");
        }
        this.runCommand("SUPGRPPRF(" + User.setArrayToString(supplementalGroups) + ")");
    }

    public void setSystem(AS400 system) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system: " + system);
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (this.connected_) {
            Trace.log(2, "Cannot set property 'system' after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.system_ = system;
        } else {
            AS400 oldValue = this.system_;
            AS400 newValue = system;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("system", oldValue, newValue);
            }
            this.system_ = system;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("system", oldValue, newValue);
            }
        }
    }

    public void setUserActionAuditLevel(String[] userActionAuditLevel) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (userActionAuditLevel == null) {
            Trace.log(2, "Parameter 'userActionAuditLevel' is null.");
            throw new NullPointerException("userActionAuditLevel");
        }
        this.runCommandAud("AUDLVL(" + User.setArrayToString(userActionAuditLevel) + ")");
    }

    public void setUserClassName(String userClassName) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (userClassName == null) {
            Trace.log(2, "Parameter 'userClassName' is null.");
            throw new NullPointerException("userClassName");
        }
        this.runCommand("USRCLS(" + userClassName + ")");
    }

    public void setUserExpirationDate(Date expirationDate) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, RequestNotSupportedException, ObjectDoesNotExistException {
        String expDate;
        if (this.system_.getVRM() < 459008) {
            String currentRelease = this.system_.getVersion() + "." + this.system_.getRelease();
            throw new RequestNotSupportedException(currentRelease, 1);
        }
        if (expirationDate == null) {
            expDate = NONE;
        } else {
            String jobDateFormat = this.getJobDateFormat();
            byte[] dateBytes = this.getDateTimeConverter().convert(expirationDate, jobDateFormat);
            expDate = DateTimeConverter.formatDateForCommandParameter(dateBytes, jobDateFormat);
        }
        this.runCommand("USREXPDATE(" + expDate + ")");
    }

    public void setTOTPOptionalInterval(int totpOptionalInterval) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, RequestNotSupportedException, ObjectDoesNotExistException {
        if (this.system_.getVRM() <= 460032) {
            String currentRelease = this.system_.getVersion() + "." + this.system_.getRelease();
            throw new RequestNotSupportedException(currentRelease, 1);
        }
        if (totpOptionalInterval < 0 || totpOptionalInterval > 720) {
            throw new ExtendedIllegalArgumentException("totpOptionalInterval (" + totpOptionalInterval + ")", 4);
        }
        String totpOptionalIntervalString = null;
        if (totpOptionalInterval == 0) {
            totpOptionalIntervalString = NONE;
        }
        this.runCommand("TOTPOPTITV(" + (totpOptionalIntervalString != null ? totpOptionalIntervalString : Integer.valueOf(totpOptionalInterval)) + ")");
        this.totpOptionalInterval_ = totpOptionalInterval;
    }

    private final DateTimeConverter getDateTimeConverter() {
        if (this.dateConverter_ == null) {
            this.dateConverter_ = new DateTimeConverter(this.system_);
        }
        return this.dateConverter_;
    }

    private final String getJobDateFormat() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.jobDateFormat_ == null) {
            CommandCall cmd = this.getCommandCallObject(true);
            Job job = cmd.getServerJob();
            this.jobDateFormat_ = job.getDateFormat();
        }
        return this.jobDateFormat_;
    }

    public void setUserExpirationInterval(int expirationInterval) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, RequestNotSupportedException {
        if (this.system_.getVRM() < 459008) {
            String currentRelease = this.system_.getVersion() + "." + this.system_.getRelease();
            throw new RequestNotSupportedException(currentRelease, 1);
        }
        if (expirationInterval < 1 || expirationInterval > 366) {
            throw new ExtendedIllegalArgumentException("expirationInterval (" + expirationInterval + ")", 4);
        }
        this.runCommand("USREXPITV(" + expirationInterval + ") USREXPDATE(*USREXPITV)");
    }

    public void setUserID(long userID) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        this.runCommand("UID(" + Long.toString(userID) + ")");
    }

    public void setUserOptions(String[] userOptions) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (userOptions == null) {
            Trace.log(2, "Parameter 'userOptions' is null.");
            throw new NullPointerException("userOptions");
        }
        this.runCommand("USROPT(" + User.setArrayToString(userOptions) + ")");
    }

    public String toString() {
        return super.toString() + "[" + this.name_ + "]";
    }
}

