/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.PSConnection;
import com.ibm.as400.access.PxIntParm;
import com.ibm.as400.access.PxPxObjectParm;
import com.ibm.as400.access.PxRepSV;
import com.ibm.as400.access.PxReqSV;
import com.ibm.as400.access.PxStringParm;
import com.ibm.as400.access.PxTable;
import com.ibm.as400.access.Trace;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

class PxListenerReqSV
extends PxReqSV {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private PSConnection connection_;
    private PxTable proxyTable_;

    public PxListenerReqSV(PSConnection connection, PxTable proxyTable) {
        super((short)12050);
        this.connection_ = connection;
        this.proxyTable_ = proxyTable;
    }

    private static final String operationToString(int operation) {
        switch (operation) {
            case 1: {
                return "add";
            }
            case 2: {
                return "remove";
            }
        }
        if (Trace.isTraceErrorOn()) {
            Trace.log(2, "Invalid listener operation: " + operation);
        }
        throw new InternalErrorException(4);
    }

    @Override
    public PxRepSV process() {
        try {
            Object proxy = ((PxPxObjectParm)this.getParm(0)).getObjectValue();
            int operation = ((PxIntParm)this.getParm(1)).getIntValue();
            String eventName = ((PxStringParm)this.getParm(2)).getStringValue();
            String listenerName = eventName + "Listener";
            Class<?> listenerInterface = Class.forName("com.ibm.as400.access." + listenerName);
            Class<?> listenerClass = Class.forName("com.ibm.as400.access.PS" + listenerName);
            Constructor<?> constructor = listenerClass.getConstructor(PSConnection.class, PxTable.class, Long.TYPE);
            long proxyId = this.proxyTable_.get(proxy);
            Object listener = constructor.newInstance(this.connection_, this.proxyTable_, proxyId);
            Class<?> proxyClass = proxy.getClass();
            Method xxxListener = proxyClass.getMethod(PxListenerReqSV.operationToString(operation) + listenerName, listenerInterface);
            xxxListener.invoke(proxy, listener);
            return null;
        }
        catch (Exception e) {
            if (Trace.isTraceErrorOn()) {
                Trace.log(2, e.toString(), (Throwable)e);
            }
            throw new InternalErrorException(4);
        }
    }
}

