/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.SQLConversionSettings;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;

class DBColumnDescriptorsDataFormat {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private byte[] baseColumnName_;
    private byte[] baseTableName_;
    private byte[] baseTableSchemaName_;
    private String columnLabel_;
    private int jobCCSID_;
    BidiConversionProperties bidiConversionProperties_ = null;

    DBColumnDescriptorsDataFormat(SQLConversionSettings settings) {
        int bidiStringType = 5;
        boolean bidiImplicitReordering = true;
        boolean bidiNumericOrdering = false;
        if (settings != null) {
            bidiStringType = settings.getBidiStringType();
            if (bidiStringType == -1) {
                bidiStringType = 5;
            }
            bidiImplicitReordering = settings.getBidiImplicitReordering();
            bidiNumericOrdering = settings.getBidiNumericOrdering();
        }
        this.bidiConversionProperties_ = new BidiConversionProperties(bidiStringType);
        this.bidiConversionProperties_.setBidiImplicitReordering(bidiImplicitReordering);
        this.bidiConversionProperties_.setBidiNumericOrderingRoundTrip(bidiNumericOrdering);
    }

    DBColumnDescriptorsDataFormat(int jobCCSID, SQLConversionSettings settings) {
        this(settings);
        this.jobCCSID_ = jobCCSID;
    }

    void overlay(byte[] rawBytes, int offset, int variableColumnInfoLength) throws SQLException {
        while (variableColumnInfoLength > 0) {
            int length = BinaryConverter.byteArrayToInt(rawBytes, offset);
            short codePoint = BinaryConverter.byteArrayToShort(rawBytes, offset + 4);
            switch (codePoint) {
                case 14592: {
                    this.baseColumnName_ = new byte[length - 6];
                    System.arraycopy(rawBytes, offset + 6, this.baseColumnName_, 0, length - 6);
                    break;
                }
                case 14593: {
                    this.baseTableName_ = new byte[length - 6];
                    System.arraycopy(rawBytes, offset + 6, this.baseTableName_, 0, length - 6);
                    break;
                }
                case 14594: {
                    int ccsid = BinaryConverter.byteArrayToShort(rawBytes, offset + 6);
                    if (ccsid == -1) {
                        ccsid = this.jobCCSID_;
                    }
                    try {
                        this.columnLabel_ = ConvTable.getTable(ccsid, null).byteArrayToString(rawBytes, offset + 8, length - 8, this.bidiConversionProperties_);
                    }
                    catch (UnsupportedEncodingException e) {
                        JDError.throwSQLException("HY000", e);
                    }
                    break;
                }
                case 14596: {
                    this.baseTableSchemaName_ = new byte[length - 6];
                    System.arraycopy(rawBytes, offset + 6, this.baseTableSchemaName_, 0, length - 6);
                }
            }
            variableColumnInfoLength -= length;
            offset += length;
        }
    }

    String getBaseColumnName(ConvTable convTable) {
        if (this.baseColumnName_ != null) {
            return convTable.byteArrayToString(this.baseColumnName_, 0, this.baseColumnName_.length, this.bidiConversionProperties_);
        }
        return null;
    }

    String getBaseTableName(ConvTable convTable) {
        if (this.baseTableName_ != null) {
            return convTable.byteArrayToString(this.baseTableName_, 0, this.baseTableName_.length, this.bidiConversionProperties_);
        }
        return null;
    }

    String getBaseTableSchemaName(ConvTable convTable) {
        if (this.baseTableSchemaName_ != null) {
            return convTable.byteArrayToString(this.baseTableSchemaName_, 0, this.baseTableSchemaName_.length, this.bidiConversionProperties_);
        }
        return null;
    }

    String getColumnLabel(ConvTable convTable) {
        if (this.columnLabel_ != null) {
            return this.columnLabel_;
        }
        return null;
    }
}

