/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;

public class AS400UnsignedBin2
implements AS400DataType {
    static final long serialVersionUID = 4L;
    private static final int SIZE = 2;
    private static final int MIN_VALUE = 0;
    private static final int MAX_VALUE = 65535;
    private static final int defaultValue = 0;

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Trace.log(2, "Unexpected cloning error", (Throwable)e);
            throw new InternalErrorException(6, (Throwable)e);
        }
    }

    @Override
    public int getByteLength() {
        return 2;
    }

    @Override
    public Object getDefaultValue() {
        return 0;
    }

    @Override
    public int getInstanceType() {
        return 10;
    }

    @Override
    public Class getJavaType() {
        return Integer.class;
    }

    @Override
    public byte[] toBytes(Object javaValue) {
        int intValue = (Integer)javaValue;
        if (intValue < 0 || intValue > 65535) {
            throw new ExtendedIllegalArgumentException("javaValue (" + javaValue.toString() + ")", 4);
        }
        byte[] as400Value = new byte[2];
        BinaryConverter.unsignedShortToByteArray(intValue, as400Value, 0);
        return as400Value;
    }

    public byte[] toBytes(int intValue) {
        if (intValue < 0 || intValue > 65535) {
            throw new ExtendedIllegalArgumentException("intValue (" + String.valueOf(intValue) + ")", 4);
        }
        byte[] as400Value = new byte[2];
        BinaryConverter.unsignedShortToByteArray(intValue, as400Value, 0);
        return as400Value;
    }

    @Override
    public int toBytes(Object javaValue, byte[] as400Value) {
        int intValue = (Integer)javaValue;
        if (intValue < 0 || intValue > 65535) {
            throw new ExtendedIllegalArgumentException("javaValue (" + javaValue.toString() + ")", 4);
        }
        BinaryConverter.unsignedShortToByteArray(intValue, as400Value, 0);
        return 2;
    }

    public int toBytes(int intValue, byte[] as400Value) {
        if (intValue < 0 || intValue > 65535) {
            throw new ExtendedIllegalArgumentException("intValue (" + String.valueOf(intValue) + ")", 4);
        }
        BinaryConverter.unsignedShortToByteArray(intValue, as400Value, 0);
        return 2;
    }

    @Override
    public int toBytes(Object javaValue, byte[] as400Value, int offset) {
        int intValue = (Integer)javaValue;
        if (intValue < 0 || intValue > 65535) {
            throw new ExtendedIllegalArgumentException("javaValue (" + javaValue.toString() + ")", 4);
        }
        BinaryConverter.unsignedShortToByteArray(intValue, as400Value, offset);
        return 2;
    }

    public int toBytes(int intValue, byte[] as400Value, int offset) {
        if (intValue < 0 || intValue > 65535) {
            throw new ExtendedIllegalArgumentException("intValue (" + String.valueOf(intValue) + ")", 4);
        }
        BinaryConverter.unsignedShortToByteArray(intValue, as400Value, offset);
        return 2;
    }

    public int toInt(byte[] as400Value) {
        return BinaryConverter.byteArrayToUnsignedShort(as400Value, 0);
    }

    public int toInt(byte[] as400Value, int offset) {
        return BinaryConverter.byteArrayToUnsignedShort(as400Value, offset);
    }

    @Override
    public Object toObject(byte[] as400Value) {
        return BinaryConverter.byteArrayToUnsignedShort(as400Value, 0);
    }

    @Override
    public Object toObject(byte[] as400Value, int offset) {
        return BinaryConverter.byteArrayToUnsignedShort(as400Value, offset);
    }
}

