/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import javax.transaction.xa.Xid;

public class AS400JDBCXid
implements Xid {
    static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private int formatId_ = -1;
    private byte[] globalTransactionId_ = null;
    private byte[] branchQualifier_ = null;

    AS400JDBCXid(byte[] xidBytes, int offset) {
        this.formatId_ = BinaryConverter.byteArrayToInt(xidBytes, offset);
        int globalTransactionIdLength = BinaryConverter.byteArrayToInt(xidBytes, offset + 4);
        int branchQualifierIdLength = BinaryConverter.byteArrayToInt(xidBytes, offset + 8);
        this.globalTransactionId_ = new byte[globalTransactionIdLength];
        System.arraycopy(xidBytes, offset + 12, this.globalTransactionId_, 0, globalTransactionIdLength);
        this.branchQualifier_ = new byte[branchQualifierIdLength];
        System.arraycopy(xidBytes, globalTransactionIdLength + offset + 12, this.branchQualifier_, 0, branchQualifierIdLength);
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branchQualifier_;
    }

    @Override
    public int getFormatId() {
        return this.formatId_;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId_;
    }

    byte[] toBytes() {
        return AS400JDBCXid.xidToBytes(this);
    }

    static byte[] xidToBytes(Xid xid) {
        int formatId = xid.getFormatId();
        byte[] globalTransactionId = xid.getGlobalTransactionId();
        byte[] branchQualifier = xid.getBranchQualifier();
        byte[] xidBytes = new byte[140];
        BinaryConverter.intToByteArray(formatId, xidBytes, 0);
        BinaryConverter.intToByteArray(globalTransactionId.length, xidBytes, 4);
        BinaryConverter.intToByteArray(branchQualifier.length, xidBytes, 8);
        System.arraycopy(globalTransactionId, 0, xidBytes, 12, globalTransactionId.length);
        System.arraycopy(branchQualifier, 0, xidBytes, globalTransactionId.length + 12, branchQualifier.length);
        return xidBytes;
    }
}

