/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400ConnectionPoolAuthentication;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ConnectionList;
import com.ibm.as400.access.ConnectionPool;
import com.ibm.as400.access.ConnectionPoolEvent;
import com.ibm.as400.access.ConnectionPoolException;
import com.ibm.as400.access.CredentialVault;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Log;
import com.ibm.as400.access.PoolItem;
import com.ibm.as400.access.PoolMaintenance;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.SocketProperties;
import com.ibm.as400.access.Trace;
import com.ibm.as400.security.auth.ProfileTokenCredential;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class AS400ConnectionPool
extends ConnectionPool
implements Serializable {
    static final long serialVersionUID = 4L;
    public static final int CCSID_DEFAULT = -1;
    private transient Hashtable<String, ConnectionList> as400ConnectionPool_;
    private transient Hashtable<String, ConnectionList> removedAS400ConnectionPool_;
    private transient Log log_;
    private SocketProperties socketProperties_;
    private transient long lastRun_ = 0L;
    private transient boolean connectionHasBeenCreated_ = false;
    private static final boolean DISCARD_CONNECTION = true;

    public AS400ConnectionPool() {
        this.initializeTransient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void cleanupConnections() {
        Hashtable<String, ConnectionList> hashtable = this.as400ConnectionPool_;
        synchronized (hashtable) {
            Enumeration<String> keys = this.as400ConnectionPool_.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                try {
                    ConnectionList connList = this.as400ConnectionPool_.get(key);
                    connList.removeExpiredConnections(this.poolListeners_);
                }
                catch (Exception e) {
                    this.log(e, key);
                }
            }
        }
        if (this.poolListeners_ != null) {
            ConnectionPoolEvent poolEvent = new ConnectionPoolEvent(this, 5);
            this.poolListeners_.fireMaintenanceThreadRun(poolEvent);
        }
        this.lastRun_ = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.log(ResourceBundleLoader.getText("AS400CP_SHUTDOWN"));
        Hashtable<String, ConnectionList> hashtable = this.as400ConnectionPool_;
        synchronized (hashtable) {
            Enumeration<String> keys = this.as400ConnectionPool_.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                ConnectionList connList = this.as400ConnectionPool_.get(key);
                connList.close();
            }
            this.as400ConnectionPool_.clear();
        }
        if (this.maintenance_ != null && this.maintenance_.isAlive()) {
            this.maintenance_.shutdown();
        }
        if (this.poolListeners_ != null) {
            ConnectionPoolEvent event = new ConnectionPoolEvent(this, 0);
            this.poolListeners_.fireClosedEvent(event);
        }
        this.log(ResourceBundleLoader.getText("AS400CP_SHUTDOWNCOMP"));
    }

    private String createKey(String systemName, String userID) {
        systemName = systemName.trim();
        userID = userID.trim();
        return systemName.toUpperCase() + "/" + userID.toUpperCase();
    }

    public void fill(String systemName, String userID, ProfileTokenCredential profileToken, int service, int numberOfConnections) throws ConnectionPoolException {
        this.fill(systemName, userID, profileToken, service, numberOfConnections, null);
    }

    public void fill(String systemName, String userID, ProfileTokenCredential profileToken, int service, int numberOfConnections, Locale locale) throws ConnectionPoolException {
        if (numberOfConnections < 1) {
            throw new ExtendedIllegalArgumentException("numberOfConnections", 4);
        }
        if (Trace.traceOn_) {
            this.log(3, "fill() key before resolving= " + systemName + "/" + userID);
        }
        Vector<AS400> newAS400Connections = new Vector<AS400>();
        systemName = AS400.resolveSystem(systemName);
        userID = AS400.resolveUserId(userID.toUpperCase());
        String key = this.createKey(systemName, userID);
        if (Trace.traceOn_) {
            this.log(3, "fill() key after resolving= " + key);
        }
        try {
            ConnectionList connections = this.as400ConnectionPool_.get(key);
            if (this.log_ != null || Trace.traceOn_) {
                this.log(ResourceBundleLoader.substitute(ResourceBundleLoader.getText("AS400CP_FILLING"), new String[]{Integer.valueOf(numberOfConnections).toString(), systemName, userID}));
            }
            for (int i = 0; i < numberOfConnections; ++i) {
                newAS400Connections.addElement(this.getConnection(systemName, userID, service, true, false, locale, profileToken));
            }
            connections = this.as400ConnectionPool_.get(key);
            for (int j = 0; j < numberOfConnections; ++j) {
                connections.findElement((AS400)newAS400Connections.elementAt(j)).setInUse(false);
            }
            if (Trace.traceOn_ && locale != null) {
                this.log(3, "Created " + numberOfConnections + "with a locale.");
            }
        }
        catch (AS400SecurityException | IOException e) {
            ConnectionList connections = this.as400ConnectionPool_.get(key);
            for (int k = 0; k < newAS400Connections.size(); ++k) {
                connections.findElement((AS400)newAS400Connections.elementAt(k)).setInUse(false);
            }
            if (this.maintenance_ != null && this.maintenance_.isRunning()) {
                this.cleanupConnections();
            }
            this.log(ResourceBundleLoader.getText("AS400CP_FILLEXC"));
            throw new ConnectionPoolException(e);
        }
    }

    public void fill(String systemName, String userID, String password, int service, int numberOfConnections) throws ConnectionPoolException {
        this.fill(systemName, userID, password, service, numberOfConnections, null);
    }

    public void fill(String systemName, String userID, char[] password, int service, int numberOfConnections) throws ConnectionPoolException {
        this.fill(systemName, userID, password, service, numberOfConnections, null);
    }

    public void fill(String systemName, String userID, String password, int service, int numberOfConnections, Locale locale) throws ConnectionPoolException {
        char[] passwordChars = password != null ? password.toCharArray() : null;
        this.fill(systemName, userID, passwordChars, service, numberOfConnections, locale);
        CredentialVault.clearArray(passwordChars);
    }

    public void fill(String systemName, String userID, char[] password, int service, int numberOfConnections, Locale locale) throws ConnectionPoolException {
        if (numberOfConnections < 1) {
            throw new ExtendedIllegalArgumentException("numberOfConnections", 4);
        }
        if (Trace.traceOn_) {
            this.log(3, "fill() key before resolving= " + systemName + "/" + userID);
        }
        Vector<AS400> newAS400Connections = new Vector<AS400>();
        systemName = AS400.resolveSystem(systemName);
        userID = AS400.resolveUserId(userID.toUpperCase());
        String key = this.createKey(systemName, userID);
        if (Trace.traceOn_) {
            this.log(3, "fill() key after resolving= " + key);
        }
        try {
            ConnectionList connections = this.as400ConnectionPool_.get(key);
            if (this.log_ != null || Trace.traceOn_) {
                this.log(ResourceBundleLoader.substitute(ResourceBundleLoader.getText("AS400CP_FILLING"), new String[]{Integer.valueOf(numberOfConnections).toString(), systemName, userID}));
            }
            for (int i = 0; i < numberOfConnections; ++i) {
                newAS400Connections.addElement(this.getConnection(systemName, userID, service, true, false, locale, password));
            }
            connections = this.as400ConnectionPool_.get(key);
            for (int j = 0; j < numberOfConnections; ++j) {
                connections.findElement((AS400)newAS400Connections.elementAt(j)).setInUse(false);
            }
            if (Trace.traceOn_ && locale != null) {
                this.log(3, "Created " + numberOfConnections + "with a locale.");
            }
        }
        catch (AS400SecurityException | IOException e) {
            ConnectionList connections = this.as400ConnectionPool_.get(key);
            for (int k = 0; k < newAS400Connections.size(); ++k) {
                connections.findElement((AS400)newAS400Connections.elementAt(k)).setInUse(false);
            }
            if (this.maintenance_ != null && this.maintenance_.isRunning()) {
                this.cleanupConnections();
            }
            this.log(ResourceBundleLoader.getText("AS400CP_FILLEXC"));
            throw new ConnectionPoolException(e);
        }
    }

    @Override
    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public int getActiveConnectionCount(String systemName, String userID) {
        ConnectionList connections;
        if (systemName == null) {
            throw new NullPointerException("systemName");
        }
        if (userID == null) {
            throw new NullPointerException("userID");
        }
        systemName = AS400.resolveSystem(systemName);
        userID = AS400.resolveUserId(userID.toUpperCase());
        String key = this.createKey(systemName, userID);
        if (Trace.traceOn_) {
            this.log(3, "getActiveConnectionCount key= " + key);
        }
        if ((connections = this.as400ConnectionPool_.get(key)) == null) {
            if (Trace.traceOn_) {
                this.log(4, "getActiveConnectionCount found no " + key + " list in the pool");
            }
            return 0;
        }
        return connections.getActiveConnectionCount();
    }

    public int getAvailableConnectionCount(String systemName, String userID) {
        ConnectionList connections;
        if (systemName == null) {
            throw new NullPointerException("systemName");
        }
        if (userID == null) {
            throw new NullPointerException("userID");
        }
        systemName = AS400.resolveSystem(systemName);
        userID = AS400.resolveUserId(userID.toUpperCase());
        String key = this.createKey(systemName, userID);
        if (Trace.traceOn_) {
            this.log(3, "getAvailableConnectionCount key= " + key);
        }
        if ((connections = this.as400ConnectionPool_.get(key)) == null) {
            if (Trace.traceOn_) {
                this.log(4, "getAvailableConnectionCount found no " + key + " list in the pool");
            }
            return 0;
        }
        return connections.getAvailableConnectionCount();
    }

    @Override
    public int getCCSID() {
        return super.getCCSID();
    }

    public AS400 getConnection(String systemName, String userID, String password, int service) throws ConnectionPoolException {
        char[] passwordChars = password != null ? password.toCharArray() : null;
        AS400 answer = this.getConnection(systemName, userID, passwordChars, service);
        CredentialVault.clearArray(passwordChars);
        return answer;
    }

    public AS400 getConnection(String systemName, String userID, char[] password, int service) throws ConnectionPoolException {
        try {
            AS400 releaseConnection = this.getConnection(systemName, userID, service, true, false, null, password);
            if (this.poolListeners_ != null) {
                ConnectionPoolEvent event = new ConnectionPoolEvent(releaseConnection, 2);
                this.poolListeners_.fireConnectionReleasedEvent(event);
            }
            return releaseConnection;
        }
        catch (AS400SecurityException | IOException e) {
            throw new ConnectionPoolException(e);
        }
    }

    public AS400 getConnection(String systemName, String userID, String password, int service, Locale locale) throws ConnectionPoolException {
        char[] passwordChars = password != null ? password.toCharArray() : null;
        AS400 answer = this.getConnection(systemName, userID, passwordChars, service, locale);
        CredentialVault.clearArray(passwordChars);
        return answer;
    }

    public AS400 getConnection(String systemName, String userID, char[] password, int service, Locale locale) throws ConnectionPoolException {
        try {
            AS400 releaseConnection = this.getConnection(systemName, userID, service, true, false, locale, password);
            if (this.poolListeners_ != null) {
                ConnectionPoolEvent event = new ConnectionPoolEvent(releaseConnection, 2);
                this.poolListeners_.fireConnectionReleasedEvent(event);
            }
            return releaseConnection;
        }
        catch (AS400SecurityException | IOException e) {
            throw new ConnectionPoolException(e);
        }
    }

    public AS400 getConnection(String systemName, String userID, int service) throws ConnectionPoolException {
        throw new ConnectionPoolException(new ExtendedIOException(23));
    }

    public AS400 getConnection(String systemName, String userID, String password) throws ConnectionPoolException {
        char[] passwordChars = password != null ? password.toCharArray() : null;
        AS400 as400 = this.getConnection(systemName, userID, passwordChars);
        CredentialVault.clearArray(passwordChars);
        return as400;
    }

    public AS400 getConnection(String systemName, String userID, char[] password) throws ConnectionPoolException {
        try {
            AS400 releaseConnection = this.getConnection(systemName, userID, 0, false, false, null, password);
            if (this.poolListeners_ != null) {
                ConnectionPoolEvent event = new ConnectionPoolEvent(releaseConnection, 2);
                this.poolListeners_.fireConnectionReleasedEvent(event);
            }
            return releaseConnection;
        }
        catch (AS400SecurityException | IOException e) {
            throw new ConnectionPoolException(e);
        }
    }

    public AS400 getConnection(String systemName, String userID, String password, Locale locale) throws ConnectionPoolException {
        char[] passwordChars = password != null ? password.toCharArray() : null;
        AS400 as400 = this.getConnection(systemName, userID, passwordChars, locale);
        CredentialVault.clearArray(passwordChars);
        return as400;
    }

    public AS400 getConnection(String systemName, String userID, char[] password, Locale locale) throws ConnectionPoolException {
        try {
            AS400 releaseConnection = this.getConnection(systemName, userID, 0, false, false, locale, password);
            if (this.poolListeners_ != null) {
                ConnectionPoolEvent event = new ConnectionPoolEvent(releaseConnection, 2);
                this.poolListeners_.fireConnectionReleasedEvent(event);
            }
            return releaseConnection;
        }
        catch (AS400SecurityException | IOException e) {
            throw new ConnectionPoolException(e);
        }
    }

    public AS400 getConnection(String systemName, String userID) throws ConnectionPoolException {
        throw new ConnectionPoolException(new ExtendedIOException(23));
    }

    public AS400 getConnection(String systemName, String userID, ProfileTokenCredential profileToken, int service) throws ConnectionPoolException {
        try {
            AS400 releaseConnection = this.getConnection(systemName, userID, service, true, false, null, profileToken);
            if (this.poolListeners_ != null) {
                ConnectionPoolEvent event = new ConnectionPoolEvent(releaseConnection, 2);
                this.poolListeners_.fireConnectionReleasedEvent(event);
            }
            return releaseConnection;
        }
        catch (AS400SecurityException | IOException e) {
            throw new ConnectionPoolException(e);
        }
    }

    public AS400 getConnection(String systemName, String userID, ProfileTokenCredential profileToken, int service, Locale locale) throws ConnectionPoolException {
        try {
            AS400 releaseConnection = this.getConnection(systemName, userID, service, true, false, locale, profileToken);
            if (this.poolListeners_ != null) {
                ConnectionPoolEvent event = new ConnectionPoolEvent(releaseConnection, 2);
                this.poolListeners_.fireConnectionReleasedEvent(event);
            }
            return releaseConnection;
        }
        catch (AS400SecurityException | IOException e) {
            throw new ConnectionPoolException(e);
        }
    }

    public AS400 getConnection(String systemName, String userID, ProfileTokenCredential profileToken) throws ConnectionPoolException {
        try {
            AS400 releaseConnection = this.getConnection(systemName, userID, 0, false, false, null, profileToken);
            if (this.poolListeners_ != null) {
                ConnectionPoolEvent event = new ConnectionPoolEvent(releaseConnection, 2);
                this.poolListeners_.fireConnectionReleasedEvent(event);
            }
            return releaseConnection;
        }
        catch (AS400SecurityException | IOException e) {
            throw new ConnectionPoolException(e);
        }
    }

    public AS400 getConnection(String systemName, String userID, ProfileTokenCredential profileToken, Locale locale) throws ConnectionPoolException {
        try {
            AS400 releaseConnection = this.getConnection(systemName, userID, 0, false, false, locale, profileToken);
            if (this.poolListeners_ != null) {
                ConnectionPoolEvent event = new ConnectionPoolEvent(releaseConnection, 2);
                this.poolListeners_.fireConnectionReleasedEvent(event);
            }
            return releaseConnection;
        }
        catch (AS400SecurityException | IOException e) {
            throw new ConnectionPoolException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AS400 getConnection(String systemName, String userID, int service, boolean connect, boolean secure, Locale locale, AS400ConnectionPoolAuthentication poolAuth) throws AS400SecurityException, IOException, ConnectionPoolException {
        ConnectionList connections;
        if (systemName == null) {
            throw new NullPointerException("systemName");
        }
        if (systemName.length() == 0) {
            throw new ExtendedIllegalArgumentException("systemName", 1);
        }
        if (userID == null) {
            throw new NullPointerException("userID");
        }
        if (userID.length() == 0) {
            throw new ExtendedIllegalArgumentException("userID", 1);
        }
        if (Trace.traceOn_) {
            this.log(3, "getConnection() key before resolving= " + systemName + "/" + userID);
        }
        systemName = AS400.resolveSystem(systemName);
        userID = AS400.resolveUserId(userID.toUpperCase());
        String key = this.createKey(systemName, userID);
        if (Trace.traceOn_) {
            this.log(3, "getConnection() key after resolving= " + key);
        }
        if (!this.isInUse()) {
            this.setInUse(true);
        }
        if (this.isRunMaintenance()) {
            if (this.isThreadUsed()) {
                if (this.maintenance_ == null) {
                    AS400ConnectionPool aS400ConnectionPool = this;
                    synchronized (aS400ConnectionPool) {
                        if (this.maintenance_ == null) {
                            this.maintenance_ = new PoolMaintenance(this);
                            this.maintenance_.start();
                        }
                    }
                }
                if (!this.maintenance_.isRunning()) {
                    this.maintenance_.setRunning(true);
                }
            } else if (System.currentTimeMillis() - this.lastRun_ > this.getCleanupInterval()) {
                this.cleanupConnections();
            }
        }
        if ((connections = this.as400ConnectionPool_.get(key)) == null) {
            Hashtable<String, ConnectionList> hashtable = this.as400ConnectionPool_;
            synchronized (hashtable) {
                connections = this.as400ConnectionPool_.get(key);
                if (connections == null) {
                    if (this.log_ != null || Trace.traceOn_) {
                        this.log(ResourceBundleLoader.substitute(ResourceBundleLoader.getText("AS400CP_CONNLIST"), new String[]{systemName, userID}));
                    }
                    connections = new ConnectionList(systemName, userID, this.properties_);
                    connections.setLog(this.log_);
                    this.as400ConnectionPool_.put(key, connections);
                }
            }
        }
        AS400 connection = connections.getConnection(connect ? Integer.valueOf(service) : null, secure, this.poolListeners_, locale, poolAuth, this.socketProperties_, this.getCCSID()).getAS400Object();
        this.connectionHasBeenCreated_ = true;
        return connection;
    }

    private AS400 getConnection(String systemName, String userID, int service, boolean connect, boolean secure, Locale locale, char[] password) throws AS400SecurityException, IOException, ConnectionPoolException {
        AS400ConnectionPoolAuthentication poolAuth = new AS400ConnectionPoolAuthentication(password);
        return this.getConnection(systemName, userID, service, connect, secure, locale, poolAuth);
    }

    private AS400 getConnection(String systemName, String userID, int service, boolean connect, boolean secure, Locale locale, ProfileTokenCredential profileToken) throws AS400SecurityException, IOException, ConnectionPoolException {
        AS400ConnectionPoolAuthentication poolAuth = new AS400ConnectionPoolAuthentication(profileToken);
        return this.getConnection(systemName, userID, service, connect, secure, locale, poolAuth);
    }

    public AS400 getSecureConnection(String systemName, String userID, String password) throws ConnectionPoolException {
        char[] passwordChars = password != null ? password.toCharArray() : null;
        AS400 as400 = this.getSecureConnection(systemName, userID, passwordChars);
        CredentialVault.clearArray(passwordChars);
        return as400;
    }

    public AS400 getSecureConnection(String systemName, String userID, char[] password) throws ConnectionPoolException {
        try {
            AS400 releaseConnection = this.getConnection(systemName, userID, 0, false, true, null, password);
            releaseConnection.getVRM();
            if (this.poolListeners_ != null) {
                ConnectionPoolEvent event = new ConnectionPoolEvent(releaseConnection, 2);
                this.poolListeners_.fireConnectionReleasedEvent(event);
            }
            return releaseConnection;
        }
        catch (AS400SecurityException | IOException e) {
            throw new ConnectionPoolException(e);
        }
    }

    public AS400 getSecureConnection(String systemName, String userID) throws ConnectionPoolException {
        throw new ConnectionPoolException(new ExtendedIOException(23));
    }

    public AS400 getSecureConnection(String systemName, String userID, String password, int service) throws ConnectionPoolException {
        char[] passwordChars = password != null ? password.toCharArray() : null;
        AS400 as400 = this.getSecureConnection(systemName, userID, passwordChars, service);
        CredentialVault.clearArray(passwordChars);
        return as400;
    }

    public AS400 getSecureConnection(String systemName, String userID, char[] password, int service) throws ConnectionPoolException {
        try {
            AS400 releaseConnection = this.getConnection(systemName, userID, service, true, true, null, password);
            if (this.poolListeners_ != null) {
                ConnectionPoolEvent event = new ConnectionPoolEvent(releaseConnection, 2);
                this.poolListeners_.fireConnectionReleasedEvent(event);
            }
            return releaseConnection;
        }
        catch (AS400SecurityException | IOException e) {
            throw new ConnectionPoolException(e);
        }
    }

    public AS400 getSecureConnection(String systemName, String userID, int service) throws ConnectionPoolException {
        throw new ConnectionPoolException(new ExtendedIOException(23));
    }

    public AS400 getSecureConnection(String systemName, String userID, ProfileTokenCredential profileToken) throws ConnectionPoolException {
        try {
            AS400 releaseConnection = this.getConnection(systemName, userID, 0, false, true, null, profileToken);
            releaseConnection.getVRM();
            if (this.poolListeners_ != null) {
                ConnectionPoolEvent event = new ConnectionPoolEvent(releaseConnection, 2);
                this.poolListeners_.fireConnectionReleasedEvent(event);
            }
            return releaseConnection;
        }
        catch (AS400SecurityException | IOException e) {
            throw new ConnectionPoolException(e);
        }
    }

    public AS400 getSecureConnection(String systemName, String userID, ProfileTokenCredential profileToken, int service) throws ConnectionPoolException {
        try {
            AS400 releaseConnection = this.getConnection(systemName, userID, service, true, true, null, profileToken);
            if (this.poolListeners_ != null) {
                ConnectionPoolEvent event = new ConnectionPoolEvent(releaseConnection, 2);
                this.poolListeners_.fireConnectionReleasedEvent(event);
            }
            return releaseConnection;
        }
        catch (AS400SecurityException | IOException e) {
            throw new ConnectionPoolException(e);
        }
    }

    public SocketProperties getSocketProperties() {
        if (Trace.traceOn_) {
            this.log(1, "Getting socket properties.");
        }
        if (this.socketProperties_ == null) {
            return null;
        }
        SocketProperties socketProperties = new SocketProperties();
        socketProperties.copyValues(this.socketProperties_);
        return socketProperties;
    }

    public String[] getSystemNames() {
        Enumeration<String> keys = this.as400ConnectionPool_.keys();
        Vector<String> hosts = new Vector<String>();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String host = key.substring(0, key.indexOf("/"));
            if (hosts.contains(host)) continue;
            hosts.addElement(host);
        }
        Object[] hostsArr = new String[hosts.size()];
        hosts.copyInto(hostsArr);
        return hostsArr;
    }

    public Enumeration<String> getUsers() {
        return this.as400ConnectionPool_.keys();
    }

    public String[] getUsers(String systemName) {
        if (systemName == null) {
            throw new NullPointerException("systemName");
        }
        return this.getUsers(systemName, false);
    }

    public String[] getConnectedUsers(String systemName) {
        if (systemName == null) {
            throw new NullPointerException("systemName");
        }
        return this.getUsers(systemName, true);
    }

    private String[] getUsers(String systemName, boolean listConnectedOnly) {
        Enumeration<String> keys = this.as400ConnectionPool_.keys();
        Vector<String> users = new Vector<String>();
        systemName = systemName.toUpperCase().trim();
        String compareKey = systemName + "/";
        while (keys.hasMoreElements()) {
            String user;
            String key = keys.nextElement();
            if (!key.startsWith(compareKey)) continue;
            ConnectionList connections = this.as400ConnectionPool_.get(key);
            if (listConnectedOnly && !connections.hasConnectedConnection() || users.contains(user = key.substring(key.indexOf("/") + 1))) continue;
            users.addElement(user);
        }
        Object[] usersArr = new String[users.size()];
        users.copyInto(usersArr);
        return usersArr;
    }

    private void initializeTransient() {
        this.as400ConnectionPool_ = new Hashtable();
        this.removedAS400ConnectionPool_ = new Hashtable();
        this.lastRun_ = System.currentTimeMillis();
        this.connectionHasBeenCreated_ = false;
    }

    private final void log(String msg) {
        if (Trace.traceOn_) {
            Trace.log(3, msg);
        }
        if (this.log_ != null) {
            this.log_.log(msg);
        }
    }

    private final void log(int category, String msg) {
        if (Trace.traceOn_ && Trace.isTraceOn(category)) {
            Trace.log(category, msg);
            if (this.log_ != null) {
                this.log_.log(msg);
            }
        }
    }

    private final void log(Exception exception, String msg) {
        if (Trace.traceOn_) {
            Trace.log(2, msg, (Throwable)exception);
        }
        if (this.log_ != null) {
            this.log_.log(msg, exception);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    public void removeFromPool(String systemName, String userID) {
        String key;
        ConnectionList listToBeRemoved;
        if (systemName == null) {
            throw new NullPointerException("systemName");
        }
        if (userID == null) {
            throw new NullPointerException("userID");
        }
        if (Trace.traceOn_) {
            this.log(3, "removeFromPool(" + systemName + "," + userID);
        }
        if ((listToBeRemoved = this.as400ConnectionPool_.get(key = this.createKey(systemName = AS400.resolveSystem(systemName), userID = AS400.resolveUserId(userID.toUpperCase())))) != null) {
            listToBeRemoved.removeUnusedElements();
            this.removedAS400ConnectionPool_.put(key, listToBeRemoved);
            this.as400ConnectionPool_.remove(key);
        } else if (Trace.traceOn_) {
            this.log(4, "A list of connections for: " + key + " does not exist.");
        }
    }

    public void removeFromPool(AS400 system) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (Trace.traceOn_) {
            this.log(3, "removeFromPool() key= " + system.getSystemName() + "/" + system.getUserId() + "; hashcode= " + system.hashCode());
        }
        this.acceptReturnedConnection(system, true);
    }

    public void returnConnectionToPool(AS400 system) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (Trace.traceOn_) {
            this.log(3, "returnConnectionToPool() key= " + system.getSystemName() + "/" + system.getUserId());
        }
        this.acceptReturnedConnection(system, false);
        if (!this.isThreadUsed() && this.isRunMaintenance() && System.currentTimeMillis() - this.lastRun_ > this.getCleanupInterval()) {
            this.cleanupConnections();
        }
    }

    private void acceptReturnedConnection(AS400 system, boolean discardConnection) {
        ConnectionPoolEvent event;
        String key = this.createKey(system.getSystemName(), system.getUserId());
        ConnectionList connections = this.as400ConnectionPool_.get(key);
        PoolItem poolItem = null;
        if (connections != null) {
            poolItem = connections.findElement(system);
        }
        if (poolItem != null) {
            if (discardConnection) {
                if (Trace.traceOn_) {
                    this.log(1, "Disconnecting pooled connection because removeFromPool() was invoked for that connection.");
                }
                connections.removeElement(system);
                poolItem.getAS400Object().resetAllServices();
            } else {
                boolean removed = connections.removeIfExpired(poolItem, this.poolListeners_);
                if (!removed) {
                    poolItem.setInUse(false);
                }
                if (this.log_ != null || Trace.traceOn_) {
                    this.log(ResourceBundleLoader.substitute(ResourceBundleLoader.getText("AS400CP_RETCONN"), new String[]{system.getSystemName(), system.getUserId()}));
                }
                if (this.poolListeners_ != null) {
                    event = new ConnectionPoolEvent(poolItem.getAS400Object(), 3);
                    this.poolListeners_.fireConnectionReturnedEvent(event);
                }
            }
        }
        if (poolItem == null) {
            Enumeration<String> keys = this.as400ConnectionPool_.keys();
            while (keys.hasMoreElements()) {
                String tryKey = keys.nextElement();
                ConnectionList connList = this.as400ConnectionPool_.get(tryKey);
                poolItem = connList.findElement(system);
                if (poolItem == null) continue;
                if (Trace.traceOn_) {
                    this.log(4, "Disconnecting pooled connection because it was returned, and belongs to a different list than expected.");
                }
                connList.removeElement(system);
                poolItem.getAS400Object().disconnectAllServices();
                break;
            }
        }
        if (poolItem == null) {
            ConnectionList removedConnections = this.removedAS400ConnectionPool_.get(key);
            if (removedConnections != null) {
                poolItem = removedConnections.findElement(system);
            }
            if (poolItem != null) {
                if (Trace.traceOn_) {
                    this.log(1, "Disconnecting pooled connection because it was returned, and removeFromPool() has been called for its systemName/userID.");
                }
                removedConnections.removeElement(system);
                poolItem.getAS400Object().resetAllServices();
                if (this.log_ != null || Trace.traceOn_) {
                    this.log(ResourceBundleLoader.substitute(ResourceBundleLoader.getText("AS400CP_RETCONN"), new String[]{system.getSystemName(), system.getUserId()}));
                }
                if (this.poolListeners_ != null) {
                    event = new ConnectionPoolEvent(poolItem.getAS400Object(), 3);
                    this.poolListeners_.fireConnectionReturnedEvent(event);
                }
            }
            if (poolItem == null) {
                Enumeration<String> keys = this.removedAS400ConnectionPool_.keys();
                while (keys.hasMoreElements()) {
                    String tryKey = keys.nextElement();
                    ConnectionList connList = this.removedAS400ConnectionPool_.get(tryKey);
                    poolItem = connList.findElement(system);
                    if (poolItem == null) continue;
                    if (Trace.traceOn_) {
                        this.log(1, "Disconnecting pooled connection because it was returned, and removeFromPool() has been called for its systemName/userID.");
                    }
                    connList.removeElement(system);
                    poolItem.getAS400Object().resetAllServices();
                    break;
                }
            }
            if (poolItem == null) {
                if (discardConnection) {
                    if (Trace.traceOn_) {
                        this.log(4, "Disconnecting pooled connection because removeFromPool(AS400) was called. The connection is not currently a member of this pool.");
                    }
                } else {
                    this.log(2, "Disconnecting pooled connection because it was returned, and the connection is not currently a member of this pool.");
                }
                system.resetAllServices();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void runMaintenance(boolean reduced) {
        if (this.maintenance_ == null) {
            return;
        }
        PoolMaintenance poolMaintenance = this.maintenance_;
        synchronized (poolMaintenance) {
            if (this.maintenance_.isRunning()) {
                ConnectionList connList;
                String key;
                Hashtable<String, ConnectionList> hashtable;
                if (reduced) {
                    hashtable = this.as400ConnectionPool_;
                    synchronized (hashtable) {
                        Enumeration<String> keys = this.as400ConnectionPool_.keys();
                        while (keys.hasMoreElements()) {
                            key = keys.nextElement();
                            try {
                                connList = this.as400ConnectionPool_.get(key);
                                connList.shutDownOldest();
                            }
                            catch (Exception e) {
                                if (this.log_ == null && !Trace.traceOn_) continue;
                                this.log(e, key);
                            }
                        }
                    }
                }
                hashtable = this.removedAS400ConnectionPool_;
                synchronized (hashtable) {
                    Enumeration<String> removedKeys = this.removedAS400ConnectionPool_.keys();
                    while (removedKeys != null && removedKeys.hasMoreElements()) {
                        key = removedKeys.nextElement();
                        connList = this.removedAS400ConnectionPool_.get(key);
                        if (connList.removeUnusedElements()) continue;
                        this.removedAS400ConnectionPool_.remove(key);
                    }
                }
                this.maintenance_.notify();
            }
        }
    }

    @Override
    public void setCCSID(int ccsid) {
        if (Trace.traceOn_) {
            Trace.log(3, "setCCSID(" + ccsid + ")");
            if (this.connectionHasBeenCreated_) {
                this.log(4, "setCCSID() was called after the pool already contains connections.");
            }
        }
        super.setCCSID(ccsid);
    }

    public void setLog(Log log) {
        if (Trace.traceOn_) {
            String val = log == null ? "null" : log.toString();
            Trace.log(3, "setLog(" + val + ")");
        }
        this.log_ = log;
    }

    public void setSocketProperties(SocketProperties properties) {
        if (Trace.traceOn_) {
            Trace.log(3, "setSocketProperties()");
        }
        this.socketProperties_ = properties;
    }
}

