/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.transforms.window;

import org.apache.hop.beam.transforms.window.BeamTimestampMeta;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class BeamTimestampDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = BeamTimestampDialog.class;
    private final BeamTimestampMeta input;
    int middle;
    int margin;
    private Combo wFieldName;
    private Button wReading;

    public BeamTimestampDialog(Shell parent, IVariables variables, BeamTimestampMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        String[] fieldNames;
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"BeamTimestampDialog.DialogTitle", (String[])new String[0]));
        this.middle = this.props.getMiddlePct();
        this.margin = PropsUi.getMargin();
        try {
            fieldNames = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta).getFieldNames();
        }
        catch (HopException e2) {
            this.log.logError("Error getting fields from previous transforms", (Throwable)e2);
            fieldNames = new String[]{};
        }
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.TransformName.Label", (String[])new String[0]));
        this.wlTransformName.setToolTipText(BaseMessages.getString(PKG, (String)"System.TransformName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, this.margin);
        this.fdlTransformName.right = new FormAttachment(this.middle, -this.margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(this.middle, 0);
        this.fdTransformName.top = new FormAttachment((Control)this.wlTransformName, 0, 0x1000000);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Text lastControl = this.wTransformName;
        Label wlFieldName = new Label((Composite)this.shell, 131072);
        wlFieldName.setText(BaseMessages.getString(PKG, (String)"BeamTimestampDialog.FieldName", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFieldName);
        FormData fdlFieldName = new FormData();
        fdlFieldName.left = new FormAttachment(0, 0);
        fdlFieldName.top = new FormAttachment((Control)lastControl, this.margin);
        fdlFieldName.right = new FormAttachment(this.middle, -this.margin);
        wlFieldName.setLayoutData((Object)fdlFieldName);
        this.wFieldName = new Combo((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wFieldName);
        this.wFieldName.setItems(fieldNames);
        FormData fdFieldName = new FormData();
        fdFieldName.left = new FormAttachment(this.middle, 0);
        fdFieldName.top = new FormAttachment((Control)wlFieldName, 0, 0x1000000);
        fdFieldName.right = new FormAttachment(100, 0);
        this.wFieldName.setLayoutData((Object)fdFieldName);
        lastControl = this.wFieldName;
        Label wlReading = new Label((Composite)this.shell, 131072);
        wlReading.setText(BaseMessages.getString(PKG, (String)"BeamTimestampDialog.Reading", (String[])new String[0]));
        PropsUi.setLook((Widget)wlReading);
        FormData fdlReading = new FormData();
        fdlReading.left = new FormAttachment(0, 0);
        fdlReading.top = new FormAttachment((Control)lastControl, this.margin);
        fdlReading.right = new FormAttachment(this.middle, -this.margin);
        wlReading.setLayoutData((Object)fdlReading);
        this.wReading = new Button((Composite)this.shell, 16416);
        PropsUi.setLook((Widget)this.wReading);
        FormData fdReading = new FormData();
        fdReading.left = new FormAttachment(this.middle, 0);
        fdReading.top = new FormAttachment((Control)wlReading, 0, 0x1000000);
        fdReading.right = new FormAttachment(100, 0);
        this.wReading.setLayoutData((Object)fdReading);
        lastControl = this.wReading;
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wOk, this.wCancel}, (int)this.margin, (Control)lastControl);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        this.wTransformName.setText(this.transformName);
        this.wFieldName.setText(Const.NVL((String)this.input.getFieldName(), (String)""));
        this.wReading.setSelection(this.input.isReadingTimestamp());
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.getInfo(this.input);
        this.dispose();
    }

    private void getInfo(BeamTimestampMeta in) {
        this.transformName = this.wTransformName.getText();
        in.setFieldName(this.wFieldName.getText());
        in.setReadingTimestamp(this.wReading.getSelection());
        this.input.setChanged();
    }
}

