/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.core.transform;

import java.util.HashMap;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.hcatalog.HCatalogIO;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.hive.hcatalog.data.HCatRecord;
import org.apache.hop.beam.core.BeamHop;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.core.fn.StringToHopFn;
import org.apache.hop.core.row.IRowMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeamHiveMetastoreInputTransform
extends PTransform<PBegin, PCollection<HopRow>> {
    private static final Logger LOG = LoggerFactory.getLogger(BeamHiveMetastoreInputTransform.class);
    private static final Counter numErrors = Metrics.counter((String)"main", (String)"BeamBQInputError");
    private String transformName;
    private String hiveMetastoreUris;
    private String hiveMetastoreDatabase;
    private String hiveMetastoreTable;
    private String rowMetaJson;
    private transient IRowMeta rowMeta;

    public BeamHiveMetastoreInputTransform() {
    }

    public BeamHiveMetastoreInputTransform(@Nullable String name, String transformName, String hiveMetastoreUris, String hiveMetastoreDatabase, String hiveMetastoreTable, String rowMetaJson) {
        super(name);
        this.transformName = transformName;
        this.hiveMetastoreUris = hiveMetastoreUris;
        this.hiveMetastoreDatabase = hiveMetastoreDatabase;
        this.hiveMetastoreTable = hiveMetastoreTable;
        this.rowMetaJson = rowMetaJson;
    }

    public PCollection<HopRow> expand(PBegin input) {
        try {
            BeamHop.init();
            HashMap<String, String> configProperties = new HashMap<String, String>();
            configProperties.put("hive.metastore.uris", this.hiveMetastoreUris);
            PCollection tempOutput = (PCollection)((PCollection)input.apply((PTransform)HCatalogIO.read().withConfigProperties(configProperties).withDatabase(this.hiveMetastoreDatabase).withTable(this.hiveMetastoreTable))).apply((PTransform)ParDo.of((DoFn)new DoFn<HCatRecord, String>(){

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext c) {
                    Object outputStr = "";
                    for (int i = 0; i < ((HCatRecord)c.element()).size(); ++i) {
                        Object element;
                        if (i < ((HCatRecord)c.element()).size() - 1) {
                            element = Objects.requireNonNull((HCatRecord)c.element()).get(i);
                            if (element != null) {
                                outputStr = (String)outputStr + element.toString() + ";";
                                continue;
                            }
                            outputStr = (String)outputStr + ";";
                            continue;
                        }
                        element = Objects.requireNonNull((HCatRecord)c.element()).get(i);
                        if (element == null) continue;
                        outputStr = (String)outputStr + element.toString();
                    }
                    c.output(outputStr);
                }
            }));
            PCollection output = (PCollection)tempOutput.apply((PTransform)ParDo.of((DoFn)new StringToHopFn(this.transformName, this.rowMetaJson, ",")));
            return output;
        }
        catch (Exception e) {
            numErrors.inc();
            LOG.error("Error in beam input transform", (Throwable)e);
            throw new RuntimeException("Error in beam input transform", e);
        }
    }
}

