/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.widget;

import java.util.LinkedList;
import java.util.List;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.FormDataBuilder;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ControlSpaceKeyAdapter;
import org.apache.hop.ui.core.widget.TextComposite;
import org.apache.hop.ui.core.widget.UndoRedoStack;
import org.apache.hop.ui.core.widget.highlight.JavaHighlight;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;

public class StyledTextVar
extends TextComposite {
    private static final Class<?> PKG = StyledTextVar.class;
    private static final int MAX_STACK_SIZE = 25;
    private final StyledText wText;
    private final Menu wPopupMenu;
    private List<UndoRedoStack> undoStack = new LinkedList<UndoRedoStack>();
    private List<UndoRedoStack> redoStack = new LinkedList<UndoRedoStack>();
    private boolean fullSelection = false;

    public StyledTextVar(IVariables variables, Composite parent, int style) {
        this(variables, parent, style, true, false);
    }

    public StyledTextVar(IVariables variables, Composite parent, int style, boolean varsSensitive) {
        this(variables, parent, style, varsSensitive, false);
    }

    public StyledTextVar(IVariables variables, Composite parent, int style, boolean varsSensitive, boolean variableIconOnTop) {
        super(parent, 0);
        this.wText = new StyledText((Composite)this, style);
        this.wPopupMenu = new Menu((Decorations)parent.getShell(), 8);
        this.setLayout((Layout)new FormLayout());
        this.buildingStyledTextMenu(this.wPopupMenu);
        this.addUndoRedoSupport();
        this.wText.setLayoutData((Object)new FormDataBuilder().top().left().right(100, 0).bottom(100, 0).result());
        if (varsSensitive) {
            this.wText.addKeyListener((KeyListener)new ControlSpaceKeyAdapter(variables, (Control)this.wText));
            if (variableIconOnTop) {
                Label wIcon = new Label((Composite)this, 131072);
                PropsUi.setLook((Widget)wIcon);
                wIcon.setToolTipText(BaseMessages.getString(PKG, (String)"StyledTextComp.tooltip.InsertVariable", (String[])new String[0]));
                wIcon.setImage(GuiResource.getInstance().getImageVariableMini());
                wIcon.setLayoutData((Object)new FormDataBuilder().top().right(100, 0).result());
                this.wText.setLayoutData((Object)new FormDataBuilder().top(new FormAttachment((Control)wIcon, 0, 0)).left().right(100, 0).bottom(100, 0).result());
            } else {
                Label controlDecoration = new Label((Composite)this, 0);
                controlDecoration.setImage(GuiResource.getInstance().getImageVariableMini());
                controlDecoration.setToolTipText(BaseMessages.getString(PKG, (String)"StyledTextComp.tooltip.InsertVariable", (String[])new String[0]));
                PropsUi.setLook((Widget)controlDecoration);
                controlDecoration.setLayoutData((Object)new FormDataBuilder().top().right(100, 0).result());
                this.wText.setLayoutData((Object)new FormDataBuilder().top().left().right(new FormAttachment((Control)controlDecoration, 0, 0)).bottom(100, 0).result());
            }
        }
    }

    @Override
    public String getSelectionText() {
        return this.wText.getSelectionText();
    }

    @Override
    public int getCaretPosition() {
        return this.wText.getCaretOffset();
    }

    @Override
    public void setCaretPosition(int offset) {
        this.wText.setCaretOffset(offset);
    }

    @Override
    public int getCharCount() {
        return this.wText.getCharCount();
    }

    @Override
    public String getText() {
        return this.wText.getText();
    }

    @Override
    public void setText(String text) {
        this.wText.setText(text);
    }

    @Override
    public void insert(String strInsert) {
        this.wText.insert(strInsert);
    }

    public void addListener(int eventType, Listener listener) {
        this.wText.addListener(eventType, listener);
    }

    @Override
    public void addModifyListener(ModifyListener lsMod) {
        this.wText.addModifyListener(lsMod);
    }

    @Override
    public void addLineStyleListener() {
        this.addLineStyleListener(new JavaHighlight());
    }

    @Override
    public void addLineStyleListener(List<String> keywords) {
    }

    public void addLineStyleListener(LineStyleListener lineStyler) {
        this.wText.addLineStyleListener(lineStyler);
    }

    public void addKeyListener(KeyAdapter keyAdapter) {
        this.wText.addKeyListener((KeyListener)keyAdapter);
    }

    public void addFocusListener(FocusAdapter focusAdapter) {
        this.wText.addFocusListener((FocusListener)focusAdapter);
    }

    public void addMouseListener(MouseAdapter mouseAdapter) {
        this.wText.addMouseListener((MouseListener)mouseAdapter);
    }

    @Override
    public void addMenuDetectListener(MenuDetectListener listener) {
        this.wText.addMenuDetectListener(listener);
    }

    @Override
    public int getSelectionCount() {
        return this.wText.getSelectionCount();
    }

    @Override
    public void setSelection(int start) {
        this.wText.setSelection(start);
    }

    @Override
    public void setSelection(int start, int end) {
        this.wText.setSelection(start, end);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.wText.setBackground(color);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.wText.setForeground(color);
    }

    public void setFont(Font fnt) {
        this.wText.setFont(fnt);
    }

    public StyledText getTextWidget() {
        return this.wText;
    }

    @Override
    public boolean isEditable() {
        return this.wText.getEditable();
    }

    @Override
    public void setEditable(boolean editable) {
        this.wText.setEditable(editable);
    }

    public void setEnabled(boolean enabled) {
        this.wText.setEnabled(enabled);
        if (Display.getDefault() != null) {
            this.wText.setBackground(enabled ? GuiResource.getInstance().getColorWhite() : GuiResource.getInstance().getColorBackground());
        }
    }

    @Override
    public void cut() {
        this.wText.cut();
    }

    @Override
    public void copy() {
        this.wText.copy();
    }

    @Override
    public void paste() {
        this.wText.paste();
    }

    @Override
    public void selectAll() {
        this.wText.selectAll();
    }

    @Override
    public void setMenu(Menu menu) {
        this.wText.setMenu(menu);
    }

    @Override
    protected boolean isSupportUnoRedo() {
        return true;
    }

    protected void addUndoRedoSupport() {
        this.wText.addListener(13, event -> {
            if (this.getSelectionCount() == this.wText.getCharCount()) {
                this.fullSelection = true;
            }
        });
        this.wText.addExtendedModifyListener(event -> {
            int eventLength = event.length;
            int eventStartPostition = event.start;
            String newText = this.getText();
            String repText = event.replacedText;
            Object oldText = "";
            int eventType = -1;
            if (event.length != newText.length() || this.fullSelection) {
                if (repText != null && !repText.isEmpty()) {
                    oldText = newText.substring(0, event.start) + repText + newText.substring(event.start + event.length);
                    eventType = 0;
                    eventLength = repText.length();
                } else {
                    oldText = newText.substring(0, event.start) + newText.substring(event.start + event.length);
                    eventType = 1;
                }
                if (oldText != null && !((String)oldText).isEmpty() || eventStartPostition == event.length) {
                    UndoRedoStack urs = new UndoRedoStack(eventStartPostition, newText, (String)oldText, eventLength, eventType);
                    if (this.undoStack.size() == 25) {
                        this.undoStack.remove(this.undoStack.size() - 1);
                    }
                    this.undoStack.add(0, urs);
                }
            }
            this.fullSelection = false;
        });
    }

    @Override
    protected void undo() {
        if (!this.undoStack.isEmpty()) {
            UndoRedoStack undo = this.undoStack.remove(0);
            if (this.redoStack.size() == 25) {
                this.redoStack.remove(this.redoStack.size() - 1);
            }
            UndoRedoStack redo = new UndoRedoStack(undo.getCursorPosition(), undo.getReplacedText(), this.getText(), undo.getEventLength(), undo.getType());
            this.fullSelection = false;
            this.setText(undo.getReplacedText());
            if (undo.getType() == 1) {
                this.setCaretPosition(undo.getCursorPosition());
            } else if (undo.getType() == 0) {
                this.setCaretPosition(undo.getCursorPosition() + undo.getEventLength());
                this.setSelection(undo.getCursorPosition(), undo.getCursorPosition() + undo.getEventLength());
                if (this.getSelectionCount() == this.getCharCount()) {
                    this.fullSelection = true;
                }
            }
            this.redoStack.add(0, redo);
        }
    }

    @Override
    protected void redo() {
        if (!this.redoStack.isEmpty()) {
            UndoRedoStack redo = this.redoStack.remove(0);
            if (this.undoStack.size() == 25) {
                this.undoStack.remove(this.undoStack.size() - 1);
            }
            UndoRedoStack undo = new UndoRedoStack(redo.getCursorPosition(), redo.getReplacedText(), this.getText(), redo.getEventLength(), redo.getType());
            this.fullSelection = false;
            this.setText(redo.getReplacedText());
            if (redo.getType() == 1) {
                this.setCaretPosition(redo.getCursorPosition());
            } else if (redo.getType() == 0) {
                this.setCaretPosition(redo.getCursorPosition() + redo.getEventLength());
                this.setSelection(redo.getCursorPosition(), redo.getCursorPosition() + redo.getEventLength());
                if (this.getSelectionCount() == this.getCharCount()) {
                    this.fullSelection = true;
                }
            }
            this.undoStack.add(0, undo);
        }
    }
}

