/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.dialog;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.FormDataBuilder;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterNumberDialogResult;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class EnterNumberDialog
extends Dialog {
    private static final Class<?> PKG = EnterNumberDialog.class;
    protected Text wNumber;
    protected Text wFrom;
    protected Text wTo;
    protected Button wOk;
    protected Button wCancel;
    protected Button wCheckbox;
    private boolean hideCancelButton;
    protected Shell shell;
    protected int samples;
    private String shellText;
    private String lineText;
    private String checkboxLabel;
    private PropsUi props;
    private int width;
    EnterNumberDialogResult result = new EnterNumberDialogResult();

    public EnterNumberDialog(Shell parent, int samples, String shellText, String lineText) {
        this(parent, samples, shellText, lineText, null);
    }

    public EnterNumberDialog(Shell parent, int samples, String shellText, String lineText, String checkboxLabel, int width) {
        this(parent, samples, shellText, lineText, checkboxLabel);
        this.width = width;
    }

    public EnterNumberDialog(Shell parent, int samples, String shellText, String lineText, String checkboxLabel) {
        super(parent, 0);
        this.props = PropsUi.getInstance();
        this.samples = samples;
        this.shellText = shellText;
        this.lineText = lineText;
        this.checkboxLabel = checkboxLabel;
    }

    public EnterNumberDialogResult openWithFromTo() {
        this.createDialog(true);
        return this.result;
    }

    public int open() {
        this.createDialog(false);
        return this.samples;
    }

    private void createDialog(boolean withFromTo) {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 268503136);
        PropsUi.setLook((Widget)this.shell);
        this.shell.setImage(GuiResource.getInstance().getImageHopUi());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 15;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(this.shellText);
        Label wlNumber = new Label((Composite)this.shell, 0);
        wlNumber.setText(this.lineText);
        PropsUi.setLook((Widget)wlNumber);
        FormData fdlNumber = new FormData();
        fdlNumber.left = new FormAttachment(0, 0);
        fdlNumber.top = new FormAttachment(0, 0);
        wlNumber.setLayoutData((Object)fdlNumber);
        this.wNumber = new Text((Composite)this.shell, 18436);
        this.wNumber.setText("100");
        PropsUi.setLook((Widget)this.wNumber);
        FormData fdNumber = new FormData();
        fdNumber.left = new FormAttachment(0, 0);
        fdNumber.top = new FormAttachment((Control)wlNumber, 5);
        fdNumber.right = new FormAttachment(100, 0);
        this.wNumber.setLayoutData((Object)fdNumber);
        Text lastControl = this.wNumber;
        if (StringUtils.isNotBlank((String)this.checkboxLabel)) {
            this.wCheckbox = new Button((Composite)this.shell, 32);
            PropsUi.setLook((Widget)this.wCheckbox);
            FormData fdCheckbox = new FormData();
            fdCheckbox.left = new FormAttachment(0, 0);
            fdCheckbox.top = new FormAttachment((Control)this.wNumber, 10);
            fdCheckbox.width = 20;
            this.wCheckbox.setLayoutData((Object)fdCheckbox);
            Label wlCheckbox = new Label((Composite)this.shell, 16384);
            wlCheckbox.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent mouseEvent) {
                    EnterNumberDialog.this.wCheckbox.setSelection(!EnterNumberDialog.this.wCheckbox.getSelection());
                }
            });
            wlCheckbox.setText(this.checkboxLabel);
            PropsUi.setLook((Widget)wlCheckbox);
            FormData fdlCheckbox = new FormData();
            fdlCheckbox.left = new FormAttachment((Control)this.wCheckbox, 0);
            fdlCheckbox.top = new FormAttachment((Control)this.wCheckbox, 0, 0x1000000);
            wlCheckbox.setLayoutData((Object)fdlCheckbox);
            lastControl = wlCheckbox;
        }
        if (withFromTo) {
            Label wlFrom = new Label((Composite)this.shell, 131072);
            wlFrom.setText("From:");
            PropsUi.setLook((Widget)wlFrom);
            FormData fdlFrom = new FormData();
            fdlFrom.left = new FormAttachment(0, 0);
            fdlFrom.top = new FormAttachment((Control)lastControl, 10);
            wlFrom.setLayoutData((Object)fdlFrom);
            this.wFrom = new Text((Composite)this.shell, 18436);
            PropsUi.setLook((Widget)this.wFrom);
            FormData fdFrom = new FormData();
            fdFrom.left = new FormAttachment((Control)wlFrom, 10);
            fdFrom.top = new FormAttachment((Control)lastControl, 10);
            this.wFrom.setLayoutData((Object)fdFrom);
            this.wFrom.addModifyListener(e -> this.wNumber.setEnabled(this.wFrom.getText().isEmpty()));
            Label wlTo = new Label((Composite)this.shell, 131072);
            wlTo.setText("To:");
            PropsUi.setLook((Widget)wlTo);
            FormData fdlTo = new FormData();
            fdlTo.left = new FormAttachment((Control)this.wFrom, 10);
            fdlTo.top = new FormAttachment((Control)lastControl, 10);
            wlTo.setLayoutData((Object)fdlTo);
            this.wTo = new Text((Composite)this.shell, 18436);
            PropsUi.setLook((Widget)this.wTo);
            FormData fdTo = new FormData();
            fdTo.left = new FormAttachment((Control)wlTo, 10);
            fdTo.top = new FormAttachment((Control)lastControl, 10);
            this.wTo.setLayoutData((Object)fdTo);
            lastControl = wlFrom;
        }
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        if (!this.hideCancelButton) {
            this.wCancel = new Button((Composite)this.shell, 8);
            this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        }
        this.wCancel.setLayoutData((Object)new FormDataBuilder().top((Control)lastControl, 20).right(100, 0).result());
        this.wOk.setLayoutData((Object)new FormDataBuilder().top((Control)lastControl, 20).right((Control)this.wCancel, Const.isOSX() ? 0 : -5).result());
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel.addListener(13, e -> this.cancel());
        this.getData();
        BaseDialog.defaultShellHandling(this.shell, c -> this.ok(), c -> this.cancel());
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        this.wNumber.setText(Integer.toString(this.samples));
        this.wNumber.selectAll();
    }

    private void cancel() {
        this.samples = -1;
        this.result.setNumberOfLines(-1);
        this.result.setFromLine(-1);
        this.result.setToLine(-1);
        this.dispose();
    }

    protected void ok() {
        try {
            if (this.wFrom != null && !this.wFrom.getText().isEmpty()) {
                this.result.setNumberOfLines(-1);
                this.result.setFromLine(Integer.parseInt(this.wFrom.getText()));
                this.result.setToLine(Integer.parseInt(this.wTo.getText()));
            } else {
                this.samples = Integer.parseInt(this.wNumber.getText());
                this.result.setNumberOfLines(Integer.parseInt(this.wNumber.getText()));
            }
            this.dispose();
        }
        catch (Exception e) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"Dialog.Error.EnterInteger", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"Dialog.Error.Header", (String[])new String[0]));
            mb.open();
            this.wNumber.selectAll();
        }
    }

    public void setHideCancel(boolean hideCancel) {
        this.hideCancelButton = hideCancel;
    }
}

