/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.sftpput;

import java.net.InetAddress;
import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.LabelTextVar;
import org.apache.hop.ui.core.widget.PasswordTextVar;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.actions.sftp.SftpClient;
import org.apache.hop.workflow.actions.sftpput.ActionSftpPut;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ActionSftpPutDialog
extends ActionDialog {
    private static final Class<?> PKG = ActionSftpPut.class;
    private static final String[] FILETYPES = new String[]{BaseMessages.getString(PKG, (String)"ActionSftpPut.Filetype.Pem", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSftpPut.Filetype.All", (String[])new String[0])};
    private Text wName;
    private TextVar wServerName;
    private TextVar wServerPort;
    private TextVar wUserName;
    private TextVar wPassword;
    private TextVar wScpDirectory;
    private Label wlLocalDirectory;
    private TextVar wLocalDirectory;
    private Label wlWildcard;
    private TextVar wWildcard;
    private ActionSftpPut action;
    private Button wCreateRemoteFolder;
    private Button wbLocalDirectory;
    private boolean changed;
    private Button wbTestChangeFolderExists;
    private Button wGetPrevious;
    private Button wGetPreviousFiles;
    private Button wSuccessWhenNoFile;
    private Label wlAddFilenameToResult;
    private Button wAddFilenameToResult;
    private LabelTextVar wKeyFilePass;
    private Button wUsePublicKey;
    private Label wlKeyFilename;
    private Button wbKeyFilename;
    private TextVar wKeyFilename;
    private CCombo wCompression;
    private CCombo wProxyType;
    private LabelTextVar wProxyHost;
    private LabelTextVar wProxyPort;
    private LabelTextVar wProxyUsername;
    private LabelTextVar wProxyPassword;
    private CCombo wAfterFtpPut;
    private Label wlCreateDestinationFolder;
    private Button wCreateDestinationFolder;
    private Label wlDestinationFolder;
    private TextVar wDestinationFolder;
    private Button wbMovetoDirectory;
    private SftpClient sftpclient = null;

    public ActionSftpPutDialog(Shell parent, ActionSftpPut action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = action;
        if (this.action.getName() == null) {
            this.action.setName(BaseMessages.getString(PKG, (String)"ActionSftpPut.Title", (String[])new String[0]));
        }
    }

    public IAction open() {
        this.shell = new Shell(this.getParent(), 3312);
        PropsUi.setLook((Widget)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        ModifyListener lsMod = e -> {
            this.sftpclient = null;
            this.action.setChanged();
        };
        this.changed = this.action.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionSftpPut.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"ActionSftpPut.Name.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wName);
        this.wName.addModifyListener(lsMod);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, 0);
        fdName.top = new FormAttachment(0, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)margin, null);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)wTabFolder, (int)4);
        CTabItem wGeneralTab = new CTabItem(wTabFolder, 0);
        wGeneralTab.setFont(GuiResource.getInstance().getFontDefault());
        wGeneralTab.setText(BaseMessages.getString(PKG, (String)"ActionSftpPut.Tab.General.Label", (String[])new String[0]));
        Composite wGeneralComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wGeneralComp);
        FormLayout generalLayout = new FormLayout();
        generalLayout.marginWidth = 3;
        generalLayout.marginHeight = 3;
        wGeneralComp.setLayout((Layout)generalLayout);
        Group wServerSettings = new Group(wGeneralComp, 32);
        PropsUi.setLook((Widget)wServerSettings);
        wServerSettings.setText(BaseMessages.getString(PKG, (String)"ActionSftpPut.ServerSettings.Group.Label", (String[])new String[0]));
        FormLayout serverSettingsgroupLayout = new FormLayout();
        serverSettingsgroupLayout.marginWidth = 10;
        serverSettingsgroupLayout.marginHeight = 10;
        wServerSettings.setLayout((Layout)serverSettingsgroupLayout);
        Label wlServerName = new Label((Composite)wServerSettings, 131072);
        wlServerName.setText(BaseMessages.getString(PKG, (String)"ActionSftpPut.Server.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlServerName);
        FormData fdlServerName = new FormData();
        fdlServerName.left = new FormAttachment(0, 0);
        fdlServerName.top = new FormAttachment((Control)this.wName, margin);
        fdlServerName.right = new FormAttachment(middle, -margin);
        wlServerName.setLayoutData((Object)fdlServerName);
        this.wServerName = new TextVar(this.variables, (Composite)wServerSettings, 18436);
        PropsUi.setLook((Widget)this.wServerName);
        this.wServerName.addModifyListener(lsMod);
        FormData fdServerName = new FormData();
        fdServerName.left = new FormAttachment(middle, 0);
        fdServerName.top = new FormAttachment((Control)this.wName, margin);
        fdServerName.right = new FormAttachment(100, 0);
        this.wServerName.setLayoutData((Object)fdServerName);
        Label wlServerPort = new Label((Composite)wServerSettings, 131072);
        wlServerPort.setText(BaseMessages.getString(PKG, (String)"ActionSftpPut.Port.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlServerPort);
        FormData fdlServerPort = new FormData();
        fdlServerPort.left = new FormAttachment(0, 0);
        fdlServerPort.top = new FormAttachment((Control)this.wServerName, margin);
        fdlServerPort.right = new FormAttachment(middle, -margin);
        wlServerPort.setLayoutData((Object)fdlServerPort);
        this.wServerPort = new TextVar(this.variables, (Composite)wServerSettings, 18436);
        PropsUi.setLook((Widget)this.wServerPort);
        this.wServerPort.setToolTipText(BaseMessages.getString(PKG, (String)"ActionSftpPut.Port.Tooltip", (String[])new String[0]));
        this.wServerPort.addModifyListener(lsMod);
        FormData fdServerPort = new FormData();
        fdServerPort.left = new FormAttachment(middle, 0);
        fdServerPort.top = new FormAttachment((Control)this.wServerName, margin);
        fdServerPort.right = new FormAttachment(100, 0);
        this.wServerPort.setLayoutData((Object)fdServerPort);
        Label wlUserName = new Label((Composite)wServerSettings, 131072);
        wlUserName.setText(BaseMessages.getString(PKG, (String)"ActionSftpPut.Username.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlUserName);
        FormData fdlUserName = new FormData();
        fdlUserName.left = new FormAttachment(0, 0);
        fdlUserName.top = new FormAttachment((Control)this.wServerPort, margin);
        fdlUserName.right = new FormAttachment(middle, -margin);
        wlUserName.setLayoutData((Object)fdlUserName);
        this.wUserName = new TextVar(this.variables, (Composite)wServerSettings, 18436);
        PropsUi.setLook((Widget)this.wUserName);
        this.wUserName.setToolTipText(BaseMessages.getString(PKG, (String)"ActionSftpPut.Username.Tooltip", (String[])new String[0]));
        this.wUserName.addModifyListener(lsMod);
        FormData fdUserName = new FormData();
        fdUserName.left = new FormAttachment(middle, 0);
        fdUserName.top = new FormAttachment((Control)this.wServerPort, margin);
        fdUserName.right = new FormAttachment(100, 0);
        this.wUserName.setLayoutData((Object)fdUserName);
        Label wlPassword = new Label((Composite)wServerSettings, 131072);
        wlPassword.setText(BaseMessages.getString(PKG, (String)"ActionSftpPut.Password.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlPassword);
        FormData fdlPassword = new FormData();
        fdlPassword.left = new FormAttachment(0, 0);
        fdlPassword.top = new FormAttachment((Control)this.wUserName, margin);
        fdlPassword.right = new FormAttachment(middle, -margin);
        wlPassword.setLayoutData((Object)fdlPassword);
        this.wPassword = new PasswordTextVar(this.variables, (Composite)wServerSettings, 18436);
        PropsUi.setLook((Widget)this.wPassword);
        this.wPassword.addModifyListener(lsMod);
        FormData fdPassword = new FormData();
        fdPassword.left = new FormAttachment(middle, 0);
        fdPassword.top = new FormAttachment((Control)this.wUserName, margin);
        fdPassword.right = new FormAttachment(100, 0);
        this.wPassword.setLayoutData((Object)fdPassword);
        Label wlUsePublicKey = new Label((Composite)wServerSettings, 131072);
        wlUsePublicKey.setText(BaseMessages.getString(PKG, (String)"ActionSftpPut.useKeyFile.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlUsePublicKey);
        FormData fdlUsePublicKey = new FormData();
        fdlUsePublicKey.left = new FormAttachment(0, 0);
        fdlUsePublicKey.top = new FormAttachment((Control)this.wPassword, margin);
        fdlUsePublicKey.right = new FormAttachment(middle, -margin);
        wlUsePublicKey.setLayoutData((Object)fdlUsePublicKey);
        this.wUsePublicKey = new Button((Composite)wServerSettings, 32);
        this.wUsePublicKey.setToolTipText(BaseMessages.getString(PKG, (String)"ActionSftpPut.useKeyFile.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wUsePublicKey);
        FormData fdUsePublicKey = new FormData();
        fdUsePublicKey.left = new FormAttachment(middle, 0);
        fdUsePublicKey.top = new FormAttachment((Control)wlUsePublicKey, 0, 0x1000000);
        fdUsePublicKey.right = new FormAttachment(100, 0);
        this.wUsePublicKey.setLayoutData((Object)fdUsePublicKey);
        this.wUsePublicKey.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionSftpPutDialog.this.activeUseKey();
                ActionSftpPutDialog.this.action.setChanged();
            }
        });
        this.wlKeyFilename = new Label((Composite)wServerSettings, 131072);
        this.wlKeyFilename.setText(BaseMessages.getString(PKG, (String)"ActionSftpPut.KeyFilename.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlKeyFilename);
        FormData fdlKeyFilename = new FormData();
        fdlKeyFilename.left = new FormAttachment(0, 0);
        fdlKeyFilename.top = new FormAttachment((Control)wlUsePublicKey, 2 * margin);
        fdlKeyFilename.right = new FormAttachment(middle, -margin);
        this.wlKeyFilename.setLayoutData((Object)fdlKeyFilename);
        this.wbKeyFilename = new Button((Composite)wServerSettings, 0x1000008);
        PropsUi.setLook((Widget)this.wbKeyFilename);
        this.wbKeyFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbKeyFilename = new FormData();
        fdbKeyFilename.right = new FormAttachment(100, 0);
        fdbKeyFilename.top = new FormAttachment((Control)this.wUsePublicKey, 0);
        this.wbKeyFilename.setLayoutData((Object)fdbKeyFilename);
        this.wKeyFilename = new TextVar(this.variables, (Composite)wServerSettings, 18436);
        this.wKeyFilename.setToolTipText(BaseMessages.getString(PKG, (String)"ActionSftpPut.KeyFilename.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wKeyFilename);
        this.wKeyFilename.addModifyListener(lsMod);
        FormData fdKeyFilename = new FormData();
        fdKeyFilename.left = new FormAttachment(middle, 0);
        fdKeyFilename.top = new FormAttachment((Control)this.wUsePublicKey, margin);
        fdKeyFilename.right = new FormAttachment((Control)this.wbKeyFilename, -margin);
        this.wKeyFilename.setLayoutData((Object)fdKeyFilename);
        this.wbKeyFilename.addListener(13, e -> BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wKeyFilename, (IVariables)this.variables, (String[])new String[]{"*.pem", "*"}, (String[])FILETYPES, (boolean)true));
        this.wKeyFilePass = new LabelTextVar(this.variables, (Composite)wServerSettings, 0, BaseMessages.getString(PKG, (String)"ActionSftpPut.keyfilePass.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSftpPut.keyfilePass.Tooltip", (String[])new String[0]), true, false);
        PropsUi.setLook((Widget)this.wKeyFilePass);
        this.wKeyFilePass.addModifyListener(lsMod);
        FormData fdkeyfilePass = new FormData();
        fdkeyfilePass.left = new FormAttachment(0, 0);
        fdkeyfilePass.top = new FormAttachment((Control)this.wKeyFilename, margin);
        fdkeyfilePass.right = new FormAttachment(100, 0);
        this.wKeyFilePass.setLayoutData((Object)fdkeyfilePass);
        Label wlProxyType = new Label((Composite)wServerSettings, 131072);
        wlProxyType.setText(BaseMessages.getString(PKG, (String)"ActionSftpPut.ProxyType.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlProxyType);
        FormData fdlProxyType = new FormData();
        fdlProxyType.left = new FormAttachment(0, 0);
        fdlProxyType.right = new FormAttachment(middle, -margin);
        fdlProxyType.top = new FormAttachment((Control)this.wKeyFilePass, 2 * margin);
        wlProxyType.setLayoutData((Object)fdlProxyType);
        this.wProxyType = new CCombo((Composite)wServerSettings, 2060);
        this.wProxyType.add("HTTP");
        this.wProxyType.add("SOCKS5");
        this.wProxyType.select(0);
        PropsUi.setLook((Widget)this.wProxyType);
        FormData fdProxyType = new FormData();
        fdProxyType.left = new FormAttachment(middle, 0);
        fdProxyType.top = new FormAttachment((Control)this.wKeyFilePass, 2 * margin);
        fdProxyType.right = new FormAttachment(100, 0);
        this.wProxyType.setLayoutData((Object)fdProxyType);
        this.wProxyType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionSftpPutDialog.this.setDefaultProxyPort();
            }
        });
        this.wProxyHost = new LabelTextVar(this.variables, (Composite)wServerSettings, 0, BaseMessages.getString(PKG, (String)"ActionSftpPut.ProxyHost.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSftpPut.ProxyHost.Tooltip", (String[])new String[0]), false, false);
        PropsUi.setLook((Widget)this.wProxyHost);
        this.wProxyHost.addModifyListener(lsMod);
        FormData fdProxyHost = new FormData();
        fdProxyHost.left = new FormAttachment(0, 0);
        fdProxyHost.top = new FormAttachment((Control)this.wProxyType, margin);
        fdProxyHost.right = new FormAttachment(100, 0);
        this.wProxyHost.setLayoutData((Object)fdProxyHost);
        this.wProxyPort = new LabelTextVar(this.variables, (Composite)wServerSettings, 0, BaseMessages.getString(PKG, (String)"ActionSftpPut.ProxyPort.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSftpPut.ProxyPort.Tooltip", (String[])new String[0]), false, false);
        PropsUi.setLook((Widget)this.wProxyPort);
        this.wProxyPort.addModifyListener(lsMod);
        FormData fdProxyPort = new FormData();
        fdProxyPort.left = new FormAttachment(0, 0);
        fdProxyPort.top = new FormAttachment((Control)this.wProxyHost, margin);
        fdProxyPort.right = new FormAttachment(100, 0);
        this.wProxyPort.setLayoutData((Object)fdProxyPort);
        this.wProxyUsername = new LabelTextVar(this.variables, (Composite)wServerSettings, 0, BaseMessages.getString(PKG, (String)"ActionSftpPut.ProxyUsername.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSftpPut.ProxyUsername.Tooltip", (String[])new String[0]), false, false);
        PropsUi.setLook((Widget)this.wProxyUsername);
        this.wProxyUsername.addModifyListener(lsMod);
        FormData fdProxyUsername = new FormData();
        fdProxyUsername.left = new FormAttachment(0, 0);
        fdProxyUsername.top = new FormAttachment((Control)this.wProxyPort, margin);
        fdProxyUsername.right = new FormAttachment(100, 0);
        this.wProxyUsername.setLayoutData((Object)fdProxyUsername);
        this.wProxyPassword = new LabelTextVar(this.variables, (Composite)wServerSettings, 0, BaseMessages.getString(PKG, (String)"ActionSftpPut.ProxyPassword.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSftpPut.ProxyPassword.Tooltip", (String[])new String[0]), true, false);
        PropsUi.setLook((Widget)this.wProxyPassword);
        this.wProxyPassword.addModifyListener(lsMod);
        FormData fdProxyPasswd = new FormData();
        fdProxyPasswd.left = new FormAttachment(0, 0);
        fdProxyPasswd.top = new FormAttachment((Control)this.wProxyUsername, margin);
        fdProxyPasswd.right = new FormAttachment(100, 0);
        this.wProxyPassword.setLayoutData((Object)fdProxyPasswd);
        Button wTest = new Button((Composite)wServerSettings, 8);
        wTest.setText(BaseMessages.getString(PKG, (String)"ActionSftpPut.TestConnection.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wTest);
        FormData fdTest = new FormData();
        wTest.setToolTipText(BaseMessages.getString(PKG, (String)"ActionSftpPut.TestConnection.Tooltip", (String[])new String[0]));
        fdTest.top = new FormAttachment((Control)this.wProxyPassword, margin);
        fdTest.right = new FormAttachment(100, 0);
        wTest.setLayoutData((Object)fdTest);
        wTest.addListener(13, e -> this.test());
        FormData fdServerSettings = new FormData();
        fdServerSettings.left = new FormAttachment(0, margin);
        fdServerSettings.top = new FormAttachment((Control)this.wName, margin);
        fdServerSettings.right = new FormAttachment(100, -margin);
        wServerSettings.setLayoutData((Object)fdServerSettings);
        Label wlCompression = new Label(wGeneralComp, 131072);
        wlCompression.setText(BaseMessages.getString(PKG, (String)"ActionSftpPut.Compression.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCompression);
        FormData fdlCompression = new FormData();
        fdlCompression.left = new FormAttachment(0, -margin);
        fdlCompression.right = new FormAttachment(middle, 0);
        fdlCompression.top = new FormAttachment((Control)wServerSettings, margin);
        wlCompression.setLayoutData((Object)fdlCompression);
        this.wCompression = new CCombo(wGeneralComp, 2060);
        this.wCompression.add("none");
        this.wCompression.add("zlib");
        this.wCompression.select(0);
        PropsUi.setLook((Widget)this.wCompression);
        FormData fdCompression = new FormData();
        fdCompression.left = new FormAttachment(middle, margin);
        fdCompression.top = new FormAttachment((Control)wServerSettings, margin);
        fdCompression.right = new FormAttachment(100, 0);
        this.wCompression.setLayoutData((Object)fdCompression);
        FormData fdGeneralComp = new FormData();
        fdGeneralComp.left = new FormAttachment(0, 0);
        fdGeneralComp.top = new FormAttachment(0, 0);
        fdGeneralComp.right = new FormAttachment(100, 0);
        fdGeneralComp.bottom = new FormAttachment(100, 0);
        wGeneralComp.setLayoutData((Object)fdGeneralComp);
        wGeneralComp.layout();
        wGeneralTab.setControl((Control)wGeneralComp);
        PropsUi.setLook((Widget)wGeneralComp);
        CTabItem wFilesTab = new CTabItem(wTabFolder, 0);
        wFilesTab.setFont(GuiResource.getInstance().getFontDefault());
        wFilesTab.setText(BaseMessages.getString(PKG, (String)"ActionSftpPut.Tab.Files.Label", (String[])new String[0]));
        Composite wFilesComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wFilesComp);
        FormLayout filesLayout = new FormLayout();
        filesLayout.marginWidth = 3;
        filesLayout.marginHeight = 3;
        wFilesComp.setLayout((Layout)filesLayout);
        Group wgSourceFiles = new Group(wFilesComp, 32);
        PropsUi.setLook((Widget)wgSourceFiles);
        wgSourceFiles.setText(BaseMessages.getString(PKG, (String)"ActionSftpPut.SourceFiles.Group.Label", (String[])new String[0]));
        FormLayout sourceFilesGroupLayout = new FormLayout();
        sourceFilesGroupLayout.marginWidth = 10;
        sourceFilesGroupLayout.marginHeight = 10;
        wgSourceFiles.setLayout((Layout)sourceFilesGroupLayout);
        Label wlGetPrevious = new Label((Composite)wgSourceFiles, 131072);
        wlGetPrevious.setText(BaseMessages.getString(PKG, (String)"ActionSftpPut.getPrevious.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlGetPrevious);
        FormData fdlGetPrevious = new FormData();
        fdlGetPrevious.left = new FormAttachment(0, 0);
        fdlGetPrevious.top = new FormAttachment(0, margin);
        fdlGetPrevious.right = new FormAttachment(middle, -margin);
        wlGetPrevious.setLayoutData((Object)fdlGetPrevious);
        this.wGetPrevious = new Button((Composite)wgSourceFiles, 32);
        PropsUi.setLook((Widget)this.wGetPrevious);
        this.wGetPrevious.setToolTipText(BaseMessages.getString(PKG, (String)"ActionSftpPut.getPrevious.Tooltip", (String[])new String[0]));
        FormData fdGetPrevious = new FormData();
        fdGetPrevious.left = new FormAttachment(middle, 0);
        fdGetPrevious.top = new FormAttachment((Control)wlGetPrevious, 0, 0x1000000);
        fdGetPrevious.right = new FormAttachment(100, 0);
        this.wGetPrevious.setLayoutData((Object)fdGetPrevious);
        this.wGetPrevious.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ActionSftpPutDialog.this.wGetPrevious.getSelection()) {
                    ActionSftpPutDialog.this.wGetPreviousFiles.setSelection(false);
                }
                ActionSftpPutDialog.this.activeCopyFromPrevious();
                ActionSftpPutDialog.this.action.setChanged();
            }
        });
        Label wlGetPreviousFiles = new Label((Composite)wgSourceFiles, 131072);
        wlGetPreviousFiles.setText(BaseMessages.getString(PKG, (String)"ActionSftpPut.getPreviousFiles.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlGetPreviousFiles);
        FormData fdlGetPreviousFiles = new FormData();
        fdlGetPreviousFiles.left = new FormAttachment(0, 0);
        fdlGetPreviousFiles.top = new FormAttachment((Control)wlGetPrevious, 2 * margin);
        fdlGetPreviousFiles.right = new FormAttachment(middle, -margin);
        wlGetPreviousFiles.setLayoutData((Object)fdlGetPreviousFiles);
        this.wGetPreviousFiles = new Button((Composite)wgSourceFiles, 32);
        PropsUi.setLook((Widget)this.wGetPreviousFiles);
        this.wGetPreviousFiles.setToolTipText(BaseMessages.getString(PKG, (String)"ActionSftpPut.getPreviousFiles.Tooltip", (String[])new String[0]));
        FormData fdGetPreviousFiles = new FormData();
        fdGetPreviousFiles.left = new FormAttachment(middle, 0);
        fdGetPreviousFiles.top = new FormAttachment((Control)wlGetPreviousFiles, 0, 0x1000000);
        fdGetPreviousFiles.right = new FormAttachment(100, 0);
        this.wGetPreviousFiles.setLayoutData((Object)fdGetPreviousFiles);
        this.wGetPreviousFiles.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ActionSftpPutDialog.this.wGetPreviousFiles.getSelection()) {
                    ActionSftpPutDialog.this.wGetPrevious.setSelection(false);
                }
                ActionSftpPutDialog.this.activeCopyFromPrevious();
                ActionSftpPutDialog.this.action.setChanged();
            }
        });
        this.wlLocalDirectory = new Label((Composite)wgSourceFiles, 131072);
        this.wlLocalDirectory.setText(BaseMessages.getString(PKG, (String)"ActionSftpPut.LocalDir.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlLocalDirectory);
        FormData fdlLocalDirectory = new FormData();
        fdlLocalDirectory.left = new FormAttachment(0, 0);
        fdlLocalDirectory.top = new FormAttachment((Control)wlGetPreviousFiles, 2 * margin);
        fdlLocalDirectory.right = new FormAttachment(middle, -margin);
        this.wlLocalDirectory.setLayoutData((Object)fdlLocalDirectory);
        this.wbLocalDirectory = new Button((Composite)wgSourceFiles, 0x1000008);
        PropsUi.setLook((Widget)this.wbLocalDirectory);
        this.wbLocalDirectory.setText(BaseMessages.getString(PKG, (String)"ActionSftpPut.BrowseFolders.Label", (String[])new String[0]));
        FormData fdbLocalDirectory = new FormData();
        fdbLocalDirectory.right = new FormAttachment(100, 0);
        fdbLocalDirectory.top = new FormAttachment((Control)this.wlLocalDirectory, 0, 0x1000000);
        this.wbLocalDirectory.setLayoutData((Object)fdbLocalDirectory);
        this.wbLocalDirectory.addListener(13, e -> BaseDialog.presentDirectoryDialog((Shell)this.shell, (TextVar)this.wLocalDirectory, (IVariables)this.variables));
        this.wLocalDirectory = new TextVar(this.variables, (Composite)wgSourceFiles, 18436);
        PropsUi.setLook((Widget)this.wLocalDirectory);
        this.wLocalDirectory.setToolTipText(BaseMessages.getString(PKG, (String)"ActionSftpPut.LocalDir.Tooltip", (String[])new String[0]));
        this.wLocalDirectory.addModifyListener(lsMod);
        FormData fdLocalDirectory = new FormData();
        fdLocalDirectory.left = new FormAttachment(middle, 0);
        fdLocalDirectory.top = new FormAttachment((Control)this.wlLocalDirectory, 0, 0x1000000);
        fdLocalDirectory.right = new FormAttachment((Control)this.wbLocalDirectory, -margin);
        this.wLocalDirectory.setLayoutData((Object)fdLocalDirectory);
        this.wlWildcard = new Label((Composite)wgSourceFiles, 131072);
        this.wlWildcard.setText(BaseMessages.getString(PKG, (String)"ActionSftpPut.Wildcard.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlWildcard);
        FormData fdlWildcard = new FormData();
        fdlWildcard.left = new FormAttachment(0, 0);
        fdlWildcard.top = new FormAttachment((Control)this.wbLocalDirectory, margin);
        fdlWildcard.right = new FormAttachment(middle, -margin);
        this.wlWildcard.setLayoutData((Object)fdlWildcard);
        this.wWildcard = new TextVar(this.variables, (Composite)wgSourceFiles, 18436);
        PropsUi.setLook((Widget)this.wWildcard);
        this.wWildcard.setToolTipText(BaseMessages.getString(PKG, (String)"ActionSftpPut.Wildcard.Tooltip", (String[])new String[0]));
        this.wWildcard.addModifyListener(lsMod);
        FormData fdWildcard = new FormData();
        fdWildcard.left = new FormAttachment(middle, 0);
        fdWildcard.top = new FormAttachment((Control)this.wbLocalDirectory, margin);
        fdWildcard.right = new FormAttachment(100, 0);
        this.wWildcard.setLayoutData((Object)fdWildcard);
        Label wlSuccessWhenNoFile = new Label((Composite)wgSourceFiles, 131072);
        wlSuccessWhenNoFile.setText(BaseMessages.getString(PKG, (String)"ActionSftpPut.SuccessWhenNoFile.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSuccessWhenNoFile);
        FormData fdlSuccessWhenNoFile = new FormData();
        fdlSuccessWhenNoFile.left = new FormAttachment(0, 0);
        fdlSuccessWhenNoFile.top = new FormAttachment((Control)this.wWildcard, margin);
        fdlSuccessWhenNoFile.right = new FormAttachment(middle, -margin);
        wlSuccessWhenNoFile.setLayoutData((Object)fdlSuccessWhenNoFile);
        this.wSuccessWhenNoFile = new Button((Composite)wgSourceFiles, 32);
        PropsUi.setLook((Widget)this.wSuccessWhenNoFile);
        this.wSuccessWhenNoFile.setToolTipText(BaseMessages.getString(PKG, (String)"ActionSftpPut.SuccessWhenNoFile.Tooltip", (String[])new String[0]));
        FormData fdSuccessWhenNoFile = new FormData();
        fdSuccessWhenNoFile.left = new FormAttachment(middle, 0);
        fdSuccessWhenNoFile.top = new FormAttachment((Control)wlSuccessWhenNoFile, 0, 0x1000000);
        fdSuccessWhenNoFile.right = new FormAttachment(100, 0);
        this.wSuccessWhenNoFile.setLayoutData((Object)fdSuccessWhenNoFile);
        this.wSuccessWhenNoFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionSftpPutDialog.this.action.setChanged();
            }
        });
        Label wlAfterFtpPut = new Label((Composite)wgSourceFiles, 131072);
        wlAfterFtpPut.setText(BaseMessages.getString(PKG, (String)"ActionSftpPut.AfterFTPPut.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlAfterFtpPut);
        FormData fdlAfterFtpPut = new FormData();
        fdlAfterFtpPut.left = new FormAttachment(0, 0);
        fdlAfterFtpPut.right = new FormAttachment(middle, -margin);
        fdlAfterFtpPut.top = new FormAttachment((Control)wlSuccessWhenNoFile, 2 * margin);
        wlAfterFtpPut.setLayoutData((Object)fdlAfterFtpPut);
        this.wAfterFtpPut = new CCombo((Composite)wgSourceFiles, 2060);
        this.wAfterFtpPut.add(BaseMessages.getString(PKG, (String)"ActionSftpPut.AfterSFTP.DoNothing.Label", (String[])new String[0]));
        this.wAfterFtpPut.add(BaseMessages.getString(PKG, (String)"ActionSftpPut.AfterSFTP.Delete.Label", (String[])new String[0]));
        this.wAfterFtpPut.add(BaseMessages.getString(PKG, (String)"ActionSftpPut.AfterSFTP.Move.Label", (String[])new String[0]));
        this.wAfterFtpPut.select(0);
        PropsUi.setLook((Widget)this.wAfterFtpPut);
        FormData fdAfterFtpPut = new FormData();
        fdAfterFtpPut.left = new FormAttachment(middle, 0);
        fdAfterFtpPut.top = new FormAttachment((Control)this.wSuccessWhenNoFile, 2 * margin);
        fdAfterFtpPut.right = new FormAttachment(100, -margin);
        this.wAfterFtpPut.setLayoutData((Object)fdAfterFtpPut);
        this.wAfterFtpPut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionSftpPutDialog.this.afterFtpPutActivate();
            }
        });
        this.wlDestinationFolder = new Label((Composite)wgSourceFiles, 131072);
        this.wlDestinationFolder.setText(BaseMessages.getString(PKG, (String)"ActionSftpPut.DestinationFolder.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlDestinationFolder);
        FormData fdlDestinationFolder = new FormData();
        fdlDestinationFolder.left = new FormAttachment(0, 0);
        fdlDestinationFolder.top = new FormAttachment((Control)this.wAfterFtpPut, margin);
        fdlDestinationFolder.right = new FormAttachment(middle, -margin);
        this.wlDestinationFolder.setLayoutData((Object)fdlDestinationFolder);
        this.wbMovetoDirectory = new Button((Composite)wgSourceFiles, 0x1000008);
        PropsUi.setLook((Widget)this.wbMovetoDirectory);
        this.wbMovetoDirectory.setText(BaseMessages.getString(PKG, (String)"ActionSftpPut.BrowseFolders.Label", (String[])new String[0]));
        FormData fdbMovetoDirectory = new FormData();
        fdbMovetoDirectory.right = new FormAttachment(100, 0);
        fdbMovetoDirectory.top = new FormAttachment((Control)this.wAfterFtpPut, margin);
        this.wbMovetoDirectory.setLayoutData((Object)fdbMovetoDirectory);
        this.wbMovetoDirectory.addListener(13, e -> BaseDialog.presentDirectoryDialog((Shell)this.shell, (TextVar)this.wDestinationFolder, (IVariables)this.variables));
        this.wDestinationFolder = new TextVar(this.variables, (Composite)wgSourceFiles, 18436, BaseMessages.getString(PKG, (String)"ActionSftpPut.DestinationFolder.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wDestinationFolder);
        this.wDestinationFolder.addModifyListener(lsMod);
        FormData fdDestinationFolder = new FormData();
        fdDestinationFolder.left = new FormAttachment(middle, 0);
        fdDestinationFolder.top = new FormAttachment((Control)this.wAfterFtpPut, margin);
        fdDestinationFolder.right = new FormAttachment((Control)this.wbMovetoDirectory, -margin);
        this.wDestinationFolder.setLayoutData((Object)fdDestinationFolder);
        this.wDestinationFolder.addModifyListener(e -> this.wDestinationFolder.setToolTipText(this.variables.resolve(this.wDestinationFolder.getText())));
        this.wlCreateDestinationFolder = new Label((Composite)wgSourceFiles, 131072);
        this.wlCreateDestinationFolder.setText(BaseMessages.getString(PKG, (String)"ActionSftpPut.CreateDestinationFolder.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlCreateDestinationFolder);
        FormData fdlCreateDestinationFolder = new FormData();
        fdlCreateDestinationFolder.left = new FormAttachment(0, 0);
        fdlCreateDestinationFolder.top = new FormAttachment((Control)this.wDestinationFolder, margin);
        fdlCreateDestinationFolder.right = new FormAttachment(middle, -margin);
        this.wlCreateDestinationFolder.setLayoutData((Object)fdlCreateDestinationFolder);
        this.wCreateDestinationFolder = new Button((Composite)wgSourceFiles, 32);
        this.wCreateDestinationFolder.setToolTipText(BaseMessages.getString(PKG, (String)"ActionSftpPut.CreateDestinationFolder.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wCreateDestinationFolder);
        FormData fdCreateDestinationFolder = new FormData();
        fdCreateDestinationFolder.left = new FormAttachment(middle, 0);
        fdCreateDestinationFolder.top = new FormAttachment((Control)this.wlCreateDestinationFolder, 0, 0x1000000);
        fdCreateDestinationFolder.right = new FormAttachment(100, 0);
        this.wCreateDestinationFolder.setLayoutData((Object)fdCreateDestinationFolder);
        this.wlAddFilenameToResult = new Label((Composite)wgSourceFiles, 131072);
        this.wlAddFilenameToResult.setText(BaseMessages.getString(PKG, (String)"ActionSftpPut.AddfilenametoResult.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlAddFilenameToResult);
        FormData fdlAddFilenameToResult = new FormData();
        fdlAddFilenameToResult.left = new FormAttachment(0, 0);
        fdlAddFilenameToResult.top = new FormAttachment((Control)this.wlCreateDestinationFolder, 2 * margin);
        fdlAddFilenameToResult.right = new FormAttachment(middle, -margin);
        this.wlAddFilenameToResult.setLayoutData((Object)fdlAddFilenameToResult);
        this.wAddFilenameToResult = new Button((Composite)wgSourceFiles, 32);
        this.wAddFilenameToResult.setToolTipText(BaseMessages.getString(PKG, (String)"ActionSftpPut.AddfilenametoResult.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wAddFilenameToResult);
        FormData fdAddFilenameToResult = new FormData();
        fdAddFilenameToResult.left = new FormAttachment(middle, 0);
        fdAddFilenameToResult.top = new FormAttachment((Control)this.wlAddFilenameToResult, 0, 0x1000000);
        fdAddFilenameToResult.right = new FormAttachment(100, 0);
        this.wAddFilenameToResult.setLayoutData((Object)fdAddFilenameToResult);
        FormData fdSourceFiles = new FormData();
        fdSourceFiles.left = new FormAttachment(0, margin);
        fdSourceFiles.top = new FormAttachment((Control)wServerSettings, 2 * margin);
        fdSourceFiles.right = new FormAttachment(100, -margin);
        wgSourceFiles.setLayoutData((Object)fdSourceFiles);
        Group wTargetFiles = new Group(wFilesComp, 32);
        PropsUi.setLook((Widget)wTargetFiles);
        wTargetFiles.setText(BaseMessages.getString(PKG, (String)"ActionSftpPut.TargetFiles.Group.Label", (String[])new String[0]));
        FormLayout targetFilesgroupLayout = new FormLayout();
        targetFilesgroupLayout.marginWidth = 10;
        targetFilesgroupLayout.marginHeight = 10;
        wTargetFiles.setLayout((Layout)targetFilesgroupLayout);
        Label wlScpDirectory = new Label((Composite)wTargetFiles, 131072);
        wlScpDirectory.setText(BaseMessages.getString(PKG, (String)"ActionSftpPut.RemoteDir.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlScpDirectory);
        FormData fdlScpDirectory = new FormData();
        fdlScpDirectory.left = new FormAttachment(0, 0);
        fdlScpDirectory.top = new FormAttachment((Control)wgSourceFiles, margin);
        fdlScpDirectory.right = new FormAttachment(middle, -margin);
        wlScpDirectory.setLayoutData((Object)fdlScpDirectory);
        this.wbTestChangeFolderExists = new Button((Composite)wTargetFiles, 0x1000008);
        PropsUi.setLook((Widget)this.wbTestChangeFolderExists);
        this.wbTestChangeFolderExists.setText(BaseMessages.getString(PKG, (String)"ActionSftpPut.TestFolderExists.Label", (String[])new String[0]));
        FormData fdbTestChangeFolderExists = new FormData();
        fdbTestChangeFolderExists.right = new FormAttachment(100, 0);
        fdbTestChangeFolderExists.top = new FormAttachment((Control)wgSourceFiles, margin);
        this.wbTestChangeFolderExists.setLayoutData((Object)fdbTestChangeFolderExists);
        this.wbTestChangeFolderExists.addListener(13, e -> this.checkRemoteFolder());
        this.wScpDirectory = new TextVar(this.variables, (Composite)wTargetFiles, 18436);
        PropsUi.setLook((Widget)this.wScpDirectory);
        this.wScpDirectory.setToolTipText(BaseMessages.getString(PKG, (String)"ActionSftpPut.RemoteDir.Tooltip", (String[])new String[0]));
        this.wScpDirectory.addModifyListener(lsMod);
        FormData fdScpDirectory = new FormData();
        fdScpDirectory.left = new FormAttachment(middle, 0);
        fdScpDirectory.top = new FormAttachment((Control)wgSourceFiles, margin);
        fdScpDirectory.right = new FormAttachment((Control)this.wbTestChangeFolderExists, -margin);
        this.wScpDirectory.setLayoutData((Object)fdScpDirectory);
        Label wlCreateRemoteFolder = new Label((Composite)wTargetFiles, 131072);
        wlCreateRemoteFolder.setText(BaseMessages.getString(PKG, (String)"ActionSftpPut.CreateRemoteFolderFiles.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCreateRemoteFolder);
        FormData fdlCreateRemoteFolder = new FormData();
        fdlCreateRemoteFolder.left = new FormAttachment(0, 0);
        fdlCreateRemoteFolder.top = new FormAttachment((Control)this.wScpDirectory, margin);
        fdlCreateRemoteFolder.right = new FormAttachment(middle, -margin);
        wlCreateRemoteFolder.setLayoutData((Object)fdlCreateRemoteFolder);
        this.wCreateRemoteFolder = new Button((Composite)wTargetFiles, 32);
        PropsUi.setLook((Widget)this.wCreateRemoteFolder);
        FormData fdCreateRemoteFolder = new FormData();
        this.wCreateRemoteFolder.setToolTipText(BaseMessages.getString(PKG, (String)"ActionSftpPut.CreateRemoteFolderFiles.Tooltip", (String[])new String[0]));
        fdCreateRemoteFolder.left = new FormAttachment(middle, 0);
        fdCreateRemoteFolder.top = new FormAttachment((Control)wlCreateRemoteFolder, 0, 0x1000000);
        fdCreateRemoteFolder.right = new FormAttachment(100, 0);
        this.wCreateRemoteFolder.setLayoutData((Object)fdCreateRemoteFolder);
        this.wCreateRemoteFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionSftpPutDialog.this.action.setChanged();
            }
        });
        FormData fdTargetFiles = new FormData();
        fdTargetFiles.left = new FormAttachment(0, margin);
        fdTargetFiles.top = new FormAttachment((Control)wgSourceFiles, margin);
        fdTargetFiles.right = new FormAttachment(100, -margin);
        wTargetFiles.setLayoutData((Object)fdTargetFiles);
        FormData fdFilesComp = new FormData();
        fdFilesComp.left = new FormAttachment(0, 0);
        fdFilesComp.top = new FormAttachment(0, 0);
        fdFilesComp.right = new FormAttachment(100, 0);
        fdFilesComp.bottom = new FormAttachment(100, 0);
        wFilesComp.setLayoutData((Object)fdFilesComp);
        wFilesComp.layout();
        wFilesTab.setControl((Control)wFilesComp);
        PropsUi.setLook((Widget)wFilesComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)wOk, -2 * margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        wTabFolder.setSelection(0);
        this.getData();
        this.activeCopyFromPrevious();
        this.activeUseKey();
        this.afterFtpPutActivate();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    private void activeCopyFromPrevious() {
        boolean enabled = !this.wGetPrevious.getSelection() && !this.wGetPreviousFiles.getSelection();
        this.wLocalDirectory.setEnabled(enabled);
        this.wlLocalDirectory.setEnabled(enabled);
        this.wbLocalDirectory.setEnabled(enabled);
        this.wlWildcard.setEnabled(enabled);
        this.wWildcard.setEnabled(enabled);
        this.wbTestChangeFolderExists.setEnabled(enabled);
    }

    private void test() {
        if (this.connectToSftp(false, null)) {
            MessageBox mb = new MessageBox(this.shell, 34);
            mb.setMessage(BaseMessages.getString(PKG, (String)"ActionSftpPut.Connected.OK", (String[])new String[]{this.wServerName.getText()}) + Const.CR);
            mb.setText(BaseMessages.getString(PKG, (String)"ActionSftpPut.Connected.Title.Ok", (String[])new String[0]));
            mb.open();
        }
        this.quitSftp();
    }

    private void quitSftp() {
        if (this.sftpclient != null) {
            try {
                this.sftpclient.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeFtpConnections() {
        if (this.sftpclient != null) {
            try {
                this.sftpclient.disconnect();
                this.sftpclient = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean connectToSftp(boolean checkFolder, String remotefoldername) {
        boolean retval = false;
        try {
            if (this.sftpclient == null) {
                this.sftpclient = new SftpClient(InetAddress.getByName(this.variables.resolve(this.wServerName.getText())), Const.toInt((String)this.variables.resolve(this.wServerPort.getText()), (int)22), this.variables.resolve(this.wUserName.getText()), this.variables.resolve(this.wKeyFilename.getText()), this.variables.resolve(this.wKeyFilePass.getText()));
                String realProxyHost = this.variables.resolve(this.wProxyHost.getText());
                if (!Utils.isEmpty((CharSequence)realProxyHost)) {
                    this.sftpclient.setProxy(realProxyHost, this.variables.resolve(this.wProxyPort.getText()), this.variables.resolve(this.wProxyUsername.getText()), this.variables.resolve(this.wProxyPassword.getText()), this.wProxyType.getText());
                }
                this.sftpclient.login(Utils.resolvePassword((IVariables)this.variables, (String)this.wPassword.getText()));
                retval = true;
            }
            if (checkFolder) {
                retval = this.sftpclient.folderExists(remotefoldername);
            }
        }
        catch (Exception e) {
            if (this.sftpclient != null) {
                try {
                    this.sftpclient.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.sftpclient = null;
            }
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"ActionSftpPut.ErrorConnect.NOK", (String[])new String[]{this.wServerName.getText(), e.getMessage()}) + Const.CR);
            mb.setText(BaseMessages.getString(PKG, (String)"ActionSftpPut.ErrorConnect.Title.Bad", (String[])new String[0]));
            mb.open();
        }
        return retval;
    }

    private void checkRemoteFolder() {
        String changeFtpFolder = this.variables.resolve(this.wScpDirectory.getText());
        if (!Utils.isEmpty((CharSequence)changeFtpFolder) && this.connectToSftp(true, changeFtpFolder)) {
            MessageBox mb = new MessageBox(this.shell, 34);
            mb.setMessage(BaseMessages.getString(PKG, (String)"ActionSftpPut.FolderExists.OK", (String[])new String[]{changeFtpFolder}) + Const.CR);
            mb.setText(BaseMessages.getString(PKG, (String)"ActionSftpPut.FolderExists.Title.Ok", (String[])new String[0]));
            mb.open();
        }
    }

    public void dispose() {
        this.closeFtpConnections();
        super.dispose();
    }

    public void getData() {
        this.wName.setText(Const.nullToEmpty((String)this.action.getName()));
        this.wServerName.setText(Const.NVL((String)this.action.getServerName(), (String)""));
        this.wServerPort.setText(this.action.getServerPort());
        this.wUserName.setText(Const.NVL((String)this.action.getUserName(), (String)""));
        this.wPassword.setText(Const.NVL((String)this.action.getPassword(), (String)""));
        this.wScpDirectory.setText(Const.NVL((String)this.action.getScpDirectory(), (String)""));
        this.wLocalDirectory.setText(Const.NVL((String)this.action.getLocalDirectory(), (String)""));
        this.wWildcard.setText(Const.NVL((String)this.action.getWildcard(), (String)""));
        this.wGetPrevious.setSelection(this.action.isCopyPrevious());
        this.wGetPreviousFiles.setSelection(this.action.isCopyPreviousFiles());
        this.wAddFilenameToResult.setSelection(this.action.isAddFilenameResut());
        this.wUsePublicKey.setSelection(this.action.isUseKeyFile());
        this.wKeyFilename.setText(Const.NVL((String)this.action.getKeyFilename(), (String)""));
        this.wKeyFilePass.setText(Const.NVL((String)this.action.getKeyPassPhrase(), (String)""));
        this.wCompression.setText(Const.NVL((String)this.action.getCompression(), (String)"none"));
        this.wProxyType.setText(Const.NVL((String)this.action.getProxyType(), (String)""));
        this.wProxyHost.setText(Const.NVL((String)this.action.getProxyHost(), (String)""));
        this.wProxyPort.setText(Const.NVL((String)this.action.getProxyPort(), (String)""));
        this.wProxyUsername.setText(Const.NVL((String)this.action.getProxyUsername(), (String)""));
        this.wProxyPassword.setText(Const.NVL((String)this.action.getProxyPassword(), (String)""));
        this.wCreateRemoteFolder.setSelection(this.action.isCreateRemoteFolder());
        this.wAfterFtpPut.setText(ActionSftpPut.getAfterSftpPutDesc(this.action.getAfterFtps()));
        this.wDestinationFolder.setText(Const.NVL((String)this.action.getDestinationFolder(), (String)""));
        this.wCreateDestinationFolder.setSelection(this.action.isCreateDestinationFolder());
        this.wSuccessWhenNoFile.setSelection(this.action.isSuccessWhenNoFile());
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.action.setChanged(this.changed);
        this.action = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.TransformActionNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.action.setName(this.wName.getText());
        this.action.setServerName(this.wServerName.getText());
        this.action.setServerPort(this.wServerPort.getText());
        this.action.setUserName(this.wUserName.getText());
        this.action.setPassword(this.wPassword.getText());
        this.action.setScpDirectory(this.wScpDirectory.getText());
        this.action.setLocalDirectory(this.wLocalDirectory.getText());
        this.action.setWildcard(this.wWildcard.getText());
        this.action.setCopyPrevious(this.wGetPrevious.getSelection());
        this.action.setCopyPreviousFiles(this.wGetPreviousFiles.getSelection());
        this.action.setAddFilenameResut(this.wAddFilenameToResult.getSelection());
        this.action.setUseKeyFile(this.wUsePublicKey.getSelection());
        this.action.setKeyFilename(this.wKeyFilename.getText());
        this.action.setKeyPassPhrase(this.wKeyFilePass.getText());
        this.action.setCompression(this.wCompression.getText());
        this.action.setProxyType(this.wProxyType.getText());
        this.action.setProxyHost(this.wProxyHost.getText());
        this.action.setProxyPort(this.wProxyPort.getText());
        this.action.setProxyUsername(this.wProxyUsername.getText());
        this.action.setProxyPassword(this.wProxyPassword.getText());
        this.action.setCreateRemoteFolder(this.wCreateRemoteFolder.getSelection());
        this.action.setAfterFtps(ActionSftpPut.getAfterSftpPutByDesc(this.wAfterFtpPut.getText()));
        this.action.setCreateDestinationFolder(this.wCreateDestinationFolder.getSelection());
        this.action.setDestinationFolder(this.wDestinationFolder.getText());
        this.action.setSuccessWhenNoFile(this.wSuccessWhenNoFile.getSelection());
        this.dispose();
    }

    private void activeUseKey() {
        this.wlKeyFilename.setEnabled(this.wUsePublicKey.getSelection());
        this.wKeyFilename.setEnabled(this.wUsePublicKey.getSelection());
        this.wbKeyFilename.setEnabled(this.wUsePublicKey.getSelection());
        this.wKeyFilePass.setEnabled(this.wUsePublicKey.getSelection());
    }

    private void setDefaultProxyPort() {
        if (this.wProxyType.getText().equals("HTTP")) {
            if (Utils.isEmpty((CharSequence)this.wProxyPort.getText()) || !Utils.isEmpty((CharSequence)this.wProxyPort.getText()) && this.wProxyPort.getText().equals("1080")) {
                this.wProxyPort.setText("80");
            }
        } else if (Utils.isEmpty((CharSequence)this.wProxyPort.getText()) || !Utils.isEmpty((CharSequence)this.wProxyPort.getText()) && this.wProxyPort.getText().equals("80")) {
            this.wProxyPort.setText("1080");
        }
    }

    private void afterFtpPutActivate() {
        boolean moveFile = ActionSftpPut.getAfterSftpPutByDesc(this.wAfterFtpPut.getText()) == 2;
        boolean doNothing = ActionSftpPut.getAfterSftpPutByDesc(this.wAfterFtpPut.getText()) == 0;
        this.wlDestinationFolder.setEnabled(moveFile);
        this.wDestinationFolder.setEnabled(moveFile);
        this.wbMovetoDirectory.setEnabled(moveFile);
        this.wlCreateDestinationFolder.setEnabled(moveFile);
        this.wCreateDestinationFolder.setEnabled(moveFile);
        this.wlAddFilenameToResult.setEnabled(doNothing);
        this.wAddFilenameToResult.setEnabled(doNothing);
    }
}

