/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util.function;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.util.ExceptionUtils;

@FunctionalInterface
@PublicEvolving
public interface ThrowingRunnable<E extends Throwable> {
    public void run() throws E;

    public static Runnable unchecked(ThrowingRunnable<?> throwingRunnable) {
        return () -> {
            try {
                throwingRunnable.run();
            }
            catch (Throwable t) {
                ExceptionUtils.rethrow(t);
            }
        };
    }
}

