/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util.concurrent;

import java.time.Duration;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.RetryStrategy;

public class IncrementalDelayRetryStrategy
implements RetryStrategy {
    private final int remainingRetries;
    private final Duration currentRetryDelay;
    private final Duration increment;
    private final Duration maxRetryDelay;

    public IncrementalDelayRetryStrategy(int remainingRetries, Duration currentRetryDelay, Duration increment, Duration maxRetryDelay) {
        Preconditions.checkArgument(remainingRetries >= 0, "The number of retries must be greater or equal to 0.");
        this.remainingRetries = remainingRetries;
        Preconditions.checkArgument(currentRetryDelay.toMillis() >= 0L, "The currentRetryDelay must be positive");
        this.currentRetryDelay = currentRetryDelay;
        Preconditions.checkArgument(increment.toMillis() >= 0L, "The delay increment must be greater or equal to 0.");
        this.increment = increment;
        Preconditions.checkArgument(maxRetryDelay.toMillis() >= 0L, "The maxRetryDelay must be positive");
        this.maxRetryDelay = maxRetryDelay;
    }

    @Override
    public int getNumRemainingRetries() {
        return this.remainingRetries;
    }

    @Override
    public Duration getRetryDelay() {
        return this.currentRetryDelay;
    }

    @Override
    public RetryStrategy getNextRetryStrategy() {
        int nextRemainingRetries = this.remainingRetries - 1;
        Preconditions.checkState(nextRemainingRetries >= 0, "The number of remaining retries must not be negative");
        long nextRetryDelayMillis = Math.min(this.currentRetryDelay.plus(this.increment).toMillis(), this.maxRetryDelay.toMillis());
        return new IncrementalDelayRetryStrategy(nextRemainingRetries, Duration.ofMillis(nextRetryDelayMillis), this.increment, this.maxRetryDelay);
    }
}

