/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.time.Duration;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;

public class SlowTaskDetectorOptions {
    @Documentation.Section(value={"expert_scheduling"})
    public static final ConfigOption<Duration> CHECK_INTERVAL = ConfigOptions.key("slow-task-detector.check-interval").durationType().defaultValue(Duration.ofSeconds(1L)).withDescription("The interval to check slow tasks.");
    @Documentation.Section(value={"expert_scheduling"})
    public static final ConfigOption<Duration> EXECUTION_TIME_BASELINE_LOWER_BOUND = ConfigOptions.key("slow-task-detector.execution-time.baseline-lower-bound").durationType().defaultValue(Duration.ofMinutes(1L)).withDescription("The lower bound of slow task detection baseline.");
    @Documentation.Section(value={"expert_scheduling"})
    public static final ConfigOption<Double> EXECUTION_TIME_BASELINE_RATIO = ConfigOptions.key("slow-task-detector.execution-time.baseline-ratio").doubleType().defaultValue(0.75).withDescription("The finished execution ratio threshold to calculate the slow tasks detection baseline. Given that the parallelism is N and the ratio is R, define T as the median of the first N*R finished tasks' execution time. The baseline will be T*M, where M is the multiplier of the baseline. Note that the execution time will be weighted with the task's input bytes to ensure the accuracy of the detection if data skew occurs.");
    @Documentation.Section(value={"expert_scheduling"})
    public static final ConfigOption<Double> EXECUTION_TIME_BASELINE_MULTIPLIER = ConfigOptions.key("slow-task-detector.execution-time.baseline-multiplier").doubleType().defaultValue(1.5).withDescription("The multiplier to calculate the slow tasks detection baseline. Given that the parallelism is N and the ratio is R, define T as the median of the first N*R finished tasks' execution time. The baseline will be T*M, where M is the multiplier of the baseline. Note that the execution time will be weighted with the task's input bytes to ensure the accuracy of the detection if data skew occurs.");

    private SlowTaskDetectorOptions() {
        throw new IllegalAccessError();
    }
}

