/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.EitherSerializer;
import org.apache.flink.types.Either;
import org.apache.flink.util.Preconditions;

@Public
public class EitherTypeInfo<L, R>
extends TypeInformation<Either<L, R>> {
    private static final long serialVersionUID = 1L;
    private final TypeInformation<L> leftType;
    private final TypeInformation<R> rightType;

    @PublicEvolving
    public EitherTypeInfo(TypeInformation<L> leftType, TypeInformation<R> rightType) {
        this.leftType = Preconditions.checkNotNull(leftType);
        this.rightType = Preconditions.checkNotNull(rightType);
    }

    @Override
    @PublicEvolving
    public boolean isBasicType() {
        return false;
    }

    @Override
    @PublicEvolving
    public boolean isTupleType() {
        return false;
    }

    @Override
    @PublicEvolving
    public int getArity() {
        return 1;
    }

    @Override
    @PublicEvolving
    public int getTotalFields() {
        return 1;
    }

    @Override
    @PublicEvolving
    public Class<Either<L, R>> getTypeClass() {
        return Either.class;
    }

    @Override
    @PublicEvolving
    public Map<String, TypeInformation<?>> getGenericParameters() {
        HashMap m = new HashMap();
        m.put("L", this.leftType);
        m.put("R", this.rightType);
        return m;
    }

    @Override
    @PublicEvolving
    public boolean isKeyType() {
        return false;
    }

    @Override
    @PublicEvolving
    public TypeSerializer<Either<L, R>> createSerializer(SerializerConfig config) {
        return new EitherSerializer<L, R>(this.leftType.createSerializer(config), this.rightType.createSerializer(config));
    }

    @Override
    @Deprecated
    @PublicEvolving
    public TypeSerializer<Either<L, R>> createSerializer(ExecutionConfig config) {
        return this.createSerializer(config.getSerializerConfig());
    }

    @Override
    public String toString() {
        return "Either <" + this.leftType.toString() + ", " + this.rightType.toString() + ">";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof EitherTypeInfo) {
            EitherTypeInfo other = (EitherTypeInfo)obj;
            return other.canEqual(this) && this.leftType.equals(other.leftType) && this.rightType.equals(other.rightType);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 17 * this.leftType.hashCode() + this.rightType.hashCode();
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof EitherTypeInfo;
    }

    public TypeInformation<L> getLeftType() {
        return this.leftType;
    }

    public TypeInformation<R> getRightType() {
        return this.rightType;
    }
}

