/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.state;

import java.io.Serializable;
import java.time.Duration;
import java.util.EnumMap;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class StateTtlConfig
implements Serializable {
    private static final long serialVersionUID = -7592693245044289793L;
    public static final StateTtlConfig DISABLED = StateTtlConfig.newBuilder(Duration.ofMillis(Long.MAX_VALUE)).setUpdateType(UpdateType.Disabled).build();
    private final UpdateType updateType;
    private final StateVisibility stateVisibility;
    private final TtlTimeCharacteristic ttlTimeCharacteristic;
    private final Duration ttl;
    private final CleanupStrategies cleanupStrategies;

    private StateTtlConfig(UpdateType updateType, StateVisibility stateVisibility, TtlTimeCharacteristic ttlTimeCharacteristic, Duration ttl, CleanupStrategies cleanupStrategies) {
        this.updateType = Preconditions.checkNotNull(updateType);
        this.stateVisibility = Preconditions.checkNotNull(stateVisibility);
        this.ttlTimeCharacteristic = Preconditions.checkNotNull(ttlTimeCharacteristic);
        this.ttl = Preconditions.checkNotNull(ttl);
        this.cleanupStrategies = cleanupStrategies;
        Preconditions.checkArgument(ttl.toMillis() > 0L, "TTL is expected to be positive.");
    }

    @Nonnull
    public UpdateType getUpdateType() {
        return this.updateType;
    }

    @Nonnull
    public StateVisibility getStateVisibility() {
        return this.stateVisibility;
    }

    @Deprecated
    @Nonnull
    public Time getTtl() {
        return Time.fromDuration(this.getTimeToLive());
    }

    public Duration getTimeToLive() {
        return this.ttl;
    }

    @Nonnull
    public TtlTimeCharacteristic getTtlTimeCharacteristic() {
        return this.ttlTimeCharacteristic;
    }

    public boolean isEnabled() {
        return this.updateType != UpdateType.Disabled;
    }

    @Nonnull
    public CleanupStrategies getCleanupStrategies() {
        return this.cleanupStrategies;
    }

    public String toString() {
        return "StateTtlConfig{updateType=" + (Object)((Object)this.updateType) + ", stateVisibility=" + (Object)((Object)this.stateVisibility) + ", ttlTimeCharacteristic=" + (Object)((Object)this.ttlTimeCharacteristic) + ", ttl=" + this.ttl + '}';
    }

    @Deprecated
    @Nonnull
    public static Builder newBuilder(@Nonnull Time ttl) {
        return new Builder(ttl);
    }

    public static Builder newBuilder(Duration ttl) {
        return new Builder(ttl);
    }

    @PublicEvolving
    public static class RocksdbCompactFilterCleanupStrategy
    implements CleanupStrategies.CleanupStrategy {
        private static final long serialVersionUID = 3109278796506988980L;
        static final Duration DEFAULT_PERIODIC_COMPACTION_TIME = Duration.ofDays(30L);
        static final RocksdbCompactFilterCleanupStrategy DEFAULT_ROCKSDB_COMPACT_FILTER_CLEANUP_STRATEGY = new RocksdbCompactFilterCleanupStrategy(1000L);
        private final long queryTimeAfterNumEntries;
        private final Duration periodicCompactionTime;

        private RocksdbCompactFilterCleanupStrategy(long queryTimeAfterNumEntries) {
            this(queryTimeAfterNumEntries, DEFAULT_PERIODIC_COMPACTION_TIME);
        }

        private RocksdbCompactFilterCleanupStrategy(long queryTimeAfterNumEntries, Duration periodicCompactionTime) {
            this.queryTimeAfterNumEntries = queryTimeAfterNumEntries;
            this.periodicCompactionTime = periodicCompactionTime;
        }

        public long getQueryTimeAfterNumEntries() {
            return this.queryTimeAfterNumEntries;
        }

        public Duration getPeriodicCompactionTime() {
            return this.periodicCompactionTime;
        }
    }

    @PublicEvolving
    public static class IncrementalCleanupStrategy
    implements CleanupStrategies.CleanupStrategy {
        private static final long serialVersionUID = 3109278696501988780L;
        static final IncrementalCleanupStrategy DEFAULT_INCREMENTAL_CLEANUP_STRATEGY = new IncrementalCleanupStrategy(5, false);
        private final int cleanupSize;
        private final boolean runCleanupForEveryRecord;

        private IncrementalCleanupStrategy(int cleanupSize, boolean runCleanupForEveryRecord) {
            Preconditions.checkArgument(cleanupSize > 0, "Number of incrementally cleaned up state entries should be positive.");
            this.cleanupSize = cleanupSize;
            this.runCleanupForEveryRecord = runCleanupForEveryRecord;
        }

        public int getCleanupSize() {
            return this.cleanupSize;
        }

        public boolean runCleanupForEveryRecord() {
            return this.runCleanupForEveryRecord;
        }
    }

    @PublicEvolving
    public static class CleanupStrategies
    implements Serializable {
        private static final long serialVersionUID = -1617740467277313524L;
        static final CleanupStrategy EMPTY_STRATEGY = new EmptyCleanupStrategy();
        private final boolean isCleanupInBackground;
        private final EnumMap<Strategies, CleanupStrategy> strategies;

        private CleanupStrategies(EnumMap<Strategies, CleanupStrategy> strategies, boolean isCleanupInBackground) {
            this.strategies = strategies;
            this.isCleanupInBackground = isCleanupInBackground;
        }

        public boolean inFullSnapshot() {
            return this.strategies.containsKey((Object)Strategies.FULL_STATE_SCAN_SNAPSHOT);
        }

        public boolean isCleanupInBackground() {
            return this.isCleanupInBackground;
        }

        @Nullable
        public IncrementalCleanupStrategy getIncrementalCleanupStrategy() {
            IncrementalCleanupStrategy defaultStrategy = this.isCleanupInBackground ? IncrementalCleanupStrategy.DEFAULT_INCREMENTAL_CLEANUP_STRATEGY : null;
            return (IncrementalCleanupStrategy)this.strategies.getOrDefault((Object)Strategies.INCREMENTAL_CLEANUP, defaultStrategy);
        }

        public boolean inRocksdbCompactFilter() {
            return this.getRocksdbCompactFilterCleanupStrategy() != null;
        }

        @Nullable
        public RocksdbCompactFilterCleanupStrategy getRocksdbCompactFilterCleanupStrategy() {
            RocksdbCompactFilterCleanupStrategy defaultStrategy = this.isCleanupInBackground ? RocksdbCompactFilterCleanupStrategy.DEFAULT_ROCKSDB_COMPACT_FILTER_CLEANUP_STRATEGY : null;
            return (RocksdbCompactFilterCleanupStrategy)this.strategies.getOrDefault((Object)Strategies.ROCKSDB_COMPACTION_FILTER, defaultStrategy);
        }

        static class EmptyCleanupStrategy
        implements CleanupStrategy {
            private static final long serialVersionUID = 1373998465131443873L;

            EmptyCleanupStrategy() {
            }
        }

        static interface CleanupStrategy
        extends Serializable {
        }

        static enum Strategies {
            FULL_STATE_SCAN_SNAPSHOT,
            INCREMENTAL_CLEANUP,
            ROCKSDB_COMPACTION_FILTER;

        }
    }

    @PublicEvolving
    public static class Builder {
        private UpdateType updateType = UpdateType.OnCreateAndWrite;
        private StateVisibility stateVisibility = StateVisibility.NeverReturnExpired;
        private TtlTimeCharacteristic ttlTimeCharacteristic = TtlTimeCharacteristic.ProcessingTime;
        private Duration ttl;
        private boolean isCleanupInBackground = true;
        private final EnumMap<CleanupStrategies.Strategies, CleanupStrategies.CleanupStrategy> strategies = new EnumMap(CleanupStrategies.Strategies.class);

        @Deprecated
        public Builder(@Nonnull Time ttl) {
            this(Time.toDuration(ttl));
        }

        private Builder(Duration ttl) {
            this.ttl = ttl;
        }

        @Nonnull
        public Builder setUpdateType(UpdateType updateType) {
            this.updateType = updateType;
            return this;
        }

        @Nonnull
        public Builder updateTtlOnCreateAndWrite() {
            return this.setUpdateType(UpdateType.OnCreateAndWrite);
        }

        @Nonnull
        public Builder updateTtlOnReadAndWrite() {
            return this.setUpdateType(UpdateType.OnReadAndWrite);
        }

        @Nonnull
        public Builder setStateVisibility(@Nonnull StateVisibility stateVisibility) {
            this.stateVisibility = stateVisibility;
            return this;
        }

        @Nonnull
        public Builder returnExpiredIfNotCleanedUp() {
            return this.setStateVisibility(StateVisibility.ReturnExpiredIfNotCleanedUp);
        }

        @Nonnull
        public Builder neverReturnExpired() {
            return this.setStateVisibility(StateVisibility.NeverReturnExpired);
        }

        @Nonnull
        public Builder setTtlTimeCharacteristic(@Nonnull TtlTimeCharacteristic ttlTimeCharacteristic) {
            this.ttlTimeCharacteristic = ttlTimeCharacteristic;
            return this;
        }

        @Nonnull
        public Builder useProcessingTime() {
            return this.setTtlTimeCharacteristic(TtlTimeCharacteristic.ProcessingTime);
        }

        @Nonnull
        public Builder cleanupFullSnapshot() {
            this.strategies.put(CleanupStrategies.Strategies.FULL_STATE_SCAN_SNAPSHOT, CleanupStrategies.EMPTY_STRATEGY);
            return this;
        }

        @Nonnull
        public Builder cleanupIncrementally(@Nonnegative int cleanupSize, boolean runCleanupForEveryRecord) {
            this.strategies.put(CleanupStrategies.Strategies.INCREMENTAL_CLEANUP, new IncrementalCleanupStrategy(cleanupSize, runCleanupForEveryRecord));
            return this;
        }

        @Nonnull
        public Builder cleanupInRocksdbCompactFilter(long queryTimeAfterNumEntries) {
            this.strategies.put(CleanupStrategies.Strategies.ROCKSDB_COMPACTION_FILTER, new RocksdbCompactFilterCleanupStrategy(queryTimeAfterNumEntries));
            return this;
        }

        @Nonnull
        public Builder cleanupInRocksdbCompactFilter(long queryTimeAfterNumEntries, Duration periodicCompactionTime) {
            this.strategies.put(CleanupStrategies.Strategies.ROCKSDB_COMPACTION_FILTER, new RocksdbCompactFilterCleanupStrategy(queryTimeAfterNumEntries, periodicCompactionTime));
            return this;
        }

        @Nonnull
        public Builder disableCleanupInBackground() {
            this.isCleanupInBackground = false;
            return this;
        }

        @Deprecated
        @Nonnull
        public Builder setTtl(@Nonnull Time ttl) {
            return this.setTimeToLive(Time.toDuration(ttl));
        }

        public Builder setTimeToLive(Duration ttl) {
            this.ttl = Preconditions.checkNotNull(ttl);
            return this;
        }

        @Nonnull
        public StateTtlConfig build() {
            return new StateTtlConfig(this.updateType, this.stateVisibility, this.ttlTimeCharacteristic, this.ttl, new CleanupStrategies(this.strategies, this.isCleanupInBackground));
        }
    }

    @PublicEvolving
    public static enum TtlTimeCharacteristic {
        ProcessingTime;

    }

    @PublicEvolving
    public static enum StateVisibility {
        ReturnExpiredIfNotCleanedUp,
        NeverReturnExpired;

    }

    @PublicEvolving
    public static enum UpdateType {
        Disabled,
        OnCreateAndWrite,
        OnReadAndWrite;

    }
}

