/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io.compression;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorInputStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.io.compression.InflaterInputStreamFactory;

@Internal
public class ZStandardInputStreamFactory
implements InflaterInputStreamFactory<ZstdCompressorInputStream> {
    private static final ZStandardInputStreamFactory INSTANCE = new ZStandardInputStreamFactory();

    public static ZStandardInputStreamFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public ZstdCompressorInputStream create(InputStream in) throws IOException {
        return new ZstdCompressorInputStream(in);
    }

    @Override
    public Collection<String> getCommonFileExtensions() {
        return Collections.singleton("zst");
    }
}

