/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.constant;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.constant.ConstantField;
import org.apache.hop.pipeline.transforms.constant.ConstantMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ConstantDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = ConstantMeta.class;
    private static final String SYSTEM_COMBO_YES = "System.Combo.Yes";
    private TableView wFields;
    private final ConstantMeta input;

    public ConstantDialog(Shell parent, IVariables variables, ConstantMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ConstantDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.TransformName.Label", (String[])new String[0]));
        this.wlTransformName.setToolTipText(BaseMessages.getString(PKG, (String)"System.TransformName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label wlFields = new Label((Composite)this.shell, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"ConstantDialog.Fields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)this.wTransformName, margin);
        wlFields.setLayoutData((Object)fdlFields);
        int FieldsCols = 10;
        int FieldsRows = this.input.getFields().size();
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"ConstantDialog.Name.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ConstantDialog.Type.Column", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames()), new ColumnInfo(BaseMessages.getString(PKG, (String)"ConstantDialog.Format.Column", (String[])new String[0]), 5, 2), new ColumnInfo(BaseMessages.getString(PKG, (String)"ConstantDialog.Length.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ConstantDialog.Precision.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ConstantDialog.Currency.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ConstantDialog.Decimal.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ConstantDialog.Group.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ConstantDialog.Value.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ConstantDialog.Value.SetEmptyString", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)SYSTEM_COMBO_YES, (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0])})};
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, colinf, FieldsRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        this.lsResize = event -> {
            Point size = this.shell.getSize();
            this.wFields.setSize(size.x - 10, size.y - 50);
            this.wFields.table.setSize(size.x - 10, size.y - 50);
            this.wFields.redraw();
        };
        this.shell.addListener(11, this.lsResize);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        if (this.log.isDebug()) {
            this.logDebug("getting fields info...");
        }
        for (int i = 0; i < this.input.getFields().size(); ++i) {
            ConstantField field = this.input.fields.get(i);
            if (StringUtils.isEmpty((String)field.getFieldName())) continue;
            TableItem item = this.wFields.table.getItem(i);
            int col = 1;
            item.setText(col++, field.getFieldName());
            String type = field.getFieldType();
            String format = field.getFieldFormat();
            String length = field.getFieldLength() < 0 ? "" : "" + field.getFieldLength();
            String prec = field.getFieldPrecision() < 0 ? "" : "" + field.getFieldPrecision();
            String curr = field.getCurrency();
            String group = field.getGroup();
            String decim = field.getDecimal();
            String def = field.getValue();
            item.setText(col++, Const.NVL((String)type, (String)""));
            item.setText(col++, Const.NVL((String)format, (String)""));
            item.setText(col++, Const.NVL((String)length, (String)""));
            item.setText(col++, Const.NVL((String)prec, (String)""));
            item.setText(col++, Const.NVL((String)curr, (String)""));
            item.setText(col++, Const.NVL((String)decim, (String)""));
            item.setText(col++, Const.NVL((String)group, (String)""));
            item.setText(col++, Const.NVL((String)def, (String)""));
            item.setText(col, field.isEmptyString() ? BaseMessages.getString(PKG, (String)SYSTEM_COMBO_YES, (String[])new String[0]) : BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]));
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        int nrFields = this.wFields.nrNonEmpty();
        List<ConstantField> fields = this.input.getFields();
        fields.clear();
        for (int i = 0; i < nrFields; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            boolean isEmptyStringFlag = BaseMessages.getString(PKG, (String)SYSTEM_COMBO_YES, (String[])new String[0]).equalsIgnoreCase(item.getText(10));
            ConstantField field = isEmptyStringFlag ? new ConstantField(item.getText(1), isEmptyStringFlag ? "String" : item.getText(2), isEmptyStringFlag) : new ConstantField(item.getText(1), isEmptyStringFlag ? "String" : item.getText(2), isEmptyStringFlag ? "" : item.getText(9));
            field.setFieldFormat(item.getText(3));
            String slength = item.getText(4);
            String sprec = item.getText(5);
            field.setCurrency(item.getText(6));
            field.setDecimal(item.getText(7));
            field.setGroup(item.getText(8));
            try {
                field.setFieldLength(Integer.parseInt(slength));
            }
            catch (Exception e) {
                field.setFieldLength(-1);
            }
            try {
                field.setFieldPrecision(Integer.parseInt(sprec));
            }
            catch (Exception e) {
                field.setFieldPrecision(-1);
            }
            fields.add(field);
        }
        this.dispose();
    }
}

