/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.stream;

import com.clickhouse.data.ClickHouseByteBuffer;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseDataConfig;
import com.clickhouse.data.ClickHouseDataUpdater;
import com.clickhouse.data.ClickHouseFile;
import com.clickhouse.data.ClickHouseOutputStream;
import com.clickhouse.data.stream.AbstractByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;

@Deprecated
public class RestrictedInputStream
extends AbstractByteArrayInputStream {
    private final InputStream in;
    private long length;

    @Override
    protected int updateBuffer() throws IOException {
        int read;
        this.position = 0;
        if (this.closed) {
            this.limit = 0;
            return 0;
        }
        int len = this.buffer.length;
        if (this.length < (long)len) {
            len = (int)this.length;
        }
        int off = 0;
        while (len > 0 && (read = this.in.read(this.buffer, off, len)) != -1) {
            off += read;
            len -= read;
        }
        if (this.copyTo != null) {
            this.copyTo.write(this.buffer, 0, off);
        }
        this.length -= (long)off;
        this.limit = off;
        return this.limit;
    }

    public RestrictedInputStream(ClickHouseFile file, InputStream input, int bufferSize, long length, Runnable postCloseAction) {
        super(file, null, postCloseAction);
        this.in = ClickHouseChecker.nonNull(input, "InputStream");
        this.buffer = new byte[ClickHouseDataConfig.getBufferSize(bufferSize)];
        this.length = ClickHouseChecker.notLessThan(length, "Length", 0L);
        this.position = 0;
        this.limit = 0;
    }

    @Override
    public ClickHouseByteBuffer readCustom(ClickHouseDataUpdater reader) throws IOException {
        if (reader == null) {
            return this.byteBuffer.reset();
        }
        this.ensureOpen();
        LinkedList<byte[]> list = new LinkedList<byte[]>();
        int offset = this.position;
        int len = 0;
        boolean more = true;
        while (more) {
            int remain = this.limit - this.position;
            if (remain < 1) {
                this.closeQuietly();
                more = false;
                continue;
            }
            int read = reader.update(this.buffer, this.position, this.limit);
            if (read == -1) {
                byte[] bytes = new byte[this.limit];
                System.arraycopy(this.buffer, this.position, bytes, this.position, remain);
                len += remain;
                this.position = this.limit;
                list.add(bytes);
                if (this.updateBuffer() >= 1) continue;
                this.closeQuietly();
                more = false;
                continue;
            }
            len += read;
            this.position += read;
            list.add(this.buffer);
            more = false;
        }
        return this.byteBuffer.update(list, offset, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long pipe(ClickHouseOutputStream output) throws IOException {
        long count = 0L;
        if (output == null || output.isClosed()) {
            return count;
        }
        this.ensureOpen();
        try {
            int l = this.limit;
            int p = this.position;
            int remain = l - p;
            if (remain > 0) {
                output.writeBytes(this.buffer, p, remain);
                count += (long)remain;
                this.position = l;
            }
            while ((remain = this.updateBuffer()) > 0) {
                output.writeBytes(this.buffer, 0, remain);
                count += (long)remain;
            }
        }
        finally {
            this.close();
        }
        return count;
    }

    public final long getRemaining() {
        return this.length;
    }
}

