/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.stream;

import com.clickhouse.data.ClickHouseByteBuffer;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseDataConfig;
import com.clickhouse.data.ClickHouseDataStreamFactory;
import com.clickhouse.data.ClickHouseDataUpdater;
import com.clickhouse.data.ClickHouseInputStream;
import com.clickhouse.data.ClickHouseOutputStream;
import com.clickhouse.data.ClickHousePipedOutputStream;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.data.ClickHouseWriter;
import com.clickhouse.data.stream.BlockingInputStream;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

@Deprecated
public class BlockingPipedOutputStream
extends ClickHousePipedOutputStream {
    protected final BlockingQueue<ByteBuffer> queue;
    private final int bufferSize;
    private final CompletableFuture<Void> future;
    private final long timeout;
    private ByteBuffer buffer;

    public BlockingPipedOutputStream(int bufferSize, int queueLength, long timeout) {
        this(bufferSize, queueLength, timeout, (Runnable)null);
    }

    public BlockingPipedOutputStream(int bufferSize, int queueLength, long timeout, Runnable postCloseAction) {
        super(postCloseAction);
        this.queue = queueLength <= 0 ? new LinkedBlockingQueue() : new ArrayBlockingQueue(queueLength);
        this.bufferSize = ClickHouseDataConfig.getBufferSize(bufferSize);
        this.future = ClickHouseUtils.NULL_FUTURE;
        this.timeout = timeout;
        this.buffer = ByteBuffer.allocate(this.bufferSize);
    }

    public BlockingPipedOutputStream(int bufferSize, int queueLength, long timeout, ClickHouseWriter writer) {
        super(null);
        this.queue = queueLength <= 0 ? new LinkedBlockingQueue() : new ArrayBlockingQueue(queueLength);
        this.bufferSize = ClickHouseDataConfig.getBufferSize(bufferSize);
        this.timeout = timeout;
        this.buffer = ByteBuffer.allocate(this.bufferSize);
        this.future = BlockingPipedOutputStream.writeAsync(ClickHouseChecker.nonNull(writer, "Writer"), this);
    }

    private void updateBuffer(boolean allocateNewBuffer) throws IOException {
        ByteBuffer b = this.buffer;
        if (b.hasRemaining()) {
            ((Buffer)b).limit(b.position());
        }
        ((Buffer)b).rewind();
        this.updateBuffer(b);
        if (allocateNewBuffer) {
            this.buffer = ByteBuffer.allocate(this.bufferSize);
        }
    }

    private void updateBuffer(ByteBuffer b) throws IOException {
        try {
            if (this.timeout > 0L) {
                if (!this.queue.offer(b, this.timeout, TimeUnit.MILLISECONDS)) {
                    throw new IOException(ClickHouseUtils.format("Write timed out after %d ms", this.timeout));
                }
            } else {
                this.queue.put(b);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Thread was interrupted when putting buffer into queue", e);
        }
    }

    @Override
    public ClickHouseInputStream getInputStream(Runnable postCloseAction) {
        return new BlockingInputStream(this.queue, this.timeout, () -> BlockingPipedOutputStream.handleWriteResult(this.future, this.timeout, postCloseAction));
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.buffer.position() > 0) {
            this.updateBuffer(false);
        }
        try {
            if (this.timeout > 0L) {
                if (!this.queue.offer(ClickHouseByteBuffer.EMPTY_BUFFER, this.timeout, TimeUnit.MILLISECONDS)) {
                    throw new IOException(ClickHouseUtils.format("Close stream timed out after %d ms", this.timeout));
                }
            } else {
                this.queue.put(ClickHouseByteBuffer.EMPTY_BUFFER);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Thread was interrupted when putting EMPTY buffer into queue", e);
        }
        finally {
            this.closed = true;
            ClickHouseDataStreamFactory.handleCustomAction(this.postCloseAction);
        }
    }

    @Override
    public void flush() throws IOException {
        this.ensureOpen();
        if (this.buffer.position() > 0) {
            this.updateBuffer(true);
        }
    }

    @Override
    public ClickHouseOutputStream transferBytes(byte[] bytes, int offset, int length) throws IOException {
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || length < 0 || length > bytes.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return this;
        }
        this.ensureOpen();
        ByteBuffer b = this.buffer;
        if (b.position() > 0) {
            this.updateBuffer(true);
        }
        this.updateBuffer(ByteBuffer.wrap(bytes, offset, length));
        return this;
    }

    @Override
    public ClickHouseOutputStream writeByte(byte b) throws IOException {
        this.ensureOpen();
        this.buffer.put(b);
        if (!this.buffer.hasRemaining()) {
            this.updateBuffer(true);
        }
        return this;
    }

    @Override
    public ClickHouseOutputStream writeBytes(byte[] bytes, int offset, int length) throws IOException {
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || length < 0 || length > bytes.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return this;
        }
        this.ensureOpen();
        ByteBuffer b = this.buffer;
        while (length > 0) {
            int remain = b.remaining();
            if (length < remain) {
                b.put(bytes, offset, length);
                length = 0;
                continue;
            }
            if (b.position() == 0 && length >= b.remaining()) {
                b.put(bytes, offset, remain);
                offset += remain;
                length -= remain;
                this.updateBuffer(true);
                b = this.buffer;
                continue;
            }
            b.put(bytes, offset, remain);
            offset += remain;
            length -= remain;
            this.updateBuffer(true);
            b = this.buffer;
        }
        return this;
    }

    @Override
    public ClickHouseOutputStream writeCustom(ClickHouseDataUpdater writer) throws IOException {
        this.ensureOpen();
        int position = 0;
        int written = 0;
        do {
            byte[] bytes;
            position = this.buffer.position();
            int limit = this.buffer.limit();
            if (this.buffer.hasArray()) {
                bytes = this.buffer.array();
            } else {
                bytes = new byte[limit - position];
                this.buffer.get(bytes);
            }
            written = writer.update(bytes, position, limit);
            if (written >= 0) continue;
            ((Buffer)this.buffer).position(limit);
            this.updateBuffer(true);
        } while (written < 0);
        ((Buffer)this.buffer).position(position + written);
        return this;
    }
}

