/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.stream;

import com.clickhouse.data.ClickHouseByteBuffer;
import com.clickhouse.data.ClickHouseByteUtils;
import com.clickhouse.data.ClickHouseDataUpdater;
import com.clickhouse.data.ClickHouseFile;
import com.clickhouse.data.ClickHouseInputStream;
import com.clickhouse.data.ClickHouseUtils;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedList;

@Deprecated
public abstract class AbstractByteBufferInputStream
extends ClickHouseInputStream {
    protected ByteBuffer buffer = null;

    protected AbstractByteBufferInputStream(ClickHouseFile file, OutputStream copyTo, Runnable postCloseAction) {
        super(file, copyTo, postCloseAction);
    }

    @Override
    protected void ensureOpen() throws IOException {
        super.ensureOpen();
        if (this.buffer == null || this.buffer != ClickHouseByteBuffer.EMPTY_BUFFER && !this.buffer.hasRemaining()) {
            this.updateBuffer();
        }
    }

    @Override
    protected ClickHouseByteBuffer getBuffer() {
        return this.byteBuffer.update(this.buffer);
    }

    @Override
    protected ClickHouseByteBuffer nextBuffer() throws IOException {
        if (this.closed) {
            return this.byteBuffer.reset();
        }
        if (this.buffer != null && this.buffer.hasRemaining() || this.updateBuffer() > 0) {
            this.byteBuffer.update(this.buffer);
            ((Buffer)this.buffer).position(this.buffer.limit());
        } else {
            this.byteBuffer.setLength(0);
        }
        return this.byteBuffer;
    }

    protected abstract int updateBuffer() throws IOException;

    @Override
    public int available() throws IOException {
        if (this.closed || this.buffer == ClickHouseByteBuffer.EMPTY_BUFFER) {
            return 0;
        }
        return this.buffer != null && this.buffer.hasRemaining() ? this.buffer.remaining() : this.updateBuffer();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        super.close();
    }

    @Override
    public int peek() throws IOException {
        this.ensureOpen();
        if (this.buffer == ClickHouseByteBuffer.EMPTY_BUFFER) {
            return -1;
        }
        int b = 0xFF & this.buffer.get();
        ((Buffer)this.buffer).position(this.buffer.position() - 1);
        return b;
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        return this.buffer == ClickHouseByteBuffer.EMPTY_BUFFER ? -1 : 0xFF & this.buffer.get();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException("Non-null byte array is required");
        }
        if (this.buffer != null && this.buffer.hasArray() && this.buffer.array() == b) {
            throw new IllegalArgumentException("Please pass a different byte array instead of the same internal buffer for reading");
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        this.ensureOpen();
        int offset = off;
        while (len > 0) {
            if (this.buffer == ClickHouseByteBuffer.EMPTY_BUFFER) {
                return off > offset ? off - offset : -1;
            }
            int remain = this.buffer.remaining();
            if (remain >= len) {
                this.buffer.get(b, off, len);
                off += len;
                break;
            }
            this.buffer.get(b, off, remain);
            off += remain;
            len -= remain;
            this.updateBuffer();
        }
        return off - offset;
    }

    @Override
    public ClickHouseByteBuffer readBuffer(int length) throws IOException {
        if (length < 1) {
            return this.byteBuffer.reset();
        }
        this.ensureOpen();
        if (this.buffer == ClickHouseByteBuffer.EMPTY_BUFFER) {
            this.closeQuietly();
            throw new EOFException();
        }
        if (this.buffer.remaining() >= length && this.buffer.hasArray()) {
            int position = this.buffer.position();
            this.byteBuffer.update(this.buffer.array(), position, length);
            ((Buffer)this.buffer).position(position + length);
        } else {
            this.byteBuffer.update(this.readBytes(length));
        }
        return this.byteBuffer;
    }

    @Override
    public ClickHouseByteBuffer readBufferUntil(byte[] separator) throws IOException {
        if (separator == null || separator.length < 1) {
            return this.byteBuffer.reset();
        }
        this.ensureOpen();
        int slen = separator.length;
        LinkedList<byte[]> list = new LinkedList<byte[]>();
        int length = 0;
        boolean more = true;
        block0: while (more) {
            int remain = this.buffer.remaining();
            if (remain < 1) {
                this.closeQuietly();
                more = false;
                continue;
            }
            int position = this.buffer.position();
            int limit = this.buffer.limit();
            byte[] bytes = ClickHouseByteUtils.getOrCopy(this.buffer, remain);
            int read = ClickHouseByteUtils.indexOf(bytes, 0, remain, separator, 0, slen, true);
            int missed = 0;
            if (read == -1 || (missed = slen + read - limit) > 0) {
                while (true) {
                    list.add(bytes);
                    length += remain;
                    ((Buffer)this.buffer).position(limit);
                    remain = this.updateBuffer();
                    if (remain < 1) {
                        this.closeQuietly();
                        more = false;
                        continue block0;
                    }
                    if (missed <= 0) continue block0;
                    bytes = ClickHouseByteUtils.getOrCopy(this.buffer, remain);
                    if (remain >= missed) break;
                    if (ClickHouseByteUtils.equals(bytes, 0, missed, separator, slen - missed, slen - missed + missed)) {
                        missed -= remain;
                        continue;
                    }
                    missed = 0;
                }
                if (!ClickHouseByteUtils.equals(bytes, 0, missed, separator, slen - missed, slen)) continue;
                length += missed;
                ((Buffer)this.buffer).position(missed);
                list.add(Arrays.copyOfRange(bytes, 0, missed));
                more = false;
                continue;
            }
            list.add(bytes);
            length += (read += slen);
            ((Buffer)this.buffer).position(position + read);
            more = false;
        }
        return this.byteBuffer.update(list, 0, length);
    }

    @Override
    public ClickHouseByteBuffer readCustom(ClickHouseDataUpdater reader) throws IOException {
        if (reader == null) {
            return this.byteBuffer.reset();
        }
        this.ensureOpen();
        LinkedList<byte[]> list = new LinkedList<byte[]>();
        int length = 0;
        boolean more = true;
        while (more) {
            int remain = this.buffer.remaining();
            if (remain < 1) {
                this.closeQuietly();
                more = false;
                continue;
            }
            int position = this.buffer.position();
            int limit = this.buffer.limit();
            byte[] bytes = ClickHouseByteUtils.getOrCopy(this.buffer, remain);
            int read = reader.update(bytes, 0, remain);
            if (read == -1) {
                list.add(bytes);
                length += remain;
                ((Buffer)this.buffer).position(limit);
                if (this.updateBuffer() >= 1) continue;
                this.closeQuietly();
                more = false;
                continue;
            }
            if (read > 0) {
                list.add(Arrays.copyOfRange(bytes, 0, read));
                length += read;
                ((Buffer)this.buffer).position(position + read);
            }
            more = false;
        }
        return this.byteBuffer.update(list, 0, length);
    }

    @Override
    public byte readByte() throws IOException {
        this.ensureOpen();
        if (this.buffer == ClickHouseByteBuffer.EMPTY_BUFFER) {
            this.closeQuietly();
            throw new EOFException();
        }
        return this.buffer.get();
    }

    @Override
    public byte[] readBytes(int length) throws IOException {
        if (length < 1) {
            return ClickHouseByteBuffer.EMPTY_BYTES;
        }
        this.ensureOpen();
        byte[] bytes = new byte[length];
        int offset = 0;
        ByteBuffer b = this.buffer;
        int remain = b.remaining();
        while (length > 0) {
            if (b == ClickHouseByteBuffer.EMPTY_BUFFER) {
                this.closeQuietly();
                throw offset == 0 ? new EOFException() : new StreamCorruptedException(ClickHouseUtils.format("Reached end of input stream after reading %d of %d bytes", offset, bytes.length));
            }
            if (remain >= length) {
                b.get(bytes, offset, length);
                offset += length;
                length = 0;
                continue;
            }
            b.get(bytes, offset, remain);
            offset += remain;
            length -= remain;
            remain = this.updateBuffer();
            b = this.buffer;
        }
        return bytes;
    }

    @Override
    public long skip(long n) throws IOException {
        this.ensureOpen();
        if (n == Long.MAX_VALUE) {
            long counter = this.buffer.remaining();
            while (this.buffer != ClickHouseByteBuffer.EMPTY_BUFFER) {
                counter += (long)this.updateBuffer();
            }
            return counter;
        }
        return super.skip(n);
    }
}

