/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.format;

import com.clickhouse.config.ClickHouseRenameMethod;
import com.clickhouse.data.ClickHouseByteBuffer;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseDataConfig;
import com.clickhouse.data.ClickHouseDataProcessor;
import com.clickhouse.data.ClickHouseDataType;
import com.clickhouse.data.ClickHouseDeserializer;
import com.clickhouse.data.ClickHouseFormat;
import com.clickhouse.data.ClickHouseInputStream;
import com.clickhouse.data.ClickHouseOutputStream;
import com.clickhouse.data.ClickHouseRecord;
import com.clickhouse.data.ClickHouseSerializer;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.data.ClickHouseValue;
import com.clickhouse.data.format.TextDataProcessor;
import com.clickhouse.data.format.tsv.ByteFragment;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Deprecated
public class ClickHouseTabSeparatedProcessor
extends ClickHouseDataProcessor {
    private final TextDataProcessor.TextSerDe text;
    private ByteFragment currentRow;

    private static String[] toStringArray(ByteFragment headerFragment, byte delimitter) {
        if (delimitter == 0) {
            return new String[]{headerFragment.asString(true)};
        }
        ByteFragment[] split = headerFragment.split(delimitter);
        String[] array = new String[split.length];
        for (int i = 0; i < split.length; ++i) {
            array[i] = split[i].asString(true);
        }
        return array;
    }

    @Override
    protected void readAndFill(ClickHouseRecord r) throws IOException {
        ClickHouseByteBuffer buf = this.input.readCustom(this.text::readRecord);
        if (buf.isEmpty() && this.input.available() < 1) {
            throw new EOFException();
        }
        this.currentRow = new ByteFragment(buf.array(), buf.position(), buf.lastByte() == this.text.getRecordSeparator() ? buf.length() - 1 : buf.length());
        int len = this.serde.columns.length;
        int index = this.readPosition;
        ByteFragment[] currentCols = len > 1 && this.text.hasValueSeparator() ? this.currentRow.split(this.text.getValueSeparator()) : new ByteFragment[]{this.currentRow};
        int i = index;
        while (i < len) {
            r.getValue(i).update(currentCols[i - index].asString(true));
            this.readPosition = i++;
        }
        this.readPosition = 0;
    }

    @Override
    protected void readAndFill(ClickHouseValue value) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected List<ClickHouseColumn> readColumns() throws IOException {
        String[] types;
        String[] cols;
        block10: {
            ClickHouseByteBuffer buf;
            block9: {
                if (this.input.available() < 1) {
                    this.input.close();
                    return Collections.emptyList();
                }
                ClickHouseFormat format = this.config.getFormat();
                if (!format.hasHeader()) {
                    return DEFAULT_COLUMNS;
                }
                buf = this.input.readCustom(this.text::readRecord);
                if (buf.isEmpty()) {
                    this.input.close();
                    return Collections.emptyList();
                }
                ByteFragment headerFragment = new ByteFragment(buf.array(), buf.position(), buf.lastByte() == this.text.getRecordSeparator() ? buf.length() - 1 : buf.length());
                String header = headerFragment.asString(true);
                if (header.startsWith("Code: ") && !header.contains("\t")) {
                    this.input.close();
                    throw new IllegalArgumentException("ClickHouse error: " + header);
                }
                cols = ClickHouseTabSeparatedProcessor.toStringArray(headerFragment, this.text.getValueSeparator());
                types = null;
                if (ClickHouseFormat.TSVWithNamesAndTypes == format) break block9;
                if (ClickHouseFormat.TabSeparatedWithNamesAndTypes != format) break block10;
            }
            if ((buf = this.input.readCustom(this.text::readRecord)).isEmpty()) {
                this.input.close();
                throw new IllegalArgumentException("ClickHouse response without column types");
            }
            ByteFragment typesFragment = new ByteFragment(buf.array(), buf.position(), buf.lastByte() == this.text.getRecordSeparator() ? buf.length() - 1 : buf.length());
            types = ClickHouseTabSeparatedProcessor.toStringArray(typesFragment, this.text.getValueSeparator());
        }
        ClickHouseRenameMethod m = this.config.getColumnRenameMethod();
        ArrayList<ClickHouseColumn> list = new ArrayList<ClickHouseColumn>(cols.length);
        for (int i = 0; i < cols.length; ++i) {
            list.add(ClickHouseColumn.of(m.rename(cols[i]), (String)(types == null ? "Nullable(String)" : types[i])));
        }
        return list;
    }

    public ClickHouseTabSeparatedProcessor(ClickHouseDataConfig config, ClickHouseInputStream input, ClickHouseOutputStream output, List<ClickHouseColumn> columns, Map<String, Serializable> settings) throws IOException {
        super(config, input, output, columns, settings);
        this.text = TextDataProcessor.getTextSerDe(config.getFormat());
    }

    @Override
    public void write(ClickHouseValue value) throws IOException {
        if (this.output == null) {
            throw new IllegalStateException("No output stream available to write");
        }
        ClickHouseDataProcessor.DefaultSerDe s = this.getInitializedSerDe();
        int len = s.columns.length;
        int pos = this.writePosition;
        if (len == 0 || pos >= len) {
            throw new IllegalStateException(ClickHouseUtils.format("No column to write(total=%d, writePosition=%d)", len, pos));
        }
        if (value == null) {
            value = this.config.isReuseValueWrapper() ? s.templates[pos] : s.templates[pos].copy();
        }
        this.text.serialize(value, this.output);
        if (++pos >= len) {
            this.output.writeByte(this.text.getRecordSeparator());
            this.writePosition = 0;
        } else {
            this.output.writeByte(this.text.getValueSeparator());
            this.writePosition = pos;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public ClickHouseDeserializer getDeserializer(ClickHouseDataConfig config, ClickHouseColumn column) {
        ClickHouseDeserializer clickHouseDeserializer;
        block3: {
            block2: {
                ClickHouseDataType dt = column.getDataType();
                if (dt == ClickHouseDataType.FixedString) break block2;
                if (!config.isUseBinaryString() || dt != ClickHouseDataType.String) break block3;
            }
            clickHouseDeserializer = this.text::deserializeBinary;
            return clickHouseDeserializer;
        }
        clickHouseDeserializer = this.text;
        return clickHouseDeserializer;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public ClickHouseSerializer getSerializer(ClickHouseDataConfig config, ClickHouseColumn column) {
        ClickHouseSerializer clickHouseSerializer;
        block3: {
            block2: {
                ClickHouseDataType dt = column.getDataType();
                if (dt == ClickHouseDataType.FixedString) break block2;
                if (!config.isUseBinaryString() || dt != ClickHouseDataType.String) break block3;
            }
            clickHouseSerializer = this.text::serializeBinary;
            return clickHouseSerializer;
        }
        clickHouseSerializer = this.text;
        return clickHouseSerializer;
    }
}

