/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data;

import java.util.Locale;

@Deprecated
public enum ClickHouseCompression {
    NONE("", "", ""),
    BROTLI("application/x-brotli", "br", "br"),
    BZ2("application/x-bzip2", "bz2", "bz2"),
    DEFLATE("application/deflate", "deflate", "zz"),
    GZIP("application/gzip", "gzip", "gz"),
    LZ4("application/x-lz4", "lz4", "lz4"),
    SNAPPY("application/x-snappy", "snappy", "sz"),
    XZ("application/x-xz", "xz", "xz"),
    ZSTD("application/zstd", "zstd", "zst");

    private String mimeType;
    private String encoding;
    private String fileExt;
    private String fileExtWithDot;

    private ClickHouseCompression(String mimeType, String encoding, String fileExt) {
        this.mimeType = mimeType;
        this.encoding = encoding;
        this.fileExt = fileExt;
        this.fileExtWithDot = ".".concat(fileExt);
    }

    public String mimeType() {
        return this.mimeType;
    }

    public String encoding() {
        return this.encoding;
    }

    public String fileExtension() {
        return this.fileExtension(true);
    }

    public String fileExtension(boolean withDot) {
        return withDot ? this.fileExtWithDot : this.fileExt;
    }

    public static ClickHouseCompression fromMimeType(String mimeType) {
        ClickHouseCompression compression = NONE;
        if (mimeType != null) {
            for (ClickHouseCompression c : ClickHouseCompression.values()) {
                if (!c.mimeType.equals(mimeType)) continue;
                compression = c;
                break;
            }
        }
        return compression;
    }

    public static ClickHouseCompression fromEncoding(String encoding) {
        ClickHouseCompression compression = NONE;
        if (encoding != null) {
            for (ClickHouseCompression c : ClickHouseCompression.values()) {
                if (!c.encoding.equals(encoding)) continue;
                compression = c;
                break;
            }
        }
        return compression;
    }

    public static ClickHouseCompression fromFileName(String file) {
        ClickHouseCompression compression = null;
        int index = 0;
        if (file != null && (index = file.lastIndexOf(46)) > 0) {
            String ext = file.substring(index + 1).toLowerCase(Locale.ROOT);
            for (ClickHouseCompression c : ClickHouseCompression.values()) {
                if (!c.fileExt.equals(ext)) continue;
                compression = c;
                break;
            }
        }
        return compression;
    }
}

