/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.google.common.collect;

import com.clickhouse.client.internal.google.common.annotations.GwtCompatible;
import com.clickhouse.client.internal.google.common.annotations.GwtIncompatible;
import com.clickhouse.client.internal.google.common.annotations.J2ktIncompatible;
import com.clickhouse.client.internal.google.common.base.Preconditions;
import com.clickhouse.client.internal.google.common.collect.Ordering;
import com.clickhouse.client.internal.google.common.collect.ReverseNaturalOrdering;
import com.clickhouse.client.internal.google.errorprone.annotations.concurrent.LazyInit;
import java.io.Serializable;
import org.jspecify.annotations.Nullable;

@GwtCompatible(serializable=true)
final class NaturalOrdering
extends Ordering<Comparable<?>>
implements Serializable {
    static final NaturalOrdering INSTANCE = new NaturalOrdering();
    @LazyInit
    private transient @Nullable Ordering<@Nullable Comparable<?>> nullsFirst;
    @LazyInit
    private transient @Nullable Ordering<@Nullable Comparable<?>> nullsLast;
    @GwtIncompatible
    @J2ktIncompatible
    private static final long serialVersionUID = 0L;

    @Override
    public int compare(Comparable<?> left, Comparable<?> right) {
        Preconditions.checkNotNull(left);
        Preconditions.checkNotNull(right);
        return left.compareTo(right);
    }

    @Override
    public <S extends Comparable<?>> Ordering<@Nullable S> nullsFirst() {
        Ordering<@Nullable Comparable<Object>> result = this.nullsFirst;
        if (result == null) {
            result = this.nullsFirst = super.nullsFirst();
        }
        return result;
    }

    @Override
    public <S extends Comparable<?>> Ordering<@Nullable S> nullsLast() {
        Ordering<@Nullable Comparable<Object>> result = this.nullsLast;
        if (result == null) {
            result = this.nullsLast = super.nullsLast();
        }
        return result;
    }

    @Override
    public <S extends Comparable<?>> Ordering<S> reverse() {
        return ReverseNaturalOrdering.INSTANCE;
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public String toString() {
        return "Ordering.natural()";
    }

    private NaturalOrdering() {
    }
}

