/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.windows;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.streaming.api.windowing.assigners.MergingWindowAssigner;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.util.MathUtils;

@PublicEvolving
public class TimeWindow
extends Window {
    private final long start;
    private final long end;

    public TimeWindow(long start, long end) {
        this.start = start;
        this.end = end;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    @Override
    public long maxTimestamp() {
        return this.end - 1L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeWindow window = (TimeWindow)o;
        return this.end == window.end && this.start == window.start;
    }

    public int hashCode() {
        return MathUtils.longToIntWithBitMixing((long)(this.start + this.end));
    }

    public String toString() {
        return "TimeWindow{start=" + this.start + ", end=" + this.end + '}';
    }

    public boolean intersects(TimeWindow other) {
        return this.start <= other.end && this.end >= other.start;
    }

    public TimeWindow cover(TimeWindow other) {
        return new TimeWindow(Math.min(this.start, other.start), Math.max(this.end, other.end));
    }

    public static void mergeWindows(Collection<TimeWindow> windows, MergingWindowAssigner.MergeCallback<TimeWindow> c) {
        ArrayList<TimeWindow> sortedWindows = new ArrayList<TimeWindow>(windows);
        Collections.sort(sortedWindows, new Comparator<TimeWindow>(){

            @Override
            public int compare(TimeWindow o1, TimeWindow o2) {
                return Long.compare(o1.getStart(), o2.getStart());
            }
        });
        ArrayList<Tuple2> merged = new ArrayList<Tuple2>();
        Tuple2 currentMerge = null;
        for (TimeWindow candidate : sortedWindows) {
            if (currentMerge == null) {
                currentMerge = new Tuple2();
                currentMerge.f0 = candidate;
                currentMerge.f1 = new HashSet();
                ((Set)currentMerge.f1).add(candidate);
                continue;
            }
            if (((TimeWindow)currentMerge.f0).intersects(candidate)) {
                currentMerge.f0 = ((TimeWindow)currentMerge.f0).cover(candidate);
                ((Set)currentMerge.f1).add(candidate);
                continue;
            }
            merged.add(currentMerge);
            currentMerge = new Tuple2();
            currentMerge.f0 = candidate;
            currentMerge.f1 = new HashSet();
            ((Set)currentMerge.f1).add(candidate);
        }
        if (currentMerge != null) {
            merged.add(currentMerge);
        }
        for (Tuple2 m : merged) {
            if (((Set)m.f1).size() <= 1) continue;
            c.merge((Collection)m.f1, (TimeWindow)m.f0);
        }
    }

    public static long getWindowStartWithOffset(long timestamp, long offset, long windowSize) {
        long remainder = (timestamp - offset) % windowSize;
        if (remainder < 0L) {
            return timestamp - (remainder + windowSize);
        }
        return timestamp - remainder;
    }

    public static class Serializer
    extends TypeSerializerSingleton<TimeWindow> {
        private static final long serialVersionUID = 1L;

        public boolean isImmutableType() {
            return true;
        }

        public TimeWindow createInstance() {
            return new TimeWindow(0L, 1L);
        }

        public TimeWindow copy(TimeWindow from) {
            return from;
        }

        public TimeWindow copy(TimeWindow from, TimeWindow reuse) {
            return from;
        }

        public int getLength() {
            return 16;
        }

        public void serialize(TimeWindow record, DataOutputView target) throws IOException {
            target.writeLong(record.start);
            target.writeLong(record.end);
        }

        public TimeWindow deserialize(DataInputView source) throws IOException {
            long start = source.readLong();
            long end = source.readLong();
            return new TimeWindow(start, end);
        }

        public TimeWindow deserialize(TimeWindow reuse, DataInputView source) throws IOException {
            return this.deserialize(source);
        }

        public void copy(DataInputView source, DataOutputView target) throws IOException {
            target.writeLong(source.readLong());
            target.writeLong(source.readLong());
        }

        public TypeSerializerSnapshot<TimeWindow> snapshotConfiguration() {
            return new TimeWindowSerializerSnapshot();
        }

        public static final class TimeWindowSerializerSnapshot
        extends SimpleTypeSerializerSnapshot<TimeWindow> {
            public TimeWindowSerializerSnapshot() {
                super(Serializer::new);
            }
        }
    }
}

