/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.Optional;
import java.util.function.Supplier;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.operators.coordination.OperatorEventDispatcher;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.api.operators.YieldingOperatorFactory;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeServiceAware;
import org.apache.flink.streaming.runtime.tasks.StreamTask;

public class StreamOperatorFactoryUtil {
    public static <OUT, OP extends StreamOperator<OUT>> Tuple2<OP, Optional<ProcessingTimeService>> createOperator(StreamOperatorFactory<OUT> operatorFactory, StreamTask<OUT, ?> containingTask, StreamConfig configuration, Output<StreamRecord<OUT>> output, OperatorEventDispatcher operatorEventDispatcher) {
        ProcessingTimeService processingTimeService;
        MailboxExecutor mailboxExecutor = containingTask.getMailboxExecutorFactory().createExecutor(configuration.getChainIndex());
        if (operatorFactory instanceof YieldingOperatorFactory) {
            ((YieldingOperatorFactory)operatorFactory).setMailboxExecutor(mailboxExecutor);
        }
        Supplier<ProcessingTimeService> processingTimeServiceFactory = () -> containingTask.getProcessingTimeServiceFactory().createProcessingTimeService(mailboxExecutor);
        if (operatorFactory instanceof ProcessingTimeServiceAware) {
            processingTimeService = processingTimeServiceFactory.get();
            ((ProcessingTimeServiceAware)((Object)operatorFactory)).setProcessingTimeService(processingTimeService);
        } else {
            processingTimeService = null;
        }
        Object op = operatorFactory.createStreamOperator(new StreamOperatorParameters<OUT>(containingTask, configuration, output, processingTimeService != null ? () -> processingTimeService : processingTimeServiceFactory, operatorEventDispatcher));
        return new Tuple2(op, Optional.ofNullable(processingTimeService));
    }
}

