/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.common.operators.SlotSharingGroup;
import org.apache.flink.api.common.operators.util.OperatorValidationUtils;
import org.apache.flink.api.connector.sink.Sink;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.datastream.CustomSinkOperatorUidHashes;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.StreamSink;
import org.apache.flink.streaming.api.transformations.LegacySinkTransformation;
import org.apache.flink.streaming.api.transformations.PhysicalTransformation;
import org.apache.flink.streaming.api.transformations.SinkTransformation;
import org.apache.flink.streaming.api.transformations.SinkV1Adapter;
import org.apache.flink.util.Preconditions;

@Public
public class DataStreamSink<T> {
    private final PhysicalTransformation<T> transformation;

    protected DataStreamSink(PhysicalTransformation<T> transformation) {
        this.transformation = (PhysicalTransformation)((Object)Preconditions.checkNotNull(transformation));
    }

    static <T> DataStreamSink<T> forSinkFunction(DataStream<T> inputStream, SinkFunction<T> sinkFunction) {
        StreamSink<T> sinkOperator = new StreamSink<T>(sinkFunction);
        StreamExecutionEnvironment executionEnvironment = inputStream.getExecutionEnvironment();
        LegacySinkTransformation<T> transformation = new LegacySinkTransformation<T>(inputStream.getTransformation(), "Unnamed", sinkOperator, executionEnvironment.getParallelism(), false);
        executionEnvironment.addOperator(transformation);
        return new DataStreamSink<T>(transformation);
    }

    @Internal
    public static <T> DataStreamSink<T> forSink(DataStream<T> inputStream, org.apache.flink.api.connector.sink2.Sink<T> sink, CustomSinkOperatorUidHashes customSinkOperatorUidHashes) {
        StreamExecutionEnvironment executionEnvironment = inputStream.getExecutionEnvironment();
        SinkTransformation<T, T> transformation = new SinkTransformation<T, T>(inputStream, sink, inputStream.getType(), "Sink", executionEnvironment.getParallelism(), false, customSinkOperatorUidHashes);
        executionEnvironment.addOperator(transformation);
        return new DataStreamSink<T>(transformation);
    }

    @Internal
    public static <T> DataStreamSink<T> forSinkV1(DataStream<T> inputStream, Sink<T, ?, ?, ?> sink, CustomSinkOperatorUidHashes customSinkOperatorUidHashes) {
        return DataStreamSink.forSink(inputStream, SinkV1Adapter.wrap(sink), customSinkOperatorUidHashes);
    }

    @Internal
    public Transformation<T> getTransformation() {
        return this.transformation;
    }

    @Internal
    public LegacySinkTransformation<T> getLegacyTransformation() {
        if (this.transformation instanceof LegacySinkTransformation) {
            return (LegacySinkTransformation)this.transformation;
        }
        throw new IllegalStateException("There is no the LegacySinkTransformation.");
    }

    public DataStreamSink<T> name(String name) {
        this.transformation.setName(name);
        return this;
    }

    @PublicEvolving
    public DataStreamSink<T> uid(String uid) {
        this.transformation.setUid(uid);
        return this;
    }

    @PublicEvolving
    public DataStreamSink<T> setUidHash(String uidHash) {
        if (!(this.transformation instanceof LegacySinkTransformation)) {
            throw new UnsupportedOperationException("Cannot set a custom UID hash on a non-legacy sink");
        }
        this.transformation.setUidHash(uidHash);
        return this;
    }

    public DataStreamSink<T> setParallelism(int parallelism) {
        this.transformation.setParallelism(parallelism);
        return this;
    }

    public DataStreamSink<T> setMaxParallelism(int maxParallelism) {
        OperatorValidationUtils.validateMaxParallelism((int)maxParallelism, (boolean)true);
        this.transformation.setMaxParallelism(maxParallelism);
        return this;
    }

    @PublicEvolving
    public DataStreamSink<T> setDescription(String description) {
        this.transformation.setDescription(description);
        return this;
    }

    private DataStreamSink<T> setResources(ResourceSpec minResources, ResourceSpec preferredResources) {
        this.transformation.setResources(minResources, preferredResources);
        return this;
    }

    private DataStreamSink<T> setResources(ResourceSpec resources) {
        this.transformation.setResources(resources, resources);
        return this;
    }

    @PublicEvolving
    public DataStreamSink<T> disableChaining() {
        this.transformation.setChainingStrategy(ChainingStrategy.NEVER);
        return this;
    }

    @PublicEvolving
    public DataStreamSink<T> slotSharingGroup(String slotSharingGroup) {
        this.transformation.setSlotSharingGroup(slotSharingGroup);
        return this;
    }

    @PublicEvolving
    public DataStreamSink<T> slotSharingGroup(SlotSharingGroup slotSharingGroup) {
        this.transformation.setSlotSharingGroup(slotSharingGroup);
        return this;
    }
}

